/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.dotnet.Constants;
import com.ibm.wala.dotnet.cil.CILInvokeInstruction;
import com.ibm.wala.dotnet.cil.CILLoadIndirectInstruction;
import com.ibm.wala.dotnet.cil.CILStoreIndirectInstruction;
import com.ibm.wala.dotnet.loader.AssemblyClassLoader;
import com.ibm.wala.dotnet.loader.AssemblyModule;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CLRAnalysisScope<C, F, M, A, T>
extends AnalysisScope
implements ClassLoaderFactory {
    private final Map<ClassLoaderReference, AssemblyModule<C, F, M, A, T>> assemblies;
    private final Map<String, ClassLoaderReference> loadersByAssembly = new LinkedHashMap<String, ClassLoaderReference>();
    private final LowLevelInterface<C, F, M, A, T> reader;
    private final Collection<ClassLoaderReference> applicationLoaderRefs = HashSetFactory.make();
    private final Collection<ClassLoaderReference> libraryLoaderRefs = HashSetFactory.make();
    private final Map<A, ClassLoaderReference> imageHandles2loaderRefs;
    private final Map<ClassLoaderReference, AssemblyClassLoader<C, F, M, A, T>> loaders = HashMapFactory.make();
    final C systemObjectHandle;

    public CLRAnalysisScope(File systemAssembly, Set<File> libAssemblies, Set<File> appAssemblies, LowLevelInterface<C, F, M, A, T> reader) {
        this(systemAssembly, libAssemblies, appAssemblies, new SetOfClasses(){
            private static final long serialVersionUID = 1L;

            public boolean contains(String klassName) {
                return false;
            }

            public void add(String klass) {
                Assertions.UNREACHABLE();
            }
        }, reader);
    }

    public CLRAnalysisScope(File systemAssembly, Set<File> libAssemblies, Set<File> appAssemblies, SetOfClasses exclusions, LowLevelInterface<C, F, M, A, T> reader) {
        super(Collections.singleton(CLRLanguage.lang));
        this.reader = reader;
        this.assemblies = new HashMap<ClassLoaderReference, AssemblyModule<C, F, M, A, T>>();
        if (systemAssembly == null) {
            throw new IllegalArgumentException("systemAssembly is null");
        }
        if (!systemAssembly.exists()) {
            throw new IllegalArgumentException("systemAssembly " + systemAssembly + " does not exist");
        }
        AssemblyModule<C, F, M, A, T> sys = null;
        try {
            sys = new AssemblyModule<C, F, M, A, T>(systemAssembly, reader, exclusions, true, null);
        }
        catch (IllegalArgumentException e) {
            System.err.println("got exception trying to read system assembly " + systemAssembly);
            throw e;
        }
        this.loadersByName.put(Constants.systemName, CLRTypeReference.systemLoader);
        this.loadersByAssembly.put("Root", CLRTypeReference.systemLoader);
        this.loadersByAssembly.put(sys.getClassName(), CLRTypeReference.systemLoader);
        this.loadersByAssembly.put(reader.getSyntheticName(), CLRTypeReference.systemLoader);
        HashSet flatAssemblies = HashSetFactory.make();
        flatAssemblies.addAll(libAssemblies);
        flatAssemblies.addAll(appAssemblies);
        this.imageHandles2loaderRefs = HashMapFactory.make();
        this.imageHandles2loaderRefs.put(sys.getHandle(), CLRTypeReference.systemLoader);
        for (File f : flatAssemblies) {
            AssemblyModule<C, F, M, A, T> mod = new AssemblyModule<C, F, M, A, T>(f, reader, exclusions, false, null);
            ClassLoaderReference modRef = new ClassLoaderReference(Atom.findOrCreateUnicodeAtom((String)mod.getClassName()), Constants.langName, CLRTypeReference.systemLoader);
            this.imageHandles2loaderRefs.put(mod.getHandle(), modRef);
            this.assemblies.put(modRef, mod);
            this.loadersByName.put(modRef.getName(), modRef);
            this.loadersByAssembly.put(mod.getClassName(), modRef);
            if (appAssemblies.contains(f)) {
                this.applicationLoaderRefs.add(modRef);
                continue;
            }
            this.libraryLoaderRefs.add(modRef);
        }
        this.assemblies.put(CLRTypeReference.systemLoader, sys);
        this.systemObjectHandle = sys.getClass("Object", "System");
        this.setExclusions(exclusions);
    }

    public ClassLoaderReference findLoader(A handle) {
        String imageName = this.reader.imageGetAssemblyName(handle);
        if (!this.loadersByAssembly.containsKey(imageName)) {
            this.loadersByAssembly.put(imageName, new ClassLoaderReference(Atom.findOrCreateUnicodeAtom((String)imageName), Constants.langName, CLRTypeReference.systemLoader));
        }
        return this.loadersByAssembly.get(imageName);
    }

    public TypeReference findClass(C handle) {
        A image = this.reader.classGetImage(handle);
        ClassLoaderReference ref = this.findLoader(image);
        assert (ref != null) : "no loader ref for " + this.reader.imageGetAssemblyName(image);
        AssemblyClassLoader<C, F, M, A, T> loader = this.loaders.get(ref);
        return loader.getReference(handle);
    }

    public boolean isApplicationLoader(IClassLoader loader) {
        return this.applicationLoaderRefs.contains(loader.getReference());
    }

    public Collection<ClassLoaderReference> getLoaders() {
        ArrayList<ClassLoaderReference> result = new ArrayList<ClassLoaderReference>(this.loadersByName.size());
        for (Map.Entry e : this.loadersByName.entrySet()) {
            result.add((ClassLoaderReference)e.getValue());
        }
        return result;
    }

    protected CLRClass<C, F, M, A, T> ensureClass(AssemblyClassLoader<C, F, M, A, T> loader, TypeReference ref, C handle) {
        Object imageHandle = loader.getAssembly().reader.classGetImage(handle);
        ClassLoaderReference classLoaderReference = this.imageHandles2loaderRefs.get(imageHandle);
        AssemblyClassLoader<C, F, M, A, T> l = this.loaders.get(classLoaderReference);
        assert (l != null) : classLoaderReference;
        CLRClass result = l.table.get(handle);
        if (result == null) {
            result = new CLRClass<C, F, M, A, T>(handle, ref, l);
            l.table.put(handle, result);
        }
        return result;
    }

    public AssemblyClassLoader<C, F, M, A, T> getLoader(ClassLoaderReference classLoaderReference, IClassHierarchy cha, AnalysisScope scope) throws IOException {
        AssemblyClassLoader<C, F, M, A, T> result = this.loaders.get(classLoaderReference);
        if (result == null) {
            result = new AssemblyClassLoader<C, F, M, A, T>(classLoaderReference, this, this.assemblies.get(classLoaderReference), cha);
            this.loaders.put(classLoaderReference, result);
        }
        return result;
    }

    IndirectionData makeIndirectionData(final CLRMethod<C, F, M, A, T> m) {
        return new IndirectionData(){

            public int[] indirectlyReadLocals(int instructionIndex) {
                IInstruction inst = m.getInstructions()[instructionIndex];
                if (inst instanceof CILLoadIndirectInstruction || inst instanceof CILInvokeInstruction) {
                    return m.getAddressTakenLocals();
                }
                return new int[0];
            }

            public int[] indirectlyWrittenLocals(int instructionIndex) {
                IInstruction inst = m.getInstructions()[instructionIndex];
                if (inst instanceof CILStoreIndirectInstruction || inst instanceof CILInvokeInstruction) {
                    return m.getAddressTakenLocals();
                }
                return new int[0];
            }
        };
    }
}

