/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.classLoader.BytecodeClass;
import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.dotnet.loader.AssemblyClassLoader;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class CLRClass<C, F, M, A, T>
extends BytecodeClass<AssemblyClassLoader<C, F, M, A, T>> {
    protected final C handle;
    private final TypeReference ref;
    private boolean computedFields = false;

    protected CLRClass(C handle, TypeReference ref, AssemblyClassLoader<C, F, M, A, T> loader) {
        super(loader, loader.getClassHierarchy());
        this.handle = handle;
        this.ref = ref;
    }

    public Module getContainer() {
        return ((AssemblyClassLoader)this.loader).getAssembly();
    }

    public Collection<Annotation> getAnnotations() {
        return Arrays.asList(this.getAttributes());
    }

    public Collection<Annotation> getAnnotations(boolean runtime) {
        return this.getAnnotations();
    }

    protected List<IField> findDeclaredField(Atom name) {
        this.computeFieldsIfNeeded();
        return super.findDeclaredField(name);
    }

    public Collection<IField> getDeclaredInstanceFields() {
        this.computeFieldsIfNeeded();
        return super.getDeclaredInstanceFields();
    }

    public Collection<IField> getDeclaredStaticFields() {
        this.computeFieldsIfNeeded();
        return super.getDeclaredStaticFields();
    }

    private void computeFieldsIfNeeded() {
        if (!this.computedFields) {
            this.computeFields();
            this.computedFields = true;
        }
    }

    protected void registerField(List<FieldImpl> L, Atom name, TypeReference type, int accessFlags, Collection<Annotation> annotations) {
        FieldReference fr = FieldReference.findOrCreate((TypeReference)this.getReference(), (Atom)name, (TypeReference)type);
        FieldImpl f = new FieldImpl((IClass)this, fr, accessFlags, annotations);
        L.add(f);
    }

    private void computeFields() {
        F[] declaredStaticFields;
        F[] declaredInstanceFields;
        ArrayList<FieldImpl> l1 = new ArrayList<FieldImpl>();
        for (F f : declaredInstanceFields = this.getReader().classGetDeclaredInstanceFields(this.handle)) {
            String fieldName = this.getReader().fieldGetName(f);
            C fieldTypeHandle = this.getReader().fieldGetType(f);
            TypeReference fieldType = this.getClassLoader().getReference(fieldTypeHandle);
            Collection<Annotation> annot = this.getAnnotations(f);
            this.registerField(l1, Atom.findOrCreateUnicodeAtom((String)fieldName), fieldType, this.computeAccessFlags(f), annot);
        }
        this.instanceFields = new IField[l1.size()];
        for (int index = 0; index < declaredInstanceFields.length; ++index) {
            this.instanceFields[index] = (IField)l1.get(index);
        }
        LinkedList<FieldImpl> l2 = new LinkedList<FieldImpl>();
        for (F f : declaredStaticFields = this.getReader().classGetDeclaredStaticFields(this.handle)) {
            String fieldName = this.getReader().fieldGetName(f);
            C fieldTypeHandle = this.getReader().fieldGetType(f);
            TypeReference fieldType = this.getClassLoader().getReference(fieldTypeHandle);
            Collection<Annotation> annot = this.getAnnotations(f);
            this.registerField(l2, Atom.findOrCreateUnicodeAtom((String)fieldName), fieldType, this.computeAccessFlags(f) + 8, annot);
        }
        this.staticFields = new IField[l2.size()];
        for (int index = 0; index < declaredStaticFields.length; ++index) {
            this.staticFields[index] = (IField)l2.get(index);
        }
    }

    private Collection<Annotation> getAnnotations(F f) {
        Set<Annotation> annot;
        T[] attrDescs = this.getReader().fieldGetCustomAttributes(f);
        Annotation[] attrs = this.getClassLoader().instantiateAttributes(attrDescs);
        if (attrs != null) {
            annot = new HashSet();
            for (Annotation a : attrs) {
                annot.add(a);
            }
        } else {
            annot = Collections.emptySet();
        }
        return annot;
    }

    private int computeAccessFlags(F f) {
        int result = 0;
        if (((AssemblyClassLoader)this.loader).getAssembly().getReader().fieldIsFinal(f)) {
            result += 16;
        }
        if (((AssemblyClassLoader)this.loader).getAssembly().getReader().fieldIsProtected(f)) {
            result += 4;
        }
        if (((AssemblyClassLoader)this.loader).getAssembly().getReader().fieldIsPublic(f)) {
            ++result;
        }
        return result;
    }

    private LowLevelInterface<C, F, M, A, T> getReader() {
        return ((AssemblyClassLoader)this.loader).getAssembly().reader;
    }

    public AssemblyClassLoader<C, F, M, A, T> getClassLoader() {
        return (AssemblyClassLoader)this.loader;
    }

    private IClass findClass(C handle) {
        CLRAnalysisScope scope = this.getClassLoader().scope;
        TypeReference r = scope.findClass(handle);
        if (r == null) {
            return null;
        }
        try {
            IClassLoader theLoader = scope.getLoader(r.getClassLoader(), this.getClassHierarchy(), scope);
            return theLoader.ensureClass(r, handle);
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public CLRClass<C, F, M, A, T> getSuperclass() {
        if (this.getReference().equals((Object)CLRTypeReference.SystemObject)) {
            return null;
        }
        if (this.superClass != null) {
            return (CLRClass)this.superClass;
        }
        C superHandle = this.getReader().classGetParent(this.handle);
        assert (superHandle != this.handle);
        if (this.getReader().classNotValid(superHandle) || (this.superClass = this.findClass(superHandle)) == null) {
            this.superClass = this.getClassLoader().scope.ensureClass(this.getClassLoader(), CLRTypeReference.SystemObject, this.getClassLoader().scope.systemObjectHandle);
        }
        return (CLRClass)this.superClass;
    }

    public TypeName getName() {
        return this.getReference().getName();
    }

    public TypeReference getReference() {
        return this.ref;
    }

    @Deprecated
    public String getSourceFileName() throws NoSuchElementException {
        return ((AssemblyClassLoader)this.loader).getSourceFileName((IClass)this);
    }

    public CLRMethod<C, F, M, A, T> getClassInitializer() {
        M m = this.getReader().classGetStaticCtor(this.handle);
        if (this.getReader().methodNotValid(m)) {
            return null;
        }
        return new CLRMethod(m, this);
    }

    public boolean isAbstract() {
        return this.getReader().classIsAbstract(this.handle);
    }

    public boolean isInterface() {
        return this.getReader().classIsInterface(this.handle);
    }

    public boolean isPublic() {
        return this.getReader().classIsPublic(this.handle);
    }

    public boolean isPrivate() {
        return this.getReader().classIsPrivate(this.handle);
    }

    public boolean isValueType() {
        return this.getReader().classIsValueType(this.handle);
    }

    public boolean isWith() {
        return this.getReader().classIsWith(this.handle);
    }

    public IClass withGetBase() {
        return this.findClass(this.getReader().withGetBase(this.handle));
    }

    public int withGetNumParams() {
        return this.getReader().withGetNumParams(this.handle);
    }

    public IClass withGetParam(int i) {
        return this.findClass(this.getReader().withGetParam(this.handle, i));
    }

    public Collection<CLRClass<C, F, M, A, T>> getDirectInterfaces() {
        C[] handles = this.getReader().classGetDeclaredInterfaces(this.handle);
        HashSet<CLRClass<C, F, M, A, T>> clss = new HashSet<CLRClass<C, F, M, A, T>>(handles.length);
        for (C c : handles) {
            IClass cls;
            if (this.getReader().classNotValid(c) || (cls = this.findClass(c)) == null) continue;
            clss.add((CLRClass)cls);
        }
        return clss;
    }

    protected IMethod[] computeDeclaredMethods() throws InvalidClassFileException {
        int i;
        M[] instanceHandles = this.getReader().classGetDeclaredInstanceMethods(this.handle);
        M[] staticHandles = this.getReader().classGetDeclaredStaticMethods(this.handle);
        HashSet result = HashSetFactory.make();
        for (i = 0; i < instanceHandles.length; ++i) {
            try {
                result.add(new CLRMethod(instanceHandles[i], this));
                continue;
            }
            catch (Throwable e) {
                Warnings.add((Warning)new Warning(1){

                    public String getMsg() {
                        return "could not add all instance methods for class " + CLRClass.this.getReference().toString();
                    }
                });
            }
        }
        for (i = 0; i < staticHandles.length; ++i) {
            try {
                result.add(new CLRMethod(staticHandles[i], this));
                continue;
            }
            catch (Throwable e) {
                Warnings.add((Warning)new Warning(1){

                    public String getMsg() {
                        return "could not add all static methods for class " + CLRClass.this.getReference().toString();
                    }
                });
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public int getModifiers() {
        throw new UnsupportedOperationException();
    }

    void visitSuperclasses(VoidFunction<CLRClass<C, F, M, A, T>> f) {
        f.apply((Object)this);
        if (this.getSuperclass() != null) {
            this.getSuperclass().visitSuperclasses(f);
        }
        for (CLRClass<C, F, M, A, T> iface : this.getDirectInterfaces()) {
            iface.visitSuperclasses(f);
        }
    }

    public Annotation[] getAttributes() {
        final HashSet x = new HashSet();
        this.visitSuperclasses(new VoidFunction<CLRClass<C, F, M, A, T>>(){

            public void apply(CLRClass<C, F, M, A, T> c) {
                for (Annotation a : c.getDeclaredAttributes()) {
                    x.add(a);
                }
            }
        });
        return x.toArray(new Annotation[x.size()]);
    }

    public Annotation[] getDeclaredAttributes() {
        T[] attrDescs = this.getReader().classGetCustomAttributes(this.handle);
        return this.getClassLoader().instantiateAttributes(attrDescs);
    }
}

