/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.was;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.was.Messages;
import com.ibm.appscan.internal.discovery.was.ProfileUtil;
import com.ibm.appscan.internal.discovery.was.WebSphereProfileStrategy;
import com.ibm.appscan.internal.discovery.was.compilers.WebSphereJSPCompilerDefinition;
import com.ibm.appscan.internal.discovery.was.compilers.WebSphereJSPCompilerType;
import java.io.File;
import java.util.Set;

public class WebSphereStrategy
extends Strategy {
    private static final String PROFILES = "profiles";
    protected File m_home;
    protected IStrategyFactoryRegistry m_registry;
    protected WebSphereJSPCompilerDefinition m_jspCompiler = null;

    public WebSphereStrategy() {
    }

    WebSphereStrategy(File serverHome, IStrategyFactoryRegistry registry, WebSphereJSPCompilerDefinition jspCompiler) {
        this.m_home = serverHome;
        this.m_registry = registry;
        this.m_jspCompiler = jspCompiler;
    }

    protected File getServerHome() {
        return this.m_home;
    }

    public void init(File directory, IStrategyFactoryRegistry registry) {
        this.m_home = directory;
        this.m_registry = registry;
        File serverHome = this.getServerHome();
        if (serverHome != null) {
            this.m_jspCompiler = (WebSphereJSPCompilerDefinition)new WebSphereJSPCompilerType().autoCreate(serverHome.getPath());
        }
    }

    public String getName() {
        return this.m_home.getName();
    }

    public String getType() {
        String version;
        String string = version = this.m_jspCompiler == null ? null : this.m_jspCompiler.getVersion();
        if (version == null) {
            return Messages.getMessage("was.server", new Object[0]);
        }
        return Messages.getMessage("wasX.server", version);
    }

    public String getPath() {
        return this.m_home.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean handlesIncludesExcludes() {
        return true;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        File[] profiles = new File(this.m_home, PROFILES).listFiles();
        if (profiles != null) {
            for (File profile : profiles) {
                if (!ProfileUtil.isProfile(profile)) continue;
                WebSphereProfileStrategy strategy = new WebSphereProfileStrategy(profile, this.m_registry, this.m_jspCompiler);
                CustomTargetInfo info = new CustomTargetInfo();
                info.getIncludes().addAll(proxy.getIncludes());
                info.getExcludes().addAll(proxy.getExcludes());
                proxy.newScanTarget((ScanTargetStrategy)strategy, info);
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

