/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.cloud.service;

import com.hcl.appscan.cloud.service.ISastAgentServices1;
import com.hcl.appscan.cloud.service.JobStatus;
import com.hcl.appscan.cloud.service.Messages;
import com.hcl.appscan.cloud.service.ServiceConstants;
import com.hcl.appscan.cloud.service.data.SastEngineExitCode;
import com.hcl.appscan.cloud.service.data.SastScanData;
import com.hcl.appscan.cloud.service.error.AgentException;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpPart;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class AscpService
implements ISastAgentServices1,
ServiceConstants {
    private HttpClient m_httpClient;
    private String m_serviceUrl;
    private String m_token;
    private IProgress m_progress;

    public AscpService(String serviceUrl, String token) {
        this.m_serviceUrl = serviceUrl;
        this.m_token = token;
        this.m_httpClient = new HttpClient();
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_progress = progress;
    }

    @Override
    public SastScanData getSastScanData(String jobId) throws AgentException {
        try {
            Map<String, String> headers = this.getAuthHeaders();
            headers.put("Accept", "application/json");
            HttpResponse response = this.m_httpClient.get(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/ScanDetails?jobID={0}", jobId), headers, null);
            if (response.isSuccess()) {
                JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
                return new SastScanData(json);
            }
            throw new IOException(Messages.getMessage("failed.fetch.scan.data", new Object[0]));
        }
        catch (IOException | DatatypeConfigurationException | JSONException e) {
            throw new AgentException(e, SastEngineExitCode.RUN_ERROR);
        }
    }

    @Override
    public byte[] getSastScanDataChunk(String jobId, long chunk) throws AgentException {
        try {
            Map<String, String> headers = this.getAuthHeaders();
            headers.put("Accept", "application/json");
            HttpResponse response = this.m_httpClient.get(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/ScanDataChunk?jobID={0}&chunk={1}", jobId, chunk), headers, null);
            if (response.isSuccess()) {
                return response.getRawContent();
            }
            throw new IOException(Messages.getMessage("failed.download.scan.file", new Object[0]));
        }
        catch (IOException e) {
            throw new AgentException(e, SastEngineExitCode.RUN_ERROR);
        }
    }

    @Override
    public String getCacheStorageUri() {
        try {
            Map<String, String> headers = this.getAuthHeaders();
            headers.put("Accept", "text/plain");
            HttpResponse response = this.m_httpClient.get(this.m_serviceUrl + "/api/SastAgents/CacheStorageUri", headers, null);
            if (response.isSuccess()) {
                return response.getResponseBodyAsString();
            }
            throw new IOException(Messages.getMessage("failed.get.cache.uri", new Object[0]));
        }
        catch (IOException e) {
            this.logError(e);
            return null;
        }
    }

    @Override
    public void downloadApplicationFile(String jobId, File toFile) throws AgentException {
        try {
            Map<String, String> headers = this.getAuthHeaders();
            headers.put("Accept", "application/zip");
            HttpResponse response = this.m_httpClient.get(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/DownloadApplicationFile?jobID={0}", jobId), headers, null);
            if (!response.isSuccess()) {
                String error = Messages.getMessage("failed.download.scan.file", jobId, response.getResponseCode());
                this.logFailedResponse(response, error);
                throw new IOException(error);
            }
            response.getResponseBodyAsFile(toFile);
        }
        catch (IOException e) {
            throw new AgentException(Messages.getMessage("failed.download.scan.file", jobId, e.getMessage()), SastEngineExitCode.UNPACK_ERROR);
        }
    }

    @Override
    public void setEngineExitCode(String jobId, SastEngineExitCode exitCode) {
        try {
            this.m_httpClient.post(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/SetEngineExitCode?jobID={0}&exitCode={1}", new Object[]{jobId, exitCode}), this.getAuthHeaders(), null);
        }
        catch (IOException e) {
            this.logError(e);
        }
    }

    @Override
    public void setJobStatus(String jobId, JobStatus status, String message) {
        try {
            Map<String, String> headers = this.getAuthHeaders();
            headers.put("Content-Type", "application/json");
            char[] body = "\"\"".toCharArray();
            HttpResponse response = this.m_httpClient.put(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/SetJobStatus?jobID={0}&jobStatus={1}&scanOperation={2}", new Object[]{jobId, status, "Default"}), headers, body);
            if (!response.isSuccess()) {
                this.logFailedResponse(response, Messages.getMessage("failed.set.job.status", new Object[]{status, jobId}));
            }
        }
        catch (IOException e) {
            this.logError(e);
        }
    }

    @Override
    public JobStatus updateProgress(String executionId, Integer progress) {
        try {
            Map<String, String> headers = this.getAuthHeaders();
            headers.put("Content-Type", "application/json");
            char[] body = progress.toString().toCharArray();
            HttpResponse response = this.m_httpClient.put(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/UpdateProgress?jobID={0}", executionId), headers, body);
            return JobStatus.valueOf(response.getResponseBodyAsString().replaceAll("\"", "").trim());
        }
        catch (IOException e) {
            this.logError(e);
            return JobStatus.None;
        }
    }

    @Override
    public void uploadSastMetrics(String jobId, File file) throws IOException {
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("file", file, "multipart/form-data"));
        Map<String, String> headers = this.getAuthHeaders();
        HttpResponse response = this.m_httpClient.postMultipart(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/UploadSastMetrics?jobID={0}", jobId), headers, parts);
        if (!response.isSuccess()) {
            this.logFailedResponse(response, Messages.getMessage("failed.upload.metrics", jobId));
        }
    }

    @Override
    public void uploadReport(String jobId, File file) throws IOException {
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("file", file, "multipart/form-data"));
        Map<String, String> headers = this.getAuthHeaders();
        HttpResponse response = this.m_httpClient.postMultipart(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/UploadReport?jobID={0}", jobId), headers, parts);
        if (!response.isSuccess()) {
            String error = Messages.getMessage("failed.upload.report", jobId);
            this.logFailedResponse(response, error);
            throw new IOException(error);
        }
    }

    @Override
    public void uploadExecutionLogs(String jobId, File file) throws IOException {
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("logFile", file, "multipart/form-data"));
        Map<String, String> headers = this.getAuthHeaders();
        HttpResponse response = this.m_httpClient.postMultipart(this.m_serviceUrl + MessageFormat.format("/api/SastAgents/UploadExecutionLog?jobID={0}", jobId), headers, parts);
        if (!response.isSuccess()) {
            String error = Messages.getMessage("failed.upload.logs", jobId);
            this.logFailedResponse(response, error);
            throw new IOException(error);
        }
    }

    private Map<String, String> getAuthHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.m_token);
        return headers;
    }

    private void logError(Throwable e) {
        if (this.m_progress != null) {
            this.m_progress.setStatus(new Message(4, e.getMessage()));
        }
    }

    private void logFailedResponse(HttpResponse response, String error) {
        if (this.m_progress == null) {
            return;
        }
        error = error + "\n";
        error = response.hasResponseBody() ? error + response.getResponseBodyAsString() : error + Messages.getMessage("unknown.error", new Object[0]);
        this.m_progress.setStatus(new Message(4, error));
    }
}

