/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.config.LogMergerScanManifest;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class LogMergerScanManifestJson
extends LogMergerScanManifest {
    public LogMergerScanManifestJson(File destination, IScan scan) throws IOException {
        super(destination, scan);
    }

    @Override
    protected String getNewFileName(String supplied_name) {
        return "scan.manifest.json";
    }

    @Override
    protected void saveFile() {
        try {
            JSONObject manifest = new JSONObject();
            JSONObject languages = new JSONObject();
            languages.put("count", this.getLanguageCountWithScanFiles());
            for (String key : this.getLanguageFileMap().keySet()) {
                if (this.getLanguageFileMap().get(key).size() <= 0) continue;
                JSONObject lang = new JSONObject();
                lang.put("name", (Object)key);
                TreeMap<String, IScanFile> sortedScanFileMap = new TreeMap<String, IScanFile>();
                for (IScanFile iScanFile : this.getLanguageFileMap().get(key)) {
                    sortedScanFileMap.put(this.getPathFromScanFile(iScanFile), iScanFile);
                }
                for (Map.Entry entry : sortedScanFileMap.entrySet()) {
                    JSONObject file = new JSONObject();
                    if (((IScanFile)entry.getValue()).getChecksum() == null) {
                        String checksumValue = "";
                        try {
                            checksumValue = ((IScanFile)entry.getValue()).getFile().exists() ? SystemUtil.calculateSHA1((File)((IScanFile)entry.getValue()).getFile()) : (((IScanFile)entry.getValue()).getSourcePath() == null ? SystemUtil.calculateSHA1((File)new File(((IScanFile)entry.getValue()).getAnalysisPath())) : SystemUtil.calculateSHA1((File)new File(((IScanFile)entry.getValue()).getSourcePath())));
                            ((IScanFile)entry.getValue()).setChecksum(checksumValue);
                        }
                        catch (IOException | NoSuchAlgorithmException exception) {
                            // empty catch block
                        }
                    }
                    file.put("file", (Object)entry);
                    file.put("checksum", (Object)((IScanFile)entry.getValue()).getChecksum());
                    lang.append("files_to_analyze", (Object)file);
                }
                languages.append("language", (Object)lang);
            }
            manifest.put("languages", (Map)languages);
            IOUtil.write((String)manifest.toString(true), (File)this.getMergedFile());
        }
        catch (IOException e) {
            this.getLogManager().log((Exception)e);
        }
        catch (JSONException e) {
            this.getLogManager().log((Exception)((Object)e));
        }
    }
}

