/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.custom.scanner.sca;

import com.hcl.appscan.common.thirdpartylib.license.ILicense;
import com.hcl.appscan.common.thirdpartylib.license.LicensesFileWriter;
import com.hcl.appscan.custom.scanner.sca.Messages;
import com.hcl.appscan.custom.scanner.sca.data.Library;
import com.hcl.appscan.custom.scanner.sca.data.SCALicense;
import com.hcl.appscan.custom.scanner.sca.data.SCAVulnerability;
import com.ibm.appscan.assessment.AssessmentException;
import com.ibm.appscan.assessment.model.Assessment;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.xml.TargetInfoReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SCAScanner {
    private final int GET_RESULT_LOOP = 180;
    private final int SLEEP_BETWEEN_REQUEST = 10000;
    private Map<Library, Library> m_libraries;
    private int m_libraryCount = 0;
    protected TargetInfoReader m_target_info;
    protected Assessment m_assessment;
    protected File m_output;
    protected ILogManager m_log = null;
    protected List<ILicense> m_licenses;
    protected HashMap<String, List<IScanFile>> m_inverseSet;
    protected String m_requestId;
    protected String m_requestStatus;
    protected String m_prevReqStatus;
    protected String m_baseIpAddress;
    protected JSONArray m_scaResults;
    protected HttpClient m_httpClient;
    protected Map<String, String> m_headers;

    public static void main(String[] args) {
        if (args.length == 2) {
            SCAScanner scanner = new SCAScanner(new File(args[0]), new File(args[1]));
            boolean res = scanner.sendHashesToScaScan();
            if (res) {
                res = scanner.waitForHashRequestResults();
            }
            if (res) {
                boolean bl = scanner.processScaResults();
            }
        }
    }

    public SCAScanner(TargetInfoReader target_info, File output, ILogManager logger) {
        this.m_target_info = target_info;
        this.m_output = output;
        this.m_log = logger;
        this.m_assessment = new Assessment();
        this.m_licenses = new ArrayList<ILicense>();
        this.m_inverseSet = new HashMap();
        this.m_httpClient = new HttpClient();
        this.m_headers = new HashMap<String, String>();
        this.m_libraries = new HashMap<Library, Library>();
        this.m_headers.put("Accept", "application/json");
        this.m_headers.put("Content-Type", "application/json");
    }

    public SCAScanner(File target_info, File output) {
        this(new TargetInfoReader(target_info), output, CommonCore.getLogManager());
        this.m_log.log(new Message(1, Messages.getMessage("sca.scanner.run", new Object[0])));
        try {
            this.m_log.log(new Message(1, Messages.getMessage("sca.scanner.read.targetinfo.file", new Object[0])));
            this.m_target_info.read();
        }
        catch (FileNotFoundException | XMLStreamException e) {
            this.m_log.log(new Message(4, Messages.getMessage("err.read.targetinfo.file", new Object[0])));
            this.m_log.log(e);
        }
    }

    public boolean sendHashesToScaScan() {
        boolean res = false;
        this.m_log.log(new Message(1, Messages.getMessage("sca.scanner.send.request", new Object[0])));
        try {
            this.m_baseIpAddress = System.getProperty("SCA_api_ip");
            if (this.m_baseIpAddress == null || this.m_baseIpAddress.trim().isEmpty()) {
                this.m_log.log(new Message(4, Messages.getMessage("err.empty.ip", new Object[0])));
                return false;
            }
            if (!this.m_baseIpAddress.endsWith("/")) {
                this.m_baseIpAddress = this.m_baseIpAddress + "/";
            }
            JSONObject request = new JSONObject();
            Set scanFiles = this.m_target_info.getScanFiles();
            for (IScanFile scanFile : scanFiles) {
                String checksum = scanFile.getChecksum();
                if (!this.m_inverseSet.containsKey(checksum)) {
                    this.m_inverseSet.put(checksum, new ArrayList());
                }
                this.m_inverseSet.get(checksum).add(scanFile);
            }
            JSONArray hashesArray = this.populateHashInfoForSCA(scanFiles);
            request.put("hashes", (Collection)hashesArray);
            String url = this.m_baseIpAddress + "SearchHashes";
            HttpResponse response = this.m_httpClient.post(url, this.m_headers, request.write().toCharArray());
            if (response.isSuccess()) {
                if (this.processRequestStatus((JSONObject)response.getResponseBodyAsJSON(), true)) {
                    this.m_log.log(new Message(1, Messages.getMessage("sca.scanner.request.id", this.m_requestId)));
                    res = true;
                    this.printRequestStatus();
                }
            } else {
                this.m_log.log(new Message(4, Messages.getMessage("err.send.request.http.error", url)));
            }
            this.m_prevReqStatus = this.m_requestStatus;
        }
        catch (IOException | JSONException e) {
            this.m_log.log(new Message(4, Messages.getMessage("err.send.request", new Object[0])));
            this.m_log.log((Exception)e);
        }
        return res;
    }

    public boolean waitForHashRequestResults() {
        boolean res = false;
        boolean finishProcessing = false;
        this.m_log.log(new Message(1, Messages.getMessage("sca.scanner.wait.for.results", this.m_requestId)));
        String url = this.m_baseIpAddress + "GetResult" + "?id=" + this.m_requestId;
        for (int i = 0; i < 180; ++i) {
            try {
                HttpResponse response = this.m_httpClient.get(url, this.m_headers, null);
                JSONObject jsonRes = null;
                if (!response.isSuccess()) {
                    this.m_log.log(new Message(4, Messages.getMessage("err.get.results.http.err", this.m_requestId)));
                    continue;
                }
                jsonRes = (JSONObject)response.getResponseBodyAsJSON();
                this.processRequestStatus(jsonRes, false);
                if (!this.m_prevReqStatus.equals(this.m_requestStatus)) {
                    this.printRequestStatus();
                    this.m_prevReqStatus = this.m_requestStatus;
                }
                if (this.m_requestStatus.equals("2") || this.m_requestStatus.equals("3")) {
                    if (this.m_requestStatus.equals("2")) {
                        this.m_scaResults = jsonRes.getJSONArray("results");
                        res = true;
                    } else {
                        this.m_log.log(new Message(4, Messages.getMessage("err.failed.returned.err.code", this.m_requestId)));
                        this.cancelRequest();
                    }
                    finishProcessing = true;
                    break;
                }
            }
            catch (IOException | JSONException e) {
                this.m_log.log(new Message(4, Messages.getMessage("err.get.results.exp", this.m_requestId)));
                this.m_log.log((Exception)e);
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                this.m_log.log(new Message(1, Messages.getMessage("err.sleep", new Object[0])));
            }
        }
        if (!finishProcessing) {
            this.m_log.log(new Message(4, Messages.getMessage("err.get.results.timeout", this.m_requestId)));
            this.cancelRequest();
        }
        return res;
    }

    public boolean processScaResults() {
        boolean res = true;
        try {
            for (JSONObject hashInfo : this.m_scaResults) {
                List<IScanFile> theScanFiles;
                Library library;
                int i;
                String hash;
                this.m_log.log(new Message(1, hashInfo.toString()));
                if (!hashInfo.containsKey((Object)"hash") || !this.m_inverseSet.containsKey(hash = hashInfo.getString("hash"))) continue;
                ++this.m_libraryCount;
                String version = "";
                if (hashInfo.containsKey((Object)"versions")) {
                    JSONArray versions = hashInfo.getJSONArray("versions");
                    ArrayList<String> versionsList = new ArrayList<String>();
                    for (i = 0; i < versions.length(); ++i) {
                        versionsList.add(versions.getString(i));
                    }
                    version = String.join((CharSequence)";", versionsList);
                }
                if (this.m_libraries.containsKey(library = new Library((theScanFiles = this.m_inverseSet.get(hash)).get(0).getAnalysisPath(), version, hash, hashInfo))) {
                    Library existing = this.m_libraries.get(library);
                    for (IScanFile scanFile : theScanFiles) {
                        existing.addFile(scanFile.getAnalysisPath(), hash);
                    }
                    continue;
                }
                if (theScanFiles.size() > 0) {
                    for (i = 1; i < theScanFiles.size(); ++i) {
                        library.addFile(theScanFiles.get(i).getAnalysisPath(), hash);
                    }
                }
                this.m_libraries.put(library, library);
            }
            for (Library library : this.m_libraries.keySet()) {
                this.processLicenses(library);
                this.processVulnerabilities(library);
            }
            this.m_assessment.save(this.m_output);
            res = this.saveLicenses();
        }
        catch (AssessmentException | AppScanException | IOException | JSONException e) {
            this.m_log.log(new Message(4, Messages.getMessage("err.process.results", this.m_requestId)));
            this.m_log.log((Exception)e);
            res = false;
        }
        return res;
    }

    public boolean isOpenSourceLanguage() throws AssessmentException {
        if (!Language.isOpenSourceLang((Language.LANGUAGE)Language.getLanguage((String)this.m_target_info.getLanguageType()))) {
            this.m_assessment.save(this.m_output);
            this.saveLicenses();
            return false;
        }
        return true;
    }

    protected boolean saveLicenses() {
        boolean res = true;
        try {
            if (this.m_licenses == null || this.m_licenses.size() == 0) {
                return res;
            }
            String fileSpec = this.m_output.getParent() + File.separator + "sca";
            File f = new File(this.m_output.getParent());
            while (f.getParent() != null && !f.getName().endsWith(".tmp")) {
                f = new File(f.getParent());
            }
            if (f.getName().endsWith(".tmp")) {
                String fileName = f.getName().substring(0, f.getName().length() - 4);
                fileSpec = f.getAbsolutePath() + File.separator + "results" + File.separator + fileName;
            }
            File licensesFile = new File(fileSpec + "-licenses.xml");
            LicensesFileWriter writer = new LicensesFileWriter(licensesFile, this.m_licenses, this.m_libraryCount);
            writer.write();
        }
        catch (IOException e) {
            this.m_log.log(new Message(4, Messages.getMessage("err.save.license", new Object[0])));
            this.m_log.log((Exception)e);
            res = false;
        }
        return res;
    }

    private void cancelRequest() {
        this.m_log.log(new Message(1, Messages.getMessage("sca.scanner.send.cancel.request", this.m_requestId)));
        String url = this.m_baseIpAddress + "CancelRequest" + "?id=" + this.m_requestId;
        try {
            HttpResponse response = this.m_httpClient.get(url, this.m_headers, null);
            if (!response.isSuccess()) {
                this.m_log.log(new Message(4, Messages.getMessage("err.cancel.request.http.err", this.m_requestId)));
            }
        }
        catch (IOException e) {
            this.m_log.log(new Message(4, Messages.getMessage("err.cancel.request.exp", this.m_requestId)));
            this.m_log.log((Exception)e);
        }
    }

    private boolean processRequestStatus(JSONObject response, boolean setReqId) throws JSONException {
        boolean res = true;
        if (response != null) {
            if (setReqId) {
                this.m_requestId = response.getString("id");
            }
            this.m_requestStatus = response.getString("status");
            if (this.m_requestId.equals("-1") || this.m_requestStatus.equals("3")) {
                res = false;
                if (!response.isNull("error")) {
                    this.m_log.log(new Message(4, Messages.getMessage("err.sca.status.with.error.msg", response.getString("error"))));
                } else {
                    this.m_log.log(new Message(4, Messages.getMessage("err.sca.status.unknown.err", new Object[0])));
                }
            }
        } else {
            this.m_log.log(new Message(4, Messages.getMessage("err.sca.empty.json", new Object[0])));
            res = false;
        }
        return res;
    }

    private void printRequestStatus() {
        switch (this.m_requestStatus) {
            case "0": {
                this.m_log.log(new Message(1, Messages.getMessage("in.queue.status", this.m_requestId)));
                break;
            }
            case "1": {
                this.m_log.log(new Message(1, Messages.getMessage("in.progress.status", this.m_requestId)));
                break;
            }
            case "2": {
                this.m_log.log(new Message(1, Messages.getMessage("finish.status", this.m_requestId)));
                break;
            }
            case "3": {
                this.m_log.log(new Message(1, Messages.getMessage("err.failure.status", this.m_requestId)));
                break;
            }
            default: {
                this.m_log.log(new Message(1, Messages.getMessage("warn.unknown.status", this.m_requestId)));
            }
        }
    }

    protected JSONArray populateHashInfoForSCA(Set<IScanFile> scanFiles) throws JSONException {
        JSONArray hashesArray = new JSONArray();
        for (IScanFile scanFile : scanFiles) {
            String fileName = scanFile.getAnalysisPath();
            if (!fileName.contains(".")) continue;
            JSONObject hashInfo = new JSONObject();
            hashInfo.put("path", (Object)fileName);
            hashInfo.put("hash", (Object)scanFile.getChecksum());
            hashesArray.put((Map)hashInfo);
        }
        return hashesArray;
    }

    private void processLicenses(Library library) throws AppScanException {
        for (String location : library.getLocations()) {
            for (SCALicense scaLicense : library.getLicenses()) {
                ILicense license = scaLicense.toLicense();
                license.setArtifactLocation(location);
                this.m_licenses.add(license);
            }
        }
    }

    private void processVulnerabilities(Library library) throws JSONException, IOException {
        for (String vulnerableFile : library.getVulnerableFiles()) {
            for (SCAVulnerability vulnerability : library.getVulnerabilities()) {
                this.m_assessment.addFinding(vulnerability.toFinding(vulnerableFile));
            }
        }
    }
}

