/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.custom.scanner.sca.data;

import com.hcl.appscan.custom.scanner.sca.data.Library;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.assessment.model.FindingProvider;
import com.ibm.appscan.assessment.model.Site;
import com.ibm.appscan.common.Language;
import java.io.IOException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SCAVulnerability {
    private static final String BACKSLASH = "\\";
    private static final String FORWARDSLASH = "/";
    private Library m_library;
    private JSONObject m_vulnInfo;

    public SCAVulnerability(Library library, JSONObject vulnerability) {
        this.m_library = library;
        this.m_vulnInfo = vulnerability;
    }

    public Finding toFinding(String analysisPath) throws JSONException, IOException {
        String name = this.m_vulnInfo.containsKey((Object)"cveId") ? this.m_vulnInfo.getString("cveId") : "Unknown";
        String type = "Vulnerability.OpenSource";
        String description = this.jsonValueExists(this.m_vulnInfo, "description") && this.m_vulnInfo.isNull(type) ? this.m_vulnInfo.getString("description") : "";
        String severity = this.jsonValueExists(this.m_vulnInfo, "severity") ? this.toTitleCase(this.m_vulnInfo.getString("severity")) : "";
        String url = this.jsonValueExists(this.m_vulnInfo, "linkNvdOrMitre") ? this.m_vulnInfo.getString("linkNvdOrMitre") : "";
        String score = this.jsonValueExists(this.m_vulnInfo, "riskScore") ? this.m_vulnInfo.getString("riskScore") : "";
        String fixResolutionText = this.jsonValueExists(this.m_vulnInfo, "fixResolutionMessage") ? this.m_vulnInfo.getString("fixResolutionMessage") : "";
        return FindingProvider.getFinding(null, (String)analysisPath, (Site)new Site(analysisPath, 0, 0, analysisPath, "", "", "", name, Language.LANGUAGE.THIRDPARTYLIB.toString(), this.m_library.getName(), this.m_library.getTechnology(), ""), (String)"", (String)"", (String)"", (String)"High", (String)severity, (String)type, (String)this.getProperties(analysisPath), (String)"", (String)"", (String)name, null, (String)description, (String)url, (String)score, (String)fixResolutionText);
    }

    private boolean jsonValueExists(JSONObject jsonObj, String key) {
        return jsonObj.containsKey((Object)key) && !jsonObj.isNull(key);
    }

    private String toTitleCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    private String getProperties(String analysisPath) throws JSONException {
        String cvssVersion = this.jsonValueExists(this.m_vulnInfo, "cvssVersion") ? this.m_vulnInfo.getString("cvssVersion") : "";
        String properties = "version=" + this.m_library.getVersion() + ",";
        properties = properties + "location=" + this.getParentDirectory(analysisPath) + ",";
        properties = properties + "cvss-version=" + cvssVersion;
        return properties;
    }

    private String getParentDirectory(String path) {
        if (path.contains(BACKSLASH)) {
            path = path.replaceAll("\\\\", FORWARDSLASH);
        }
        if (path.contains(FORWARDSLASH)) {
            path = path.substring(0, path.lastIndexOf(FORWARDSLASH));
        }
        return path;
    }
}

