/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.util.debug.Assertions;

public class ErrorLog {
    private static int REPORTING_LEVEL = 2;
    private static ErrorLog i;

    public static ErrorLog i() {
        if (i == null) {
            i = new ErrorLog();
        }
        return i;
    }

    private ErrorLog() {
    }

    public void register(String msg) {
        this.register(msg, Kind.ERROR);
    }

    public void register(String msg, Kind kind) {
        if (REPORTING_LEVEL <= kind.getLevel()) {
            switch (kind) {
                case ERROR: {
                    System.err.println("ERROR: " + msg);
                    break;
                }
                case WARNING: {
                    System.err.println("WARNING: " + msg);
                    break;
                }
                case INFO: {
                    System.err.println("INFO: " + msg);
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
        }
    }

    public static enum Kind {
        ERROR(2),
        WARNING(1),
        INFO(0);

        private final int level;

        private Kind(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

