/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.jstaint.util.SimpleGraph;
import com.ibm.wala.util.graph.Graph;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;

public class GraphOutput {
    private static String getOutputDirectory() {
        return "Graph_Output";
    }

    public static void clearOutputDirectory() {
        File outputdir = new File(GraphOutput.getOutputDirectory());
        if (outputdir != null && outputdir.exists()) {
            File[] files;
            for (File f : files = outputdir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml") || name.endsWith(".txt");
                }
            })) {
                f.delete();
            }
        }
    }

    public static <T> void printSimpleGraphXML(String filename, SimpleGraph<T> g) {
        String graphUIDataDir = GraphOutput.getOutputDirectory();
        new File(graphUIDataDir).mkdirs();
        String outputFileName = graphUIDataDir + File.separator + filename;
        try {
            T v;
            FileWriter fw = new FileWriter(outputFileName);
            fw.write("<graph>\n");
            Iterator<T> allNodes = g.getAllNodes();
            while (allNodes.hasNext()) {
                v = allNodes.next();
                String isLeaf = g.getSuccNodeCount(v) > 0 ? "true" : "false";
                fw.write("<Node id=\"" + v.hashCode() + "\" isLeaf=\"" + isLeaf + "\" prop=\"" + v.toString() + "\"/>\n");
            }
            allNodes = g.getAllNodes();
            while (allNodes.hasNext()) {
                v = allNodes.next();
                Iterator<T> succNodes = g.getSuccNodes(v);
                while (succNodes.hasNext()) {
                    T n = succNodes.next();
                    fw.write("<Edge fromID=\"" + v.hashCode() + "\" toID=\"" + n.hashCode() + "\" />\n");
                }
            }
            fw.write("</graph>\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> void printSimpleGraphTXT(String filename, SimpleGraph<T> g) {
        String graphUIDataDir = GraphOutput.getOutputDirectory();
        new File(graphUIDataDir).mkdirs();
        String outputFileName = graphUIDataDir + File.separator + filename;
        try {
            T v;
            FileWriter fw = new FileWriter(outputFileName);
            Iterator<T> allNodes = g.getAllNodes();
            while (allNodes.hasNext()) {
                v = allNodes.next();
                fw.write("Node, " + v.hashCode() + ",  " + v.toString() + "\n");
            }
            allNodes = g.getAllNodes();
            while (allNodes.hasNext()) {
                v = allNodes.next();
                Iterator<T> succNodes = g.getSuccNodes(v);
                while (succNodes.hasNext()) {
                    T n = succNodes.next();
                    fw.write("Edge, " + v.hashCode() + ", " + n.hashCode() + "\n");
                }
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> void printGraphXML(String filename, Graph<T> g) {
        String graphUIDataDir = GraphOutput.getOutputDirectory();
        new File(graphUIDataDir).mkdirs();
        String outputFileName = graphUIDataDir + File.separator + filename;
        try {
            FileWriter fw = new FileWriter(outputFileName);
            fw.write("<graph>\n");
            for (Object v : g) {
                String isLeaf = g.getSuccNodeCount(v) > 0 ? "true" : "false";
                fw.write("<Node id=\"" + v.hashCode() + "\" isLeaf=\"" + isLeaf + "\" prop=\"" + v.toString() + "\"/>\n");
            }
            for (Object v : g) {
                Iterator succNodes = g.getSuccNodes(v);
                while (succNodes.hasNext()) {
                    Object n = succNodes.next();
                    fw.write("<Edge fromID=\"" + v.hashCode() + "\" toID=\"" + n.hashCode() + "\" />\n");
                }
            }
            fw.write("</graph>\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> void printRawGraph(String filename, Graph<T> g) {
        String graphUIDataDir = GraphOutput.getOutputDirectory();
        new File(graphUIDataDir).mkdirs();
        String outputFileName = graphUIDataDir + File.separator + filename;
        try {
            FileWriter fw = new FileWriter(outputFileName);
            fw.write(g.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> void printGraphTXT(String filename, Graph<T> g) {
        String graphUIDataDir = GraphOutput.getOutputDirectory();
        new File(graphUIDataDir).mkdirs();
        String outputFileName = graphUIDataDir + File.separator + filename;
        try {
            FileWriter fw = new FileWriter(outputFileName);
            for (Object v : g) {
                fw.write("Node, " + v.hashCode() + ",  " + v.toString() + "\n");
            }
            for (Object v : g) {
                Iterator succNodes = g.getSuccNodes(v);
                while (succNodes.hasNext()) {
                    Object n = succNodes.next();
                    fw.write("Edge, " + v.hashCode() + ", " + n.hashCode() + "\n");
                }
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

