/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util.dependencyAnalysis;

import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.jstaint.util.dependencyAnalysis.DependencyAnalysis;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DAGraph {
    private final Map<TypeReference, ModuleEntry> typeToModuleEntry;
    private final Map<ModuleEntry, TypeReference> moduleEntryToType;
    private final Graph<TypeNode> typeDependancyGraph;
    private final Map<TypeReference, TypeNode> nodeDict;
    private final Map<TypeReference, TypeReference> missingTypeToUser;
    private final Map<TypeReference, TypeNode> type2typeNode = HashMapFactory.make();

    public DAGraph(Set<ModuleEntry> allModuleEntries) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        this.typeToModuleEntry = HashMapFactory.make((int)allModuleEntries.size());
        this.moduleEntryToType = HashMapFactory.make((int)allModuleEntries.size());
        ArrayList<DependencyAnalysis.DAClassInfo> allClassInfos = new ArrayList<DependencyAnalysis.DAClassInfo>(allModuleEntries.size());
        for (ModuleEntry me : allModuleEntries) {
            if (!me.isClassFile()) continue;
            DependencyAnalysis.DAClassInfo daClassInfo = DependencyAnalysis.findDependancy(me);
            this.typeToModuleEntry.put(daClassInfo.getType(), me);
            this.moduleEntryToType.put(me, daClassInfo.getType());
            allClassInfos.add(daClassInfo);
        }
        this.typeDependancyGraph = new SparseNumberedGraph();
        this.missingTypeToUser = HashMapFactory.make();
        this.nodeDict = HashMapFactory.make();
        for (DependencyAnalysis.DAClassInfo classInfo : allClassInfos) {
            TypeReference type = classInfo.getType();
            TypeNode typeNode = new TypeNode(type);
            this.typeDependancyGraph.addNode((Object)typeNode);
            this.type2typeNode.put(type, typeNode);
            this.nodeDict.put(type, typeNode);
        }
        for (DependencyAnalysis.DAClassInfo classInfo : allClassInfos) {
            TypeReference sourceType = classInfo.getType();
            TypeNode sourceNode = this.nodeDict.get(sourceType);
            for (TypeReference dependantType : classInfo.getReferencedTypes()) {
                TypeNode destNode = this.nodeDict.get(dependantType);
                if (destNode != null) {
                    this.typeDependancyGraph.addEdge((Object)sourceNode, (Object)destNode);
                    continue;
                }
                this.missingTypeToUser.put(dependantType, sourceType);
            }
        }
    }

    public Map<TypeReference, TypeReference> getMissingTypeToUser() {
        return this.missingTypeToUser;
    }

    public Graph<TypeNode> getTypeDependencyGraph() {
        return this.typeDependancyGraph;
    }

    public TypeNode getNode(TypeReference type) {
        return this.type2typeNode.get(type);
    }

    public void writeToDot(String fileName) throws WalaException {
        this.writeToDot(fileName, (Predicate<TypeReference>)IndiscriminateFilter.singleton());
    }

    public void writeToDot(String fileName, final Predicate<TypeReference> filter) throws WalaException {
        NodeDecorator decorator = new NodeDecorator(){

            public String getLabel(Object o) throws WalaException {
                TypeNode n = (TypeNode)((Object)o);
                return n.getType().toString();
            }
        };
        Predicate<TypeNode> nodeFilter = new Predicate<TypeNode>(){

            public boolean test(TypeNode o) {
                return filter.test((Object)o.getType());
            }
        };
        Graph filteredGraph = GraphSlicer.prune(this.typeDependancyGraph, (Predicate)nodeFilter);
        DotUtil.writeDotFile((Graph)filteredGraph, (NodeDecorator)decorator, (String)"Dependency Analysis", (String)fileName);
    }

    public Set<TypeReference> getReachableTypes(Set<TypeReference> rootTypes) {
        HashSet rootNodes = HashSetFactory.make();
        for (TypeReference typeRef : rootTypes) {
            TypeNode typeNode = this.nodeDict.get(typeRef);
            assert (this.typeDependancyGraph.containsNode((Object)typeNode));
            rootNodes.add(typeNode);
        }
        Set reachableNodes = DFS.getReachableNodes(this.typeDependancyGraph, (Collection)rootNodes);
        HashSet ret = HashSetFactory.make();
        for (TypeNode n : reachableNodes) {
            ret.add(n.getType());
        }
        return ret;
    }

    public <T> Graph<GeneralNubmeredNode<T>> createAbstractGraph(Map<ModuleEntry, T> abstraction) {
        HashMap abstructNodeDict = HashMapFactory.make();
        for (Object t : abstraction.values()) {
            GeneralNubmeredNode<Object> n = (GeneralNubmeredNode<Object>)((Object)abstructNodeDict.get(t));
            if (n != null) continue;
            n = new GeneralNubmeredNode<Object>(t);
            abstructNodeDict.put(t, n);
        }
        SparseNumberedGraph ret = new SparseNumberedGraph();
        for (ModuleEntry me : this.typeToModuleEntry.values()) {
            GeneralNubmeredNode n;
            T abstractValue = abstraction.get(me);
            if (abstractValue == null || ret.containsNode((Object)(n = (GeneralNubmeredNode)((Object)abstructNodeDict.get(abstractValue))))) continue;
            ret.addNode((Object)n);
        }
        for (TypeNode node : this.typeDependancyGraph) {
            GeneralNubmeredNode<T> abstractNode = this.nodeToAbstractNode(node, abstraction, abstructNodeDict);
            Iterator j = this.typeDependancyGraph.getSuccNodes((Object)node);
            while (j.hasNext()) {
                TypeNode succ = (TypeNode)((Object)j.next());
                GeneralNubmeredNode<T> abstractSucc = this.nodeToAbstractNode(succ, abstraction, abstructNodeDict);
                ret.addEdge(abstractNode, abstractSucc);
            }
        }
        return ret;
    }

    private <T> GeneralNubmeredNode<T> nodeToAbstractNode(TypeNode node, Map<ModuleEntry, T> abstraction, Map<T, GeneralNubmeredNode<T>> abstructNodeDict) {
        TypeReference typeReference = node.getType();
        ModuleEntry me = this.typeToModuleEntry.get(typeReference);
        T t = abstraction.get(me);
        GeneralNubmeredNode<T> abstractNode = abstructNodeDict.get(t);
        return abstractNode;
    }

    public Set<TypeReference> getTypesForModuleEntries(Set<ModuleEntry> moduleEntries) {
        HashSet ret = HashSetFactory.make();
        for (ModuleEntry me : moduleEntries) {
            TypeReference type = this.moduleEntryToType.get(me);
            assert (type != null) : "type for: " + me + " is missing";
            ret.add(type);
        }
        return ret;
    }

    public TypeReference getTypeForModuleEntry(ModuleEntry me) {
        TypeReference type = this.moduleEntryToType.get(me);
        assert (type != null) : "type for: " + me + " is missing";
        return type;
    }

    public Set<ModuleEntry> getModuleEntriesForTypes(Set<TypeReference> reachableTypes) {
        HashSet ret = HashSetFactory.make();
        for (TypeReference tr : reachableTypes) {
            ret.add(this.typeToModuleEntry.get(tr));
        }
        return ret;
    }

    public static class GeneralNubmeredNode<T>
    extends NodeWithNumber {
        private final T t;

        public GeneralNubmeredNode(T t) {
            this.t = t;
        }

        public T getData() {
            return this.t;
        }
    }

    public static class TypeNode
    extends NodeWithNumber {
        private final TypeReference type;

        public TypeNode(TypeReference type) {
            this.type = type;
        }

        public TypeReference getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            TypeNode other = (TypeNode)((Object)obj);
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }
}

