/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util.frameworks;

import com.ibm.wala.jstaint.util.frameworks.MethodArgument;
import com.ibm.wala.jstaint.util.frameworks.MethodSignature;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Map;

public class FrameworkSignatureUtil {
    private static final Map<Character, String> javaTypeNames = HashMapFactory.make();
    private static final Map<String, Character> jvmTypeNames;

    public static String javaTypeToJVMType(String type) {
        String strippedArgument;
        StringBuilder sb = new StringBuilder();
        int indexOfSquareBrackets = -1;
        int startIndex = 0;
        while ((indexOfSquareBrackets = type.indexOf("[]", startIndex)) >= 0) {
            startIndex = indexOfSquareBrackets + 1;
            sb.append('[');
        }
        String string = strippedArgument = type.indexOf(91) >= 0 ? type.substring(0, type.indexOf(91)) : type;
        if (jvmTypeNames.containsKey(strippedArgument)) {
            sb.append(jvmTypeNames.get(strippedArgument));
        } else {
            sb.append("L" + strippedArgument + ";");
        }
        return sb.toString();
    }

    public static MethodSignature frameworksSigToMethodSignature(String methodSignature) {
        String className;
        String packageName;
        int splitIndex;
        String firstPartMethod;
        ArrayList<MethodArgument> args = new ArrayList<MethodArgument>();
        StringBuilder sb = new StringBuilder();
        int argStartIndex = methodSignature.indexOf(40) + 1;
        if (argStartIndex > 0) {
            firstPartMethod = methodSignature.substring(0, argStartIndex - 1);
            splitIndex = firstPartMethod.lastIndexOf(47);
            String fullyQualifiedClassName = (String)FrameworkSignatureUtil.frameworkTypeToJavaCodeType((String)firstPartMethod.substring((int)0, (int)splitIndex)).fst;
            int lastDotIndex = fullyQualifiedClassName.lastIndexOf(46);
            if (lastDotIndex > 0) {
                packageName = fullyQualifiedClassName.substring(0, lastDotIndex);
                className = fullyQualifiedClassName.substring(lastDotIndex + 1);
            } else {
                packageName = "";
                className = fullyQualifiedClassName;
            }
        } else {
            Object packageName2 = null;
            Object methodName = null;
            Object className2 = null;
            Object returnType = null;
            Assertions.UNREACHABLE();
            return null;
        }
        String methodName = firstPartMethod.substring(splitIndex + 1);
        int argEndIndex = methodSignature.indexOf(41);
        if (argEndIndex > 0) {
            String argsStrings = methodSignature.substring(argStartIndex, argEndIndex);
            int index = 0;
            int argNumber = 0;
            while (argsStrings.length() > 0) {
                Pair<String, Integer> t = FrameworkSignatureUtil.frameworkTypeToJavaCodeType(argsStrings);
                String frameworkType = (String)t.fst;
                index = (Integer)t.snd;
                if (frameworkType.length() > 0) {
                    if (index > 0) {
                        sb.append(";");
                    }
                    String paramName = "v" + String.valueOf(argNumber++);
                    args.add(new MethodArgument(frameworkType, paramName));
                    sb.append(frameworkType);
                }
                argsStrings = argsStrings.substring(index);
            }
        } else {
            Object returnType = null;
            Assertions.UNREACHABLE();
            return null;
        }
        sb.append("):");
        int retTypeStartIndex = argEndIndex;
        String frameworkRetType = methodSignature.substring(retTypeStartIndex + 1);
        String returnType = (String)FrameworkSignatureUtil.frameworkTypeToJavaCodeType((String)frameworkRetType).fst;
        sb.append(returnType);
        return new MethodSignature(returnType, packageName, className, methodName, args);
    }

    public static String JVMTypeToJavaType(String type) {
        return (String)FrameworkSignatureUtil.frameworkTypeToJavaCodeType((String)type).fst;
    }

    private static Pair<String, Integer> frameworkTypeToJavaCodeType(String type) {
        int index = 0;
        StringBuffer sb = new StringBuffer();
        Character c = Character.valueOf(type.charAt(index));
        switch (c.charValue()) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'V': 
            case 'Z': {
                sb.append(javaTypeNames.get(c));
                ++index;
                break;
            }
            case 'L': {
                String klass;
                int endIndex = type.indexOf(59, index);
                if (endIndex > 0) {
                    klass = type.substring(index + 1, endIndex);
                    index = endIndex + 1;
                } else {
                    klass = type.substring(index + 1);
                    index = type.length();
                }
                klass = klass.replaceAll("/", ".");
                sb.append(klass);
                break;
            }
            case '[': {
                int arrayCount = 1;
                while (type.charAt(index++) != '[') {
                    ++arrayCount;
                }
                sb.append(FrameworkSignatureUtil.frameworkTypeToJavaCodeType(type.substring(index)));
                for (int i = 0; i < arrayCount; ++i) {
                    sb.append("[]");
                }
                break;
            }
        }
        return Pair.make((Object)sb.toString(), (Object)index);
    }

    public static String dotsToSlashesWithoutLeadingL(String s) {
        return s.replace('.', '/');
    }

    public static String dotsToSlashes(String methodSig) {
        return "L" + methodSig.replace('.', '/');
    }

    public static String slashesToDots(String methodSig) {
        if (methodSig != null) {
            return methodSig.substring(1).replace('/', '.');
        }
        return null;
    }

    public static void main(String[] args) {
        String s = "Lorg/apache/jsp/Error_jsp/_jspService(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V";
        MethodSignature m = FrameworkSignatureUtil.frameworksSigToMethodSignature(s);
        System.out.println(m.getDeclString());
        s = "Lorg/apache/jsp/Error_jsp/_jspService(Ljavax/servlet/http/HttpServletRequest;)V";
        m = FrameworkSignatureUtil.frameworksSigToMethodSignature(s);
        System.out.println(m.getDeclString());
        s = "Lorg/apache/jsp/Error_jsp/_jspService()I";
        m = FrameworkSignatureUtil.frameworksSigToMethodSignature(s);
        System.out.println(m.getDeclString());
    }

    static {
        javaTypeNames.put(Character.valueOf('I'), "int");
        javaTypeNames.put(Character.valueOf('C'), "char");
        javaTypeNames.put(Character.valueOf('J'), "long");
        javaTypeNames.put(Character.valueOf('Z'), "boolean");
        javaTypeNames.put(Character.valueOf('D'), "double");
        javaTypeNames.put(Character.valueOf('F'), "float");
        javaTypeNames.put(Character.valueOf('S'), "short");
        javaTypeNames.put(Character.valueOf('V'), "void");
        javaTypeNames.put(Character.valueOf('B'), "byte");
        jvmTypeNames = MapUtil.invertOneToOneMap(javaTypeNames);
    }
}

