/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util.frameworks;

import com.ibm.wala.jstaint.util.scopes.ScopeUtil;
import com.ibm.wala.util.processes.BasicLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public class SyntheticCodeCompiler {
    private static final int CLASSLOADER_INDEX = 0;
    private static final int ENTRY_INDEX = 3;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Error: To use this program, you must specify (1) the path to an analysis-scope file, (2) a directory additional classes, and (3) a non-empty sequence of Java files to be compiled");
            System.exit(1);
        }
        SyntheticCodeCompiler.compile(args[0], args[1], Arrays.asList(args).subList(2, args.length));
    }

    public static boolean compile(String scopeFile, String outputDir, List<String> filesToCompile) throws IOException {
        String line;
        String workspace = System.getProperty("WorkSpace");
        String taintResources = System.getProperty("TaintResources");
        if (workspace == null || taintResources == null) {
            System.err.println("Error: To use this program, you must set up the WorkSpace and TaintResources system properties as follows:\n-DWorkSpace=${workspace_loc} -DTaintResources=${taint_resources}");
            System.exit(1);
        }
        String fixedScopeFile = ScopeUtil.getFixedAnalysisScope(scopeFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fixedScopeFile)));
        StringBuilder sbPrimordial = new StringBuilder();
        StringBuilder sbApplication = new StringBuilder();
        int primordialCount = 0;
        int applicationCount = 0;
        String os = System.getProperty("os.name").toLowerCase();
        String separator = os.contains("mac") || os.contains("unix") || os.contains("linux") || os.contains("solaris") || os.contains("aix") ? ":" : ";";
        while ((line = br.readLine()) != null && !line.isEmpty()) {
            if (line.endsWith("primordial.jar.model")) continue;
            String[] tokens = line.split(",");
            String token = tokens[3];
            File f = new File(token);
            if (!f.exists()) {
                System.err.println("ERROR: File " + token + " does not exist.");
                System.exit(1);
                continue;
            }
            if (tokens[0].equalsIgnoreCase("Primordial")) {
                if (primordialCount++ > 0) {
                    sbPrimordial.append(separator);
                }
                sbPrimordial.append(token);
                continue;
            }
            if (!tokens[0].equalsIgnoreCase("Extension") && !tokens[0].equalsIgnoreCase("Application")) continue;
            if (applicationCount++ > 0) {
                sbApplication.append(separator);
            }
            sbApplication.append(token);
        }
        br.close();
        new File(fixedScopeFile).delete();
        sbApplication.append(separator);
        sbApplication.append(outputDir);
        String bootClasspath = sbPrimordial.toString();
        String applicationClasspath = sbApplication.toString();
        StringBuilder commandSB = new StringBuilder();
        commandSB.append("javac -bootclasspath ");
        commandSB.append(bootClasspath);
        commandSB.append(" -classpath ");
        commandSB.append(applicationClasspath);
        for (String fileName : filesToCompile) {
            commandSB.append(" ");
            commandSB.append(fileName);
        }
        String command = commandSB.toString();
        System.out.println(command);
        BasicLauncher launcher = new BasicLauncher(true, true, null);
        launcher.setCmd(command);
        int exitCode = 0;
        exitCode = launcher.launch();
        System.out.println(new String(launcher.getStdOut()));
        System.err.println(new String(launcher.getStderr()));
        return exitCode == 0;
    }
}

