/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage;

import com.hcl.irx.stage.Messages;
import com.hcl.irx.stage.StageEventManager;
import com.hcl.irx.stage.StageListener;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public abstract class Stager
implements StageListener {
    private File m_staged_dependency_root;
    private BaseExclusion m_excluder;
    private File m_stage_analysis_path;
    private File m_stage_waflgen_path;
    private File m_base_path;
    private HashSet<File> m_user_code = new HashSet();
    private HashSet<File> m_dependencies;
    private Set<StringPattern> m_includes;
    private Set<StringPattern> m_excludes;
    private JSONObject m_stats = new JSONObject();
    private HashMap<String, String> m_staged_files_map = new HashMap();
    private IScanTargetMinProxy m_proxy;
    private IProgress m_progress;
    private HashSet<IScanFile> m_scan_files;
    private String m_current_parent = "";
    private static AtomicInteger STAGER_INSTANCE_COUNT = new AtomicInteger();

    public Stager(File output_base_path, IScanTargetMinProxy proxy, IProgress progress, Set<StringPattern> includes, Set<StringPattern> excludes) {
        this.m_base_path = new File(output_base_path, Integer.toString(STAGER_INSTANCE_COUNT.incrementAndGet()));
        this.m_stage_analysis_path = Paths.get(this.m_base_path.getAbsolutePath(), this.getLanguage().toString(), "analyze").toFile();
        this.m_stage_analysis_path.mkdirs();
        this.m_stage_waflgen_path = Paths.get(this.m_base_path.getAbsolutePath(), this.getLanguage().toString(), "wafl").toFile();
        this.m_stage_waflgen_path.mkdirs();
        this.m_staged_dependency_root = Paths.get(this.m_base_path.getAbsolutePath(), this.getLanguage().toString(), "dependency").toFile();
        this.m_staged_dependency_root.mkdirs();
        this.m_proxy = proxy;
        this.m_progress = progress;
        this.m_includes = includes;
        this.m_excludes = excludes;
    }

    protected IScanTargetMinProxy getProxy() {
        return this.m_proxy;
    }

    protected String getCurrentParent() {
        return this.m_current_parent;
    }

    protected void resetCurrentParent(String parent) {
        this.m_current_parent = "";
        this.appendParent(parent);
    }

    protected void removeParent(String parent) {
        if (this.m_current_parent.endsWith("/" + parent)) {
            this.m_current_parent = this.m_current_parent.substring(0, this.m_current_parent.lastIndexOf("/"));
        }
    }

    protected void appendParent(String parent) {
        this.m_current_parent = this.m_current_parent.length() > 0 ? this.m_current_parent + "/" + parent : Messages.getMessage("parent.compressed", this.getLanguage().toString(), parent);
    }

    protected IProgress getProgress() {
        if (this.m_progress == null) {
            this.m_progress = new NullProgress();
        }
        return this.m_progress;
    }

    protected abstract Language.LANGUAGE getStagerLanguage();

    public Map<String, String> getStagedFilesMap() {
        return this.m_staged_files_map;
    }

    protected JSONObject getStagerStats() {
        return this.m_stats;
    }

    public File getWaflGenPath() {
        return this.m_stage_waflgen_path;
    }

    protected boolean isUserExcluded(String path) {
        if (this.m_includes == null) {
            return false;
        }
        return !this.m_includes.isEmpty() && !this.isUserIncluded(path) || this.matchFound(path, this.m_excludes);
    }

    protected boolean isUserIncluded(String path) {
        if (this.m_includes == null) {
            return false;
        }
        return this.matchFound(path, this.m_includes);
    }

    protected void saveStageStats() throws IOException {
        try {
            this.addStagerSpecificStats();
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        if (this.getProxy() != null) {
            File log = Paths.get(this.getProxy().getScanHome().getAbsolutePath(), "logs", "stage.stats.json").toFile();
            log.getParentFile().mkdirs();
            IOUtil.write((String)this.getStagerStats().toString(true), (File)log);
        }
    }

    protected abstract void addStagerSpecificStats() throws JSONException;

    protected abstract void setupStaging() throws IOException, ExclusionException;

    public abstract void finalizeStaging() throws IOException, ExclusionException;

    public File getStagedDependencyRoot() {
        return this.m_staged_dependency_root;
    }

    public File getOutputBasePath() {
        return this.m_base_path;
    }

    public File getStageDirectory() {
        return this.m_stage_analysis_path;
    }

    public HashSet<File> getUserCodeFiles() {
        return this.m_user_code;
    }

    public HashSet<File> getDependencies() {
        if (this.m_dependencies == null) {
            this.m_dependencies = new HashSet();
        }
        return this.m_dependencies;
    }

    protected void saveFileData(File path, byte[] data) throws IOException {
        if (path.getParentFile() != null) {
            path.getParentFile().mkdirs();
        }
        IOUtil.write((InputStream)new ByteArrayInputStream(data), (File)path);
    }

    protected BaseExclusion getExcluder() throws ExclusionException {
        if (this.m_excluder == null) {
            this.m_excluder = ExclusionProvider.getExclusion((Language.LANGUAGE)this.getLanguage());
            this.updateIncludesAndExcludes();
        }
        return this.m_excluder;
    }

    public void stageFileOrDirectory(File file_or_dir_to_stage) throws IOException, ExclusionException {
        if (file_or_dir_to_stage.isDirectory()) {
            for (File f : file_or_dir_to_stage.listFiles()) {
                this.stageFileOrDirectory(f);
            }
        } else {
            this.stageFileForLanguage(file_or_dir_to_stage);
        }
    }

    protected abstract void stageFileForLanguage(File var1) throws IOException, ExclusionException;

    protected abstract Language.LANGUAGE getLanguage();

    @Override
    public void handleStageFile(File path, InputStream in) throws IOException {
        File out_file = new File(this.getStageDirectory().getAbsolutePath(), path.getPath());
        if (path.isAbsolute()) {
            out_file = path;
        }
        if (out_file.getParentFile() != null) {
            if (out_file.getParentFile().exists() && out_file.getParentFile().isFile()) {
                out_file = new File(this.getUniqueNameForParent(out_file.getParentFile(), 0), out_file.getName());
            }
            out_file.getParentFile().mkdirs();
        }
        IOUtil.write((InputStream)in, (File)out_file);
        DiscoveryCore.addScanFileParent((File)out_file, (String)this.getCurrentParent());
        DiscoveryCore.addScanFileParent((File)Paths.get(this.getStageDirectory().getAbsolutePath(), new String[0]).relativize(Paths.get(out_file.getAbsolutePath(), new String[0])).toFile(), (String)this.getCurrentParent());
    }

    private File getUniqueNameForParent(File parent, int index) {
        if (parent.exists() && parent.isFile()) {
            parent = new File(parent.getAbsolutePath() + "_" + Integer.toString(++index));
        }
        return parent;
    }

    @Override
    public void handleStageDependency(String path, InputStream in) throws IOException {
        File depend = new File(path);
        if (!depend.isAbsolute()) {
            depend = new File(this.getStagedDependencyRoot().getAbsolutePath(), path);
            StageEventManager.fireStageFileEvent(depend, in);
        }
        this.getDependencies().add(depend);
    }

    @Override
    public void handleAddDependencyFileReference(File path) {
        this.getDependencies().add(path.getAbsoluteFile());
    }

    public Set<IScanFile> getStagedScanFiles() {
        if (this.m_scan_files == null) {
            this.m_scan_files = new HashSet();
            try {
                this.finalizeStaging();
                this.saveStageStats();
            }
            catch (IOException e) {
                this.getProxy().getLogManager().log((Exception)e);
            }
            catch (ExclusionException e) {
                this.getProxy().getLogManager().log((Exception)((Object)e));
            }
            for (String f : this.getStagedFilesMap().keySet()) {
                IScanFile scanFile = ScanModelFactory.newScanFile((String)f);
                String real_path = this.getStagedFilesMap().get(scanFile.getAnalysisPath());
                if (real_path != null) {
                    scanFile.setExcluded(this.isFileUserExcluded(real_path));
                    scanFile.setSourcePath(real_path);
                }
                this.m_staged_files_map.put(f, scanFile.getSourcePath());
                this.m_scan_files.add(scanFile);
            }
        }
        return this.m_scan_files;
    }

    private boolean isFileUserExcluded(String path) {
        if (this.getProxy() == null) {
            return false;
        }
        if (!this.getProxy().getIncludes().isEmpty() && !this.matchFound(path, this.getProxy().getIncludes())) {
            return true;
        }
        return this.matchFound(path, this.getProxy().getExcludes());
    }

    private boolean matchFound(String path, Set<StringPattern> set) {
        for (StringPattern pattern : set) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }

    public abstract void validateScanFiles(IScanTargetMinProxy var1, IProgress var2, Set<IScanFile> var3);

    private void updateIncludesAndExcludes() throws ExclusionException {
        if (this.m_proxy == null) {
            return;
        }
        String splitter = ";";
        if (this.m_proxy.getBuildInfo().containsKey("package_includes")) {
            String[] packageIncludes = this.m_proxy.getBuildInfo().getProperty("package_includes").split(";");
            this.m_excluder.addPackageIncludes(Arrays.asList(packageIncludes));
        }
        if (this.m_proxy.getBuildInfo().containsKey("package_excludes")) {
            String[] packageExcludes = this.m_proxy.getBuildInfo().getProperty("package_excludes").split(";");
            this.m_excluder.addPackageExcludes(Arrays.asList(packageExcludes));
        }
        if (this.m_proxy.getBuildInfo().containsKey("class_includes")) {
            String[] classIncludes = this.m_proxy.getBuildInfo().getProperty("class_includes").split(";");
            this.m_excluder.addClassIncludes(Arrays.asList(classIncludes));
        }
        if (this.m_proxy.getBuildInfo().containsKey("class_excludes")) {
            String[] classExcludes = this.m_proxy.getBuildInfo().getProperty("class_excludes").split(";");
            this.m_excluder.addClassExcludes(Arrays.asList(classExcludes));
        }
        if (this.m_proxy.getBuildInfo().containsKey("method_includes")) {
            String[] methodIncludes = this.m_proxy.getBuildInfo().getProperty("method_includes").split(";");
            this.m_excluder.addMethodIncludes(Arrays.asList(methodIncludes));
        }
        if (this.m_proxy.getBuildInfo().containsKey("method_excludes")) {
            String[] methodExcludes = this.m_proxy.getBuildInfo().getProperty("method_excludes").split(";");
            this.m_excluder.addMethodExcludes(Arrays.asList(methodExcludes));
        }
    }
}

