/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.components;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.ScanModelVisitor;
import java.io.IOException;

public class ScanManager {
    private ILogManager m_logManager = CommonCLICore.getLogManager();
    private static ScanManager m_instance;
    private IScan m_activeScan = null;
    private IScanTarget m_activeScanTarget = null;

    public static ScanManager getInstance() {
        if (m_instance == null) {
            m_instance = new ScanManager();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    m_instance.closeActiveScan(null);
                }
            }));
        }
        return m_instance;
    }

    public void closeScan(IScan scan, IProgress progress) {
        try {
            scan.close(progress);
        }
        catch (IOException e) {
            this.m_logManager.log(new Message((Throwable)e));
        }
    }

    public void closeActiveScan(IProgress progress) {
        if (this.m_activeScan != null) {
            this.closeScan(this.m_activeScan, progress);
        }
    }

    public IScan getActiveScan() {
        return this.m_activeScan;
    }

    public void setActiveScan(IScan scan) {
        this.m_activeScan = scan;
    }

    public IScanTarget getActiveScanTarget() {
        return this.m_activeScanTarget;
    }

    public void setActiveScanTarget(IScanTarget scanTarget) {
        this.m_activeScanTarget = scanTarget;
    }

    public static boolean isTreeTransformed(IScanModelVisitable node) {
        final int[] count = new int[]{0};
        node.accept(new ScanModelVisitor(){

            public void visit(IScanTarget target) {
                if (target.getState() != ITransformable.State.TRANSFORMED) {
                    count[0] = count[0] + 1;
                }
            }
        });
        return count[0] == 0;
    }
}

