/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.utils.PackageUtil;
import com.ibm.appscan.config.Configurator;
import java.io.File;
import java.io.IOException;

public class OpenHandler {
    private ScanManager m_manager = ScanManager.getInstance();

    public IScan openScan(String path) {
        IScan oldScan = this.m_manager.getActiveScan();
        ProgressAdapter progress = new ProgressAdapter(oldScan);
        if (oldScan == null || !oldScan.isDirty()) {
            if (oldScan != null) {
                this.m_manager.closeActiveScan((IProgress)progress);
            }
            IScan scan = ScanModelFactory.newScan();
            progress = new ProgressAdapter(scan);
            File file = new File(path);
            if (!file.exists() || !file.getName().endsWith(".irx") && !file.getName().endsWith(".arsa")) {
                return null;
            }
            Configurator config = null;
            try {
                if (PackageUtil.isEncrypted((File)file)) {
                    progress.setStatus(new Message(2, Messages.SCAN_NOT_OPENED));
                    progress.setStatus(new Message(4, Messages.SCAN_ENCRYPTED));
                    return null;
                }
                SaveLocation saveLocation = new SaveLocation(file);
                scan.setSaveLocation(saveLocation);
                config = Configurator.load((IScan)scan, (IProgress)progress);
            }
            catch (IOException e) {
                progress.setStatus(new Message(2, Messages.bind(Messages.SCAN_NOT_FOUND, file.getName())));
                return null;
            }
            catch (Exception e) {
                progress.setStatus(new Message(2, Messages.SCAN_NOT_OPENED));
                return null;
            }
            if (config != null) {
                ScanManager manager = ScanManager.getInstance();
                manager.closeActiveScan((IProgress)progress);
                manager.setActiveScan(scan);
                progress.setStatus(new Message(1, Messages.SCAN_OPENED));
            }
            return scan;
        }
        progress.setStatus(new Message(2, Messages.UNSAVED_CHANGES));
        return null;
    }
}

