/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.config.Configurator;
import java.io.File;
import java.io.IOException;

public class SaveHandler {
    private ScanManager m_manager = ScanManager.getInstance();
    private IProgress m_progress = new ProgressAdapter(this.m_manager.getActiveScan());

    public boolean save() {
        boolean saveSuccess = false;
        IScan currentScan = this.m_manager.getActiveScan();
        if (currentScan == null) {
            this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_OPEN));
        } else {
            try {
                currentScan.save(this.m_progress);
                saveSuccess = true;
            }
            catch (IOException e) {
                this.m_progress.setStatus(new Message((Throwable)e));
                this.m_progress.setStatus(new Message(4, Messages.SCAN_NOT_SAVED));
            }
            if (saveSuccess) {
                CommonCLICore.getLogManager().log(new Message(1, Messages.SCAN_SAVED));
            }
        }
        return saveSuccess;
    }

    public boolean saveAs(String path) {
        boolean saveSuccess = false;
        IScan currentScan = this.m_manager.getActiveScan();
        if (currentScan == null) {
            this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_OPEN));
        } else {
            File file = new File(path);
            SaveLocation location = new SaveLocation(file);
            if (currentScan.getState() == ITransformable.State.TRANSFORMED) {
                IScan newScan = ScanModelFactory.newScan();
                newScan.setSaveLocation(location);
                try {
                    currentScan.saveTo(newScan, this.m_progress);
                    Configurator.load((IScan)newScan, (IProgress)this.m_progress);
                    saveSuccess = true;
                }
                catch (IOException e) {
                    this.m_progress.setStatus(new Message((Throwable)e));
                }
                this.m_manager.setActiveScan(newScan);
            } else {
                currentScan.setSaveLocation(location);
                try {
                    currentScan.save(this.m_progress);
                    saveSuccess = true;
                }
                catch (IOException e) {
                    this.m_progress.setStatus(new Message((Throwable)e));
                }
            }
            CommonCLICore.getLogManager().log(new Message(1, Messages.SCAN_SAVED));
        }
        return saveSuccess;
    }

    public boolean renameTo(String dest) {
        File destFile = new File(dest);
        IScan currentScan = this.m_manager.getActiveScan();
        boolean success = false;
        if (currentScan != null) {
            File sourceFile = currentScan.getSaveLocation().getFile();
            this.m_manager.closeActiveScan(null);
            success = sourceFile.renameTo(destFile);
            SaveLocation saveLocation = new SaveLocation(destFile);
            currentScan.setSaveLocation(saveLocation);
            this.m_manager.closeActiveScan(null);
            this.m_manager.setActiveScan(currentScan);
        }
        return success;
    }

    public boolean canSave() {
        IScan currentScan = this.m_manager.getActiveScan();
        return currentScan != null && currentScan.getSaveLocation() != null;
    }
}

