/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.common.utils.ConsoleUtil;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanTarget;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ScanTargetHandler {
    private ILogManager m_logManager = CommonCLICore.getLogManager();
    private IConsole m_console = CommonCLICore.getIOConsole();
    private ScanManager m_manager = ScanManager.getInstance();
    private IScan m_scan = this.m_manager.getActiveScan();
    private Map<String, Boolean> m_targets = new HashMap<String, Boolean>();
    private Message m_message;

    public void addScanTarget(String path, boolean outputsOnly) {
        if (this.isScanActive()) {
            ProgressAdapter progress = new ProgressAdapter(this.m_scan);
            File input = new File(path);
            if (!input.exists()) {
                progress.setStatus(new Message(2, Messages.bind(Messages.FILE_NOT_FOUND, path)));
            } else {
                this.m_targets.put(path, outputsOnly);
            }
        }
    }

    public void addScanTarget(URL url, boolean outputsOnly) {
        if (this.isScanActive()) {
            this.m_targets.put(url.toString(), outputsOnly);
        }
    }

    public Map<String, Boolean> getScanTargets() {
        return this.m_targets;
    }

    public void listScanTargets(boolean verbose) {
        if (this.isScanActive()) {
            Collection scanTargets = null;
            scanTargets = this.m_manager.getActiveScanTarget() == null ? this.m_scan.getScanTargets() : this.m_manager.getActiveScanTarget().getChildren();
            ArrayList<String[]> targets = new ArrayList<String[]>();
            Object[] headers = null;
            if (!verbose) {
                headers = new String[]{"Name", "Type", "Location"};
                for (IScanTarget target : scanTargets) {
                    String[] row = new String[]{target.getName(), target.getType(), target.getPath()};
                    targets.add(row);
                }
            } else {
                headers = new String[]{"Name", "Type", "Location", "Validated", "Plain Directory"};
                for (IScanTarget target : scanTargets) {
                    String[] row = new String[]{target.getName(), target.getType(), target.getPath(), String.valueOf(target.isValid()), String.valueOf(target.isDirectoryTarget())};
                    targets.add(row);
                }
            }
            this.m_console.println(ConsoleUtil.generateTable((String)"Scan Targets", (Object[])headers, targets));
        }
    }

    public void removeScanTarget(String path) {
        if (this.isScanActive()) {
            this.m_scan.setTransformed(false);
            IScanTarget toRemove = null;
            for (IScanTarget target : this.m_scan.getScanTargets()) {
                if (!target.getPath().equals(path)) continue;
                toRemove = target;
                break;
            }
            if (toRemove == null) {
                this.m_message = new Message(2, Messages.SCAN_TARGET_NOT_FOUND);
            } else {
                this.m_scan.removeScanTarget(toRemove);
                toRemove.dispose(null);
                this.m_message = new Message(1, Messages.SCAN_TARGET_REMOVED);
            }
            this.m_logManager.log(this.m_message);
            this.m_console.println(this.m_message);
        }
    }

    public void changeTarget(String input) {
        if (this.isScanActive()) {
            if (input.equalsIgnoreCase("/") || input.equalsIgnoreCase("\\")) {
                this.m_manager.setActiveScanTarget(null);
            } else if (input.equalsIgnoreCase("..")) {
                IScanTarget parent = this.m_manager.getActiveScanTarget().getParent();
                this.m_manager.setActiveScanTarget(parent);
            } else {
                Collection targets = null;
                targets = this.m_manager.getActiveScanTarget() == null ? this.m_scan.getScanTargets() : this.m_manager.getActiveScanTarget().getChildren();
                IScanTarget destinationTarget = null;
                for (IScanTarget target : targets) {
                    if (!target.getName().equals(input)) continue;
                    destinationTarget = target;
                    break;
                }
                if (destinationTarget == null) {
                    this.m_message = new Message(2, Messages.SCAN_TARGET_NOT_FOUND);
                    this.m_logManager.log(this.m_message);
                    this.m_console.println(this.m_message);
                } else {
                    this.m_manager.setActiveScanTarget(destinationTarget);
                }
            }
        }
    }

    public void printWorkingTarget() {
        if (this.isScanActive()) {
            ScanManager manager = ScanManager.getInstance();
            IScanTarget currentTarget = manager.getActiveScanTarget();
            this.m_console.println("Name: " + currentTarget.getName());
            this.m_console.println("Path: " + currentTarget.getPath());
            IScanTarget parent = currentTarget.getParent();
            if (parent != null) {
                this.m_console.println("Parent Target Name: " + parent.getName());
                this.m_console.println("Parent Target Path: " + parent.getPath());
            }
        }
    }

    private boolean isScanActive() {
        if (this.m_scan == null) {
            this.m_message = new Message(2, Messages.NO_SCAN_OPEN);
            this.m_logManager.log(this.m_message);
            this.m_console.println(this.m_message);
            return false;
        }
        return true;
    }
}

