/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jsp;

import com.hcl.appscan.discovery.java.utils.JDKHelper;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.validation.CompileError;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.discovery.dir.BaseCollector;
import com.ibm.appscan.discovery.jsp.Messages;
import com.ibm.appscan.discovery.jsp.compilers.BaseJSPCompiler;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class JSPCollector
extends BaseCollector {
    private boolean m_hasCompiler = true;
    private IScanTargetProxy m_proxy;

    JSPCollector(IScanTargetProxy proxy, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(includes, excludes);
        this.m_proxy = proxy;
    }

    public void process(File file, String path, IProgress progress) {
        if (this.acceptFile(file)) {
            Object object = this.m_proxy.getProperties().get("jsp_compiler");
            if (!(object instanceof BaseJSPCompiler)) {
                if (this.m_hasCompiler) {
                    this.m_proxy.getErrorManager().reportError(Messages.getMessage("no.jsp.compiler", new Object[0]), "jsp_compiler", null, 0, null);
                    this.m_hasCompiler = false;
                }
            } else {
                BaseJSPCompiler compiler = (BaseJSPCompiler)object;
                if (compiler.isSuccess()) {
                    Message message;
                    File[] compiledClasses = compiler.getCompiledClasses(path, progress);
                    if (compiledClasses.length != 0) {
                        for (File compiledClass : compiledClasses) {
                            IScanFile scanFile = ScanModelFactory.newScanFile((File)compiledClass);
                            scanFile.setSourcePath(this.m_proxy.getSourceAbsolutePath(path));
                            scanFile.setExcluded(this.isFileUserExcluded(file));
                            this.getCollectedFiles().add(scanFile);
                        }
                        return;
                    }
                    this.addExcludedFile(path);
                    String error = Messages.getMessage("err.jsp.compile", path);
                    this.m_proxy.getValidationIssues().add(new CompileError(file, error, IValidationIssue.SEVERITY.SEVERE));
                    Message message2 = message = new Message(2, error);
                    message2.getClass();
                    message.setMessageSource(new Message.MessageSource(message2, this.m_proxy.getPath(), file.getAbsolutePath(), 0));
                    this.m_proxy.getLogManager().log(message);
                } else {
                    this.addExcludedFile(path);
                }
            }
        }
    }

    public Set<IScanFile> getScanFiles() {
        if (!this.getCollectedFiles().isEmpty()) {
            try {
                JDKHelper.setJDKProperties((IScanTargetMinProxy)this.m_proxy);
            }
            catch (IOException e) {
                this.m_proxy.getErrorManager().reportError(e.getMessage(), "jdk_path", null, 0, (Throwable)e);
            }
        }
        return this.getCollectedFiles();
    }

    protected Set<String> getFileExtensions() {
        HashSet<String> fileExtensions = new HashSet<String>();
        fileExtensions.add("jsp");
        fileExtensions.add("jspx");
        return fileExtensions;
    }

    private void addExcludedFile(String path) {
        IScanFile scanFile = ScanModelFactory.newScanFile((String)path);
        scanFile.setSourcePath(path);
        scanFile.setExcluded(true);
        this.getCollectedFiles().add(scanFile);
    }

    protected String getFileExtensionSetName() {
        return "jsp";
    }
}

