/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.clazz.info;

import com.hcl.clazz.info.ClassFieldTracker;
import com.hcl.clazz.info.ClassInfo;
import com.hcl.clazz.info.FieldTracker;
import com.hcl.clazz.info.MethodInfo;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ClassFieldTrackerProvider {
    private ArrayList<ClassFieldTracker> m_class_field_trackers;
    private HashSet<String> m_in_methods;
    private HashSet<String> m_out_methods;
    private File m_vars_json;
    private JSONObject m_json;
    private ArrayList<JSONObject> m_classes = new ArrayList();

    public ClassFieldTrackerProvider() {
    }

    public ClassFieldTrackerProvider(File vars_json) throws FileNotFoundException, JSONException {
        this.m_vars_json = vars_json;
        this.getClassFieldTrackers();
    }

    private JSONObject getJsonRoot() throws JSONException {
        if (this.m_json == null) {
            this.m_json = new JSONObject();
            this.m_json.put("classes", this.m_classes);
        }
        return this.m_json;
    }

    public boolean isValidDataFlow(Finding finding) throws FileNotFoundException, JSONException {
        if (finding.getTrace() == null) {
            return true;
        }
        for (ClassFieldTracker cft : this.getClassFieldTrackers()) {
            if (cft.isValidDataFlow(finding)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<ClassFieldTracker> getClassFieldTrackers() throws JSONException, FileNotFoundException {
        if (this.m_class_field_trackers == null) {
            this.m_class_field_trackers = new ArrayList();
            if (this.m_vars_json != null && this.m_vars_json.exists()) {
                JSONObject json = new JSONObject((InputStream)new FileInputStream(this.m_vars_json));
                for (Object o : json.getJSONArray("classes")) {
                    JSONObject clazz = (JSONObject)o;
                    if (clazz == null || !clazz.containsKey((Object)"name")) continue;
                    ClassFieldTracker cft = new ClassFieldTracker(clazz.getString("name"));
                    this.m_class_field_trackers.add(cft);
                    for (Object class_field : clazz.getJSONArray("class_fields")) {
                        cft.addClassField(class_field.toString());
                    }
                    for (Object vars : clazz.getJSONArray("vars")) {
                        FieldTracker ft = new FieldTracker(((JSONObject)vars).getString("field"));
                        for (Object in : ((JSONObject)vars).getJSONArray("in")) {
                            ft.addInMethod(in.toString());
                        }
                        for (Object out : ((JSONObject)vars).getJSONArray("out")) {
                            ft.addOutMethod(out.toString());
                        }
                        cft.addFieldTracker(ft);
                    }
                }
            }
        }
        return this.m_class_field_trackers;
    }

    public HashSet<String> getInMethods() throws FileNotFoundException, JSONException {
        if (this.m_in_methods == null) {
            this.m_in_methods = new HashSet();
            for (ClassFieldTracker t : this.getClassFieldTrackers()) {
                for (FieldTracker ft : t.getFieldTrackers()) {
                    this.m_in_methods.addAll(ft.getInMethods());
                }
            }
        }
        return this.m_in_methods;
    }

    public HashSet<String> getOutMethods() throws FileNotFoundException, JSONException {
        if (this.m_out_methods == null) {
            this.m_out_methods = new HashSet();
            for (ClassFieldTracker t : this.getClassFieldTrackers()) {
                for (FieldTracker ft : t.getFieldTrackers()) {
                    this.m_out_methods.addAll(ft.getOutMethods());
                }
            }
        }
        return this.m_out_methods;
    }

    public void addClassInfoFieldTracking(ClassInfo ci) throws JSONException, VDBException {
        if (ci == null || ci.getClassName() == null) {
            return;
        }
        JSONObject clazz = new JSONObject();
        clazz.put("name", (Object)ci.getClassName());
        clazz.put("class_fields", ci.getClassFields());
        ArrayList<JSONObject> field_trackers_json = new ArrayList<JSONObject>();
        HashMap methods = new HashMap();
        for (MethodInfo mi : ci.getMethods()) {
            for (String s : mi.getClassFieldsPresent()) {
                if (!ci.getClassFields().contains(s)) continue;
                if (!methods.containsKey(s)) {
                    methods.put(s, new ArrayList());
                }
                ((ArrayList)methods.get(s)).add(mi);
            }
        }
        for (String field : methods.keySet()) {
            ArrayList<String> ins = new ArrayList<String>();
            ArrayList<String> outs = new ArrayList<String>();
            for (MethodInfo mi : (ArrayList)methods.get(field)) {
                Method m = MethodProvider.getMethod((String)mi.getFullSignature(), (Language.LANGUAGE)Language.LANGUAGE.JAVA);
                if (m.isConstructor() || m.isSetter()) {
                    ins.add(m.getSignature());
                    continue;
                }
                outs.add(m.getSignature());
            }
            JSONObject ft_json = new JSONObject();
            ft_json.put("field", (Object)field);
            ft_json.put("in", ins);
            ft_json.put("out", outs);
            field_trackers_json.add(ft_json);
        }
        clazz.put("vars", field_trackers_json);
        this.m_classes.add(clazz);
    }

    public void saveClassFieldTrackerJson(File out) throws JSONException, VDBException, IOException {
        IOUtil.write((String)this.getJsonRoot().toString(true), (File)out);
    }
}

