/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;

public class Bench {
    private static final boolean disasm = true;
    private static final boolean verify = true;
    private static OfflineInstrumenter instrumenter;
    private static final boolean doEntry = true;
    private static boolean doExit;
    private static boolean doException;
    static final String fieldName = "_Bench_enable_trace";
    static final Instruction getSysErr;
    static final Instruction callPrintln;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            ClassInstrumenter ci;
            BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
            if ((args = instrumenter.parseStandardArgs(args)).length > 0) {
                if (args[0].equals("-doexit")) {
                    doExit = true;
                } else if (args[0].equals("-doexception")) {
                    doExit = true;
                    doException = true;
                }
            }
            instrumenter = new OfflineInstrumenter(!doException);
            instrumenter.setPassUnmodifiedClasses(true);
            instrumenter.beginTraversal();
            while ((ci = instrumenter.nextClass()) != null) {
                Bench.doClass(ci, w);
            }
            instrumenter.close();
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        final String className = ci.getReader().getName();
        w.write("Class: " + className + "\n");
        w.flush();
        for (int m = 0; m < ci.getReader().getMethodCount(); ++m) {
            MethodData d = ci.visitMethod(m);
            if (d == null) continue;
            w.write("Instrumenting " + ci.getReader().getMethodName(m) + " " + ci.getReader().getMethodType(m) + ":\n");
            w.flush();
            w.write("Initial ShrikeBT code:\n");
            new Disassembler(d).disassembleTo(w);
            w.flush();
            Verifier v = new Verifier(d);
            v.verify();
            MethodEditor me = new MethodEditor(d);
            me.beginPass();
            final String msg0 = "Entering call to " + Util.makeClass("L" + ci.getReader().getName() + ";") + "." + ci.getReader().getMethodName(m);
            final int noTraceLabel = me.allocateLabel();
            me.insertAtStart(new MethodEditor.Patch(){

                @Override
                public void emitTo(MethodEditor.Output w) {
                    w.emit(GetInstruction.make("Z", CTDecoder.convertClassToType(className), Bench.fieldName, true));
                    w.emit(ConstantInstruction.make(0));
                    w.emit(ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.EQ, noTraceLabel));
                    w.emit(getSysErr);
                    w.emit(ConstantInstruction.makeString(msg0));
                    w.emit(callPrintln);
                    w.emitLabel(noTraceLabel);
                }
            });
            if (doExit) {
                msg0 = "Exiting call to " + Util.makeClass("L" + ci.getReader().getName() + ";") + "." + ci.getReader().getMethodName(m);
                IInstruction[] instr = me.getInstructions();
                for (int i = 0; i < instr.length; ++i) {
                    if (!(instr[i] instanceof ReturnInstruction)) continue;
                    final int noTraceLabel2 = me.allocateLabel();
                    me.insertBefore(i, new MethodEditor.Patch(){

                        @Override
                        public void emitTo(MethodEditor.Output w) {
                            w.emit(GetInstruction.make("Z", CTDecoder.convertClassToType(className), Bench.fieldName, true));
                            w.emit(ConstantInstruction.make(0));
                            w.emit(ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.EQ, noTraceLabel2));
                            w.emit(getSysErr);
                            w.emit(ConstantInstruction.makeString(msg0));
                            w.emit(callPrintln);
                            w.emitLabel(noTraceLabel2);
                        }
                    });
                }
            }
            if (doException) {
                msg0 = "Exception exiting call to " + Util.makeClass("L" + ci.getReader().getName() + ";") + "." + ci.getReader().getMethodName(m);
                noTraceLabel = me.allocateLabel();
                me.addMethodExceptionHandler(null, new MethodEditor.Patch(){

                    @Override
                    public void emitTo(MethodEditor.Output w) {
                        w.emit(GetInstruction.make("Z", CTDecoder.convertClassToType(className), Bench.fieldName, true));
                        w.emit(ConstantInstruction.make(0));
                        w.emit(ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.EQ, noTraceLabel));
                        w.emit(getSysErr);
                        w.emit(ConstantInstruction.makeString(msg0));
                        w.emit(callPrintln);
                        w.emitLabel(noTraceLabel);
                        w.emit(ThrowInstruction.make(false));
                    }
                });
            }
            me.applyPatches();
            w.write("Final ShrikeBT code:\n");
            new Disassembler(d).disassembleTo(w);
            w.flush();
        }
        if (ci.isChanged()) {
            ClassWriter cw = ci.emitClass();
            cw.addField(9, fieldName, "Z", new ClassWriter.Element[0]);
            instrumenter.outputModifiedClass(ci, cw);
        }
    }

    static {
        doExit = false;
        doException = false;
        getSysErr = Util.makeGet(System.class, "err");
        callPrintln = Util.makeInvoke(PrintStream.class, "println", new Class[]{String.class});
    }
}

