/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.cg;

import com.ibm.wala.shrike.cg.OfflineDynamicCallGraph;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrikeBT.shrikeCT.CTUtils;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;

public class OnlineDynamicCallGraph
implements ClassFileTransformer {
    private ClassHierarchyStore cha = new ClassHierarchyStore();
    private Writer out = new PrintWriter(System.err);

    public OnlineDynamicCallGraph() throws IllegalArgumentException, IOException, InvalidClassFileException {
        ClassInstrumenter ci;
        OfflineInstrumenter libReader = new OfflineInstrumenter(true);
        for (String cps : new String[]{System.getProperty("java.class.path"), System.getProperty("sun.boot.class.path")}) {
            for (String cp : cps.split(File.pathSeparator)) {
                File x = new File(cp);
                if (!x.exists()) continue;
                if (x.isDirectory()) {
                    libReader.addInputDirectory(x, x);
                    continue;
                }
                libReader.addInputJar(x);
            }
        }
        while ((ci = libReader.nextClass()) != null) {
            CTUtils.addClassToHierarchy(this.cha, ci.getReader());
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (className.contains("com/ibm/wala") || className.contains("java/lang") || className.contains("java/") && !className.matches("java/util/[A-Z]") || className.contains("sun/")) {
                return classfileBuffer;
            }
            ClassInstrumenter ci = new ClassInstrumenter(className, classfileBuffer, (ClassHierarchyProvider)this.cha, false);
            return OfflineDynamicCallGraph.doClass(ci, this.out).makeBytes();
        }
        catch (Analyzer.FailureException | InvalidClassFileException | IOException e) {
            e.printStackTrace();
            System.err.println("got here with " + e.getMessage());
            throw new IllegalClassFormatException(e.getMessage());
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) throws IllegalArgumentException, IOException, InvalidClassFileException {
        inst.addTransformer(new OnlineDynamicCallGraph());
    }
}

