/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import java.io.IOException;
import java.io.Writer;

public class Disassembler {
    private final IInstruction[] instructions;
    private final ExceptionHandler[][] handlers;
    private final int[] instructionsToBytecodes;

    public Disassembler(IInstruction[] instructions, ExceptionHandler[][] handlers, int[] instructionsToBytecodes) {
        this.instructions = instructions;
        this.handlers = handlers;
        this.instructionsToBytecodes = instructionsToBytecodes;
    }

    public Disassembler(MethodData data) throws NullPointerException {
        this(data.getInstructions(), data.getHandlers(), data.getInstructionsToBytecodes());
    }

    public void disassembleTo(String prefix, Writer w) throws IOException {
        for (int j = 0; j < this.instructions.length; ++j) {
            w.write(prefix + j + ": " + this.instructions[j] + " (" + this.instructionsToBytecodes[j] + ")\n");
            for (int k = 0; k < this.handlers[j].length; ++k) {
                w.write(prefix + "    Handles " + this.handlers[j][k].catchClass + " at " + this.handlers[j][k].handler + "\n");
            }
        }
    }

    public void disassembleTo(Writer w) throws IOException {
        this.disassembleTo("", w);
    }
}

