/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IStringConstantPropagationSelector;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.StringConstantPropagationAnalysis;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.regular.RegularConstraintSolver;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collections;

public class CustomRegularConstraintSolver
extends RegularConstraintSolver {
    private static final boolean enableHeuristics = Boolean.getBoolean("com.ibm.wala.taint.sa.heuristics");
    private final IStringConstantPropagationSelector scpSelector;
    private boolean isFirstRewriting = false;

    public CustomRegularConstraintSolver(ITranslatorRepository<IAutomaton> translators, IStringConstantPropagationSelector scpSelector, ISolverCache<IAutomaton> cache, ISolverStack stack, MonitorUtil.IProgressMonitor monitor) {
        super(translators, cache, stack, monitor);
        this.scpSelector = scpSelector;
    }

    protected void init() {
        this.isFirstRewriting = true;
        super.init();
    }

    protected SimpleGrammar solveByRewriting(SimpleGrammar g) {
        SimpleGrammar g2 = super.solveByRewriting(g);
        if (enableHeuristics && this.isFirstRewriting) {
            this.isFirstRewriting = false;
            SimpleGrammar g3 = StringConstantPropagationAnalysis.manageConstantString(g2, Collections.singleton(g2.getStartSymbol()), this.scpSelector);
            return g3;
        }
        return g2;
    }
}

