/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.samso.client.IPathVerifier;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.stringAnalysis.client.IStringVerifier;
import com.ibm.wala.stringAnalysis.client.StringVerifier;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.ReturnVariable;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IStringAnalysisDriver;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IStringAnalyzerProvider;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SALogger;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SignatureUtil;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.StringAnalysisStatus;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class StringAnalysisDriver<T>
implements IStringAnalysisDriver {
    private static Collection<Language> supportedLanguage = new HashSet<Language>();
    private ITranslatorRepository<T> repository;
    private final AnalysisOptions analysisOptions;
    private final ILangServices langSpecificServices;
    private final IStringAnalyzerProvider<T> stringAnalyzerProvider;

    public StringAnalysisDriver(IStringAnalyzerProvider<T> stringAnalyzerProvider, AnalysisOptions analysisOptions, ILangServices languageSpecificServices) {
        this.stringAnalyzerProvider = stringAnalyzerProvider;
        this.repository = stringAnalyzerProvider.createTranslatorRepository();
        this.analysisOptions = analysisOptions;
        this.langSpecificServices = languageSpecificServices;
    }

    @Override
    public void scanMethods(Collection<CGNode> candidates, CallGraph cg, AnalysisCache analysisCache, StringAnalysisStatus stat, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        Language lang = this.langSpecificServices.getLanguage();
        if (!supportedLanguage.contains(lang)) {
            SALogger.logger.info((Object)("unsupported language: " + lang));
            return;
        }
        WeakHashMap<CGNode, GR> grCache = new WeakHashMap<CGNode, GR>();
        for (CGNode n : candidates) {
            this.scanMethod(n, stat, cg, grCache, monitor, logger);
        }
    }

    private void scanMethod(CGNode n, StringAnalysisStatus stat, CallGraph cg, Map<CGNode, GR> grCache, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        try {
            IGrammarBasedStringAnalyzer<T> sa = this.stringAnalyzerProvider.createStringAnalyzer(cg, n, this.analysisOptions, this.repository, grCache, monitor, logger);
            IR ir = n.getIR();
            if (ir == null) {
                stat.reportSanitizer(n.getMethod(), stat.getIllegalPatterns(), SanitizerKind.NONE);
                return;
            }
            if (SignatureUtil.isStringish(n.getMethod().getReturnType(), n.getClassHierarchy(), this.langSpecificServices)) {
                this.scanSanitizer(cg, n, ir, sa, stat, monitor);
            }
            if (TypeReference.Boolean.equals((Object)n.getMethod().getReturnType())) {
                this.scanValidator(n, sa, stat, monitor, logger);
            }
        }
        catch (RuntimeException e) {
            logger.trace((Object)"trouble in scanMethopd", (Throwable)e);
            if (SAUtil.DEBUG) {
                SALogger.logger.warn((Object)e.getMessage());
            }
            stat.reportSanitizer(n.getMethod(), stat.getIllegalPatterns(), SanitizerKind.ABORTED);
        }
    }

    private void scanValidator(CGNode n, IGrammarBasedStringAnalyzer<T> sa, StringAnalysisStatus stat, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        IPathVerifier pathVerifier = this.stringAnalyzerProvider.createPathVerifier(sa, monitor, logger);
        if (pathVerifier == null) {
            return;
        }
        for (SASpec illegalPattern : stat.getIllegalPatterns()) {
            if (pathVerifier.checkInfeasibility(n, illegalPattern.getPatternStr(), true)) {
                stat.reportSanitizer(n.getMethod(), Collections.singleton(illegalPattern), SanitizerKind.POSITIVE_VALIDATOR);
                continue;
            }
            if (pathVerifier.checkInfeasibility(n, illegalPattern.getPatternStr(), false)) {
                stat.reportSanitizer(n.getMethod(), Collections.singleton(illegalPattern), SanitizerKind.NEGATIVE_VALIDATOR);
                continue;
            }
            stat.reportSanitizer(n.getMethod(), Collections.singleton(illegalPattern), SanitizerKind.NONE);
        }
    }

    private void scanSanitizer(CallGraph cg, CGNode n, IR ir, IGrammarBasedStringAnalyzer<T> sa, StringAnalysisStatus stat, MonitorUtil.IProgressMonitor monitor) {
        IStringVerifier<T, IVariable> stringVerifier = this.stringAnalyzerProvider.createStringVerifier(sa, monitor);
        for (SASpec illegalPattern : stat.getIllegalPatterns()) {
            HashSet<StringVerifier.Rule> rules = new HashSet<StringVerifier.Rule>();
            Collection<ReturnVariable> vars = this.findTargetVariables(cg, n, ir, sa);
            for (IVariable iVariable : vars) {
                StringVerifier.Rule rule = new StringVerifier.Rule((Object)iVariable, null, illegalPattern.getPatternStr());
                rules.add(rule);
            }
            Map results = stringVerifier.verify(rules);
            if (this.isAllLegal(results.values())) {
                stat.reportSanitizer(n.getMethod(), Collections.singleton(illegalPattern), SanitizerKind.SANITIZER);
                continue;
            }
            stat.reportSanitizer(n.getMethod(), Collections.singleton(illegalPattern), SanitizerKind.NONE);
        }
    }

    private boolean isAllLegal(Collection<IStringVerifier.IResult<T, IVariable>> rs) {
        for (IStringVerifier.IResult<T, IVariable> r : rs) {
            if (r != null && r.isLegal()) continue;
            return false;
        }
        return true;
    }

    private Collection<ReturnVariable> findTargetVariables(CallGraph cg, final CGNode n, IR ir, IGrammarBasedStringAnalyzer<T> sa) {
        HashSet targetVNs = HashSetFactory.make();
        for (SSAInstruction instruction : ir.getInstructions()) {
            if (!(instruction instanceof SSAReturnInstruction)) continue;
            SSAReturnInstruction returnInstr = (SSAReturnInstruction)instruction;
            ISSABasicBlock bb = ir.getBasicBlockForInstruction(instruction);
            int vn = returnInstr.getUse(0);
            assert (vn != -1) : "in node " + n + " return instruction " + returnInstr + " returns void";
            targetVNs.add(Pair.make((Object)vn, (Object)bb));
        }
        Collection vars = SAUtil.findReturnVariables((GR)sa.getGR(), (CallGraph)cg, (SAUtil.IReturnVariableFinder)new SAUtil.IReturnVariableFinder(){

            public boolean isTargetNode(CGNode node) {
                return node.equals(n);
            }
        });
        return vars;
    }

    static {
        supportedLanguage.add((Language)Language.JAVA);
        supportedLanguage.add(CLRLanguage.lang);
    }
}

