/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationStatusReport;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.CollectSaStatus;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ApplicationResult {
    private Map<String, Map<SASpec, SanitizerKind>> data = new TreeMap<String, Map<SASpec, SanitizerKind>>();
    private Map<String, String> sigToTestCase = HashMapFactory.make();
    private Map<String, String> sigToComment = HashMapFactory.make();
    private final String application;
    private final Collection<SASpec> illegalPatterns;

    public ApplicationResult(String application, Collection<SASpec> illegalPatterns) {
        this.application = application;
        this.illegalPatterns = illegalPatterns;
    }

    public void add(String method, Map<SASpec, SanitizerKind> patternToIsSanitizer, String testCase, String comment) {
        this.data.put(method, patternToIsSanitizer);
        this.sigToTestCase.put(method, testCase);
        this.sigToComment.put(method, comment);
    }

    public Iterator<Map.Entry<String, Map<SASpec, SanitizerKind>>> iterator() {
        return this.data.entrySet().iterator();
    }

    public Set<String> getMethods() {
        return this.data.keySet();
    }

    public SanitizerKind getSanitizerKind(String method, SASpec p) {
        return this.data.get(method).get(p);
    }

    public boolean isSanitizer(String method, SASpec p) {
        return SanitizerKind.SANITIZER.equals((Object)this.getSanitizerKind(method, p));
    }

    public boolean isPositiveValidator(String method, SASpec p) {
        return SanitizerKind.POSITIVE_VALIDATOR.equals((Object)this.getSanitizerKind(method, p));
    }

    public boolean isNegativeValidator(String method, SASpec p) {
        return SanitizerKind.NEGATIVE_VALIDATOR.equals((Object)this.getSanitizerKind(method, p));
    }

    public boolean isValidator(String method, SASpec p) {
        return this.isPositiveValidator(method, p) || this.isNegativeValidator(method, p);
    }

    public String getTestCase(String method) {
        return this.sigToTestCase.get(method);
    }

    public String getComment(String method) {
        return this.sigToComment.get(method);
    }

    public String toUserString() {
        ArrayList<String> nonSanitizers = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("String analysis results: \n");
        Set<String> methods = this.getMethods();
        for (String method : methods) {
            String sanitizationTypes = "";
            for (SASpec p : this.illegalPatterns) {
                if (!this.isSanitizer(method, p)) continue;
                if (sanitizationTypes.length() > 0) {
                    sanitizationTypes = sanitizationTypes + ", ";
                }
                sanitizationTypes = sanitizationTypes + p.getName();
            }
            if (sanitizationTypes.length() > 0) {
                String line = "Method " + method + " is a sanitizer for issues: " + sanitizationTypes;
                sb.append(line);
                sb.append("\n");
                continue;
            }
            nonSanitizers.add(method);
        }
        if (nonSanitizers.size() > 0) {
            sb.append("The following methods were detected as non sanitizers:\n");
            for (String m : nonSanitizers) {
                sb.append("\t" + m + "\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> methods = this.getMethods();
        for (String method : methods) {
            String line = this.application + "," + method;
            for (SASpec p : this.illegalPatterns) {
                if (this.isSanitizer(method, p)) {
                    line = line + ",V";
                    continue;
                }
                if (this.isPositiveValidator(method, p)) {
                    line = line + ",PV";
                    continue;
                }
                if (this.isNegativeValidator(method, p)) {
                    line = line + ",NV";
                    continue;
                }
                line = line + ",X";
            }
            line = line + "," + this.getTestCase(method) + "," + this.getComment(method);
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getApplication() {
        return this.application;
    }

    public Map<SASpec, SanitizerKind> getMethodInfo(String method) {
        return this.data.get(method);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public static String getRegressionIfExists(String applicationName, ApplicationResult expectedSaResult, ApplicationResult actualSaResults) {
        ApplicationStatusReport analyzedResults = CollectSaStatus.analyzeResultForOneApplication(applicationName, expectedSaResult, expectedSaResult, actualSaResults, null);
        return analyzedResults.getRegressionIfExists();
    }

    public Collection<SASpec> getIllegalPatterns() {
        return this.illegalPatterns;
    }
}

