/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationResult;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.CollectSaStatus;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.TimingData;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class ApplicationStatusReport {
    private final String application;
    private final ApplicationResult applicationTrueSet;
    private final Map<String, Map<SASpec, CollectSaStatus.Classification>> methodToPatternToClassification;
    private final TimingData applicationTiming;
    private int tp;
    private int fp;
    private int fn;

    public ApplicationStatusReport(String application, ApplicationResult applicationTrueSet, TimingData applicationTiming) {
        this.application = application;
        this.applicationTrueSet = applicationTrueSet;
        this.methodToPatternToClassification = new TreeMap<String, Map<SASpec, CollectSaStatus.Classification>>();
        this.applicationTiming = applicationTiming;
        this.tp = 0;
        this.fp = 0;
        this.fn = 0;
    }

    public void print(PrintWriter pw) {
        for (String method : this.methodToPatternToClassification.keySet()) {
            CollectSaStatus.Classification classification;
            Map<SASpec, CollectSaStatus.Classification> patternToClassification = this.methodToPatternToClassification.get(method);
            String simpleMethod = method.replaceAll("Ljava/lang/String", "String");
            StringBuffer lineBuf = new StringBuffer(String.format("%s,%s", this.application, simpleMethod));
            Collection<SASpec> illegalPatterns = this.applicationTrueSet.getIllegalPatterns();
            for (SASpec p : illegalPatterns) {
                classification = patternToClassification.get(p);
                String isSantizer = classification.isSanitizer ? "V" : "";
                lineBuf.append("," + isSantizer);
            }
            for (SASpec p : illegalPatterns) {
                classification = patternToClassification.get(p);
                String saResults = classification.saResult ? "V" : "";
                lineBuf.append("," + saResults);
            }
            for (SASpec p : illegalPatterns) {
                classification = patternToClassification.get(p);
                lineBuf.append("," + classification.classification);
            }
            for (SASpec p : illegalPatterns) {
                classification = patternToClassification.get(p);
                lineBuf.append("," + classification.diff);
            }
            String testCase = this.applicationTrueSet.getTestCase(method);
            if (testCase == null) {
                testCase = "";
            }
            lineBuf.append("," + testCase);
            String comment = this.applicationTrueSet.getComment(method);
            if (comment == null) {
                comment = "";
            }
            lineBuf.append("," + comment);
            pw.println(lineBuf.toString());
        }
    }

    public void addResult(String method, Map<SASpec, SanitizerKind> trueSetResMap, Map<SASpec, SanitizerKind> expectedResMap, Map<SASpec, SanitizerKind> resultResMap) {
        if (method.startsWith("Fixed-")) {
            return;
        }
        Collection<SASpec> illegalPatterns = this.applicationTrueSet.getIllegalPatterns();
        for (SASpec p : illegalPatterns) {
            SanitizerKind trueSetRes = SanitizerKind.NONE;
            if (trueSetResMap != null && null != trueSetResMap.get(p)) {
                trueSetRes = trueSetResMap.get(p);
            }
            SanitizerKind expectedRes = SanitizerKind.NONE;
            if (expectedResMap != null && null != expectedResMap.get(p)) {
                expectedRes = expectedResMap.get(p);
            }
            SanitizerKind resultRes = SanitizerKind.NONE;
            if (resultResMap != null && null != resultResMap.get(p)) {
                resultRes = resultResMap.get(p);
            }
            this.addResult(method, p, trueSetRes, expectedRes, resultRes);
        }
    }

    private void addResult(String method, SASpec p, SanitizerKind trueSetRes, SanitizerKind expectedRes, SanitizerKind resultRes) {
        CollectSaStatus.Classification classification;
        if (resultRes.isSanitizerOrValidator()) {
            if (resultRes.equals((Object)trueSetRes)) {
                ++this.tp;
                classification = resultRes.equals((Object)expectedRes) ? CollectSaStatus.Classification.KnownTp : CollectSaStatus.Classification.NewTp;
            } else {
                ++this.fp;
                classification = resultRes.equals((Object)expectedRes) ? CollectSaStatus.Classification.KnownFp : CollectSaStatus.Classification.NewFp;
            }
        } else if (resultRes.equals((Object)trueSetRes)) {
            classification = resultRes.equals((Object)expectedRes) ? CollectSaStatus.Classification.KnownTn : CollectSaStatus.Classification.SolvedFp;
        } else {
            ++this.fn;
            classification = resultRes.equals((Object)expectedRes) ? CollectSaStatus.Classification.KnownFn : CollectSaStatus.Classification.NewFn;
        }
        Map<SASpec, CollectSaStatus.Classification> patternToClassification = this.methodToPatternToClassification.get(method);
        if (patternToClassification == null) {
            patternToClassification = new TreeMap<SASpec, CollectSaStatus.Classification>();
            this.methodToPatternToClassification.put(method, patternToClassification);
        }
        patternToClassification.put(p, classification);
    }

    public int getTp() {
        return this.tp;
    }

    public int getFp() {
        return this.fp;
    }

    public int getFn() {
        return this.fn;
    }

    public String getRegressionIfExists() {
        Collection<SASpec> illegalPatterns = this.applicationTrueSet.getIllegalPatterns();
        for (String method : this.methodToPatternToClassification.keySet()) {
            Map<SASpec, CollectSaStatus.Classification> patternToClassification = this.methodToPatternToClassification.get(method);
            String simpleMethod = method.replaceAll("Ljava/lang/String", "String");
            StringBuffer lineBuf = new StringBuffer(String.format("%s,%s", this.application, simpleMethod));
            for (SASpec p : illegalPatterns) {
                CollectSaStatus.Classification classification = patternToClassification.get(p);
                if (!classification.diff.equals("X")) continue;
                lineBuf.append("\t" + p);
                lineBuf.append("\t" + classification.toString());
                return lineBuf.toString();
            }
        }
        return null;
    }

    public int getSaTime() {
        if (this.applicationTiming != null) {
            return this.applicationTiming.getSaTime();
        }
        return -1;
    }

    public int getTotalTime() {
        if (this.applicationTiming != null) {
            return this.applicationTiming.getTotalTime();
        }
        return -1;
    }
}

