/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.loader.csharp.CSharpInterface;
import com.ibm.wala.dotnet.loader.dotgnu.DotGnuInterface;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.UserLog;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.PlatformUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ScopeUtil {
    public static AnalysisScope getScope(File scopeFileAbsolutePath, Language lang, File exclusionFile) throws IOException {
        String modifiedAbsolutePath = ScopeUtil.getFixedAnalysisScope(scopeFileAbsolutePath.getAbsolutePath());
        AnalysisScope scope = null;
        scope = lang.equals(Language.JAVA) ? AnalysisScopeReader.readJavaScope((String)modifiedAbsolutePath, (File)exclusionFile.getAbsoluteFile(), (ClassLoader)AbstractAnalysisEngine.class.getClassLoader()) : ScopeUtil.getDotNetAnalysisScope(modifiedAbsolutePath, exclusionFile.getAbsolutePath());
        new File(modifiedAbsolutePath).delete();
        return scope;
    }

    public static String getFixedAnalysisScope(String analysisFileTemplate) throws IOException {
        String line;
        File tempAnalysisFile = File.createTempFile("analysisScope", null);
        BufferedReader in = new BufferedReader(new FileReader(analysisFileTemplate));
        if (!in.ready()) {
            throw new IOException();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(tempAnalysisFile));
        while ((line = in.readLine()) != null) {
            if (line.contains("primordial.jar.model")) {
                line = "Primordial,Java,jarFile," + new FileProvider().getFile("primordial.jar.model").getAbsolutePath();
            }
            if (line.contains("${WorkSpace}")) {
                line = line.replace("${WorkSpace)", System.getProperty("WorkSpace"));
            }
            out.write(line);
            out.newLine();
        }
        in.close();
        out.close();
        return tempAnalysisFile.getAbsolutePath();
    }

    public static Iterator<CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer>> getDotNetAnalysisScopes(String metascopeFileName, final String exclusionFile) {
        final ArrayList<String> files = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(metascopeFileName));
            String line = "";
            if (!in.ready()) {
                throw new IOException();
            }
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                files.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Iterator<CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < files.size() - 1;
            }

            @Override
            public CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> next() {
                String nextPrivateScope = (String)files.get(this.index++);
                if (SAUtil.DEBUG) {
                    UserLog.logger.info((Object)("INFO: computing scope for " + nextPrivateScope));
                }
                return ScopeUtil.getDotNetAnalysisScope(nextPrivateScope, exclusionFile);
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public static CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> getDotNetAnalysisScope(String scopeFileName, final String exclusionFile) {
        ArrayList<String> files = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(scopeFileName));
            String line = "";
            if (!in.ready()) {
                throw new IOException();
            }
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                files.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SetOfClasses exclusions = new SetOfClasses(){
            private final Collection<String> exclusionsList;
            private static final long serialVersionUID = 1L;
            {
                this.exclusionsList = this.parseExclusionsFile(exclusionFile);
            }

            private Collection<String> parseExclusionsFile(String exclusionsFile) {
                HashSet result = HashSetFactory.make();
                try {
                    BufferedReader in = new BufferedReader(new FileReader(exclusionFile));
                    String line = "";
                    if (!in.ready()) {
                        throw new IOException();
                    }
                    while ((line = in.readLine()) != null) {
                        if (line.trim().length() == 0) continue;
                        result.add(line);
                    }
                    in.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return result;
            }

            public boolean contains(String klassName) {
                for (String exclusion : this.exclusionsList) {
                    if (!klassName.startsWith(exclusion)) continue;
                    return true;
                }
                return false;
            }

            public void add(String klass) {
                Assertions.UNREACHABLE();
            }
        };
        Iterator itr = files.iterator();
        String sysLine = (String)itr.next();
        String sysPath = sysLine.substring(sysLine.indexOf(44) + 1);
        File sysAssembly = new File(sysPath);
        HashSet appAssemblies = HashSetFactory.make();
        HashSet libAssemblies = HashSetFactory.make();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            int indexOfFirstComma = line.indexOf(44);
            String appOrLib = line.substring(0, indexOfFirstComma);
            String path = line.substring(indexOfFirstComma + 1);
            if (appOrLib.equals("app")) {
                appAssemblies.add(new File(path));
                continue;
            }
            assert (appOrLib.equals("lib"));
            libAssemblies.add(new File(path));
        }
        LowLevelInterface<Integer, Integer, Integer, Integer, Integer> i = ScopeUtil.getDotNetLowLevelInterface();
        i.clearCaches();
        CLRAnalysisScope scope = new CLRAnalysisScope(sysAssembly, (Set)libAssemblies, (Set)appAssemblies, exclusions, i);
        return scope;
    }

    private static LowLevelInterface<Integer, Integer, Integer, Integer, Integer> getDotNetLowLevelInterface() {
        return PlatformUtil.onMacOSX() ? new DotGnuInterface() : new CSharpInterface();
    }

    public static Iterator<String> getDotNetScopePaths(String metascopePath) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(metascopePath));
            String line = "";
            if (!in.ready()) {
                throw new IOException();
            }
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                paths.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return paths.iterator();
    }

    public static String getWorkspaceDir() {
        String workspaceDir = System.getProperty("WorkSpace");
        assert (workspaceDir != null) : "should set WorkSpace property";
        return workspaceDir;
    }
}

