/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.stringAnalysis.sanitizerDetection.diagnostics.ITiming;
import com.ibm.wala.stringAnalysis.sanitizerDetection.diagnostics.TimedSection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;

public class TimingData {
    private static final String EXTENTION = ".timing";
    private final Map<String, String> lines;

    public static TimingData readFromFile(File f) throws IOException {
        String line;
        TreeMap<String, String> lines = new TreeMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String[] tokens = line.split(",");
            lines.put(tokens[0], tokens[1]);
        }
        br.close();
        return new TimingData(lines);
    }

    public static TimingData createFromTiming(ITiming timing) {
        return new TimingData(timing.getResults());
    }

    private TimingData(Map<String, String> lines) {
        this.lines = lines;
    }

    public void print(PrintWriter pw) {
        for (String key : this.lines.keySet()) {
            String data = this.lines.get(key);
            pw.println(key + "," + data);
        }
    }

    public int getSaTime() {
        String saTimeString = this.lines.get(TimedSection.StringAnalysis.toString());
        if (saTimeString != null) {
            return Integer.parseInt(saTimeString);
        }
        return -1;
    }

    public int getTotalTime() {
        String saTimeString = this.lines.get(TimedSection.Total.toString());
        if (saTimeString != null) {
            return Integer.parseInt(saTimeString);
        }
        return -1;
    }

    public void writeToFile(File file) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(file);
        this.print(pw);
        pw.close();
    }

    public static String getTimingFile(String applicationName) {
        return applicationName + EXTENTION;
    }

    public static boolean isTimingResultFile(String name) {
        return name.endsWith(EXTENTION);
    }

    public static String fileNameToAppName(String fileName) {
        return fileName.substring(0, fileName.length() - EXTENTION.length()).replace('#', '/');
    }
}

