/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.gradle;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GradleDependencyCollector
implements IDependencyCollector {
    private File m_buildGradle;
    private ILogManager m_log;
    private boolean m_shouldRunTrivy = true;

    public GradleDependencyCollector(File buildGradle, ILogManager logManager) {
        this.m_buildGradle = buildGradle;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "Gradle".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return "trivy";
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_buildGradle.getParentFile();
    }

    @Override
    public String getToolName() {
        return "Gradle";
    }

    @Override
    public boolean shouldSkipToolCheck() {
        return true;
    }

    @Override
    public Map<File, String> getDependencies(File location, String uuid) throws IOException {
        if (!DiscoveryCore.isTopLevelTarget((File)this.m_buildGradle.getParentFile())) {
            return null;
        }
        HashMap<File, String> files = new HashMap();
        List<File> buildGradleFiles = new ArrayList<File>();
        String backupBuildGradleFile = null;
        String outputFile = uuid + "_trivy_cyclon_report.json";
        ThirdPartyLibUtils.createTrivyStagingDir(location, this.m_log);
        buildGradleFiles = ThirdPartyLibUtils.findAllConfigFiles(this.m_buildGradle.getParentFile(), buildGradleFiles, "build.gradle");
        buildGradleFiles = ThirdPartyLibUtils.findAllConfigFiles(this.m_buildGradle.getParentFile(), buildGradleFiles, "build.gradle.kts");
        try {
            for (File file : buildGradleFiles) {
                File gradleLockFile = new File(file.getParent(), "gradle.lockfile");
                if (!gradleLockFile.isFile()) {
                    backupBuildGradleFile = file + ".APPSCAN_BAK";
                    if (!this.hasLockConfigSetting(file)) {
                        this.m_log.log(new Message(1, Messages.getMessage("lock.config.setting.not.found", new File(file.getParent()))));
                        Files.copy(file.toPath(), Paths.get(backupBuildGradleFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        this.m_log.log(new Message(1, Messages.getMessage("modify.build.gradle", new File(file.getParent()))));
                        String depLockSetting = "\n\ndependencyLocking {\n\tlockAllConfigurations()\n}";
                        FileWriter fileWriter = new FileWriter(file, true);
                        fileWriter.write(depLockSetting);
                        fileWriter.flush();
                        fileWriter.close();
                    } else {
                        this.m_log.log(new Message(1, Messages.getMessage("lock.config.setting.found", new File(file.getParent()))));
                    }
                    if (this.createdGradleLockFile(file)) {
                        this.m_log.log(new Message(1, Messages.getMessage("created.gradle.lock.file", new File(file.getParent()))));
                        continue;
                    }
                    this.m_log.log(new Message(1, Messages.getMessage("gradle.lock.file.creation.failed", new File(file.getParent()))));
                    continue;
                }
                this.m_log.log(new Message(1, Messages.getMessage("gradle.lock.file.exists", new File(file.getParent()))));
            }
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        files = ThirdPartyLibUtils.runTrivyAndCollectOutputFile(location, outputFile, this.m_buildGradle, this.m_shouldRunTrivy, this.m_log);
        ThirdPartyLibUtils.restoreAllConfigFiles(buildGradleFiles, backupBuildGradleFile);
        this.m_shouldRunTrivy = true;
        return files;
    }

    private boolean createdGradleLockFile(File file) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("dependencies");
        args.add("--write-locks");
        try {
            this.run(this.getExecutableName(), args, null, file.getParentFile());
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return new File(file.getParentFile(), "gradle.lockfile").isFile();
    }

    private boolean hasLockConfigSetting(File file) {
        String searchString = "lockAllConfiguration";
        List<String> lines = null;
        try {
            lines = Files.readAllLines(Paths.get(file.toString(), new String[0]));
            for (String line : lines) {
                if (!line.contains(searchString)) continue;
                return true;
            }
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return false;
    }

    @Override
    public boolean shouldProcessDependencies() {
        return true;
    }
}

