/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.npm;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class NpmDependencyCollector
implements IDependencyCollector {
    private static final String NODE_MODULES = "node_modules";
    private static final String YARNRC = ".yarnrc";
    private static final String YARNRC_YML = ".yarnrc.yml";
    private static final String DOT_YARN = ".yarn";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String PEER_DEPENDENCIES = "peerDependencies";
    private static final String WORKSPACE_PREFIX = "workspace:";
    private static final String PACKAGE_MANAGER = "packageManager";
    private static final String YARN = "yarn";
    private File m_packageJson;
    private ILogManager m_log;

    public NpmDependencyCollector(File packageJson, ILogManager logManager) {
        this.m_packageJson = packageJson;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "NPM".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        File packageLockJson = new File(this.getWorkingDirectory(), "package-lock.json");
        File yarnLock = new File(this.getWorkingDirectory(), "yarn.lock");
        if (packageLockJson.exists()) {
            return this.getExecutableName();
        }
        if (yarnLock.exists()) {
            return this.getYarnExecutableName();
        }
        if (this.isToolInstalled() && this.isYarnInstalled()) {
            return this.isYarnUsed() ? this.getYarnExecutableName() : this.getExecutableName();
        }
        if (this.isToolInstalled()) {
            return this.getExecutableName();
        }
        if (this.isYarnInstalled()) {
            return this.getYarnExecutableName();
        }
        return this.getExecutableName();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_packageJson.getParentFile();
    }

    @Override
    public String getToolName() {
        return "NPM";
    }

    @Override
    public boolean shouldSkipToolCheck() {
        return true;
    }

    public String getYarnExecutableName() {
        return YARN;
    }

    boolean isYarnInstalled() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--version");
        try {
            return this.run(this.getYarnExecutableName(), args, null) == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void logAndPrintMessage(Message message) {
        CommonCore.getIOConsole().println(message);
        this.m_log.log(message);
    }

    @Override
    public Map<File, String> getDependencies(File stagingLocation, String uuid) throws IOException {
        Map<File, String> files = new HashMap<File, String>();
        File packageLockJson = new File(this.getWorkingDirectory(), "package-lock.json");
        if (packageLockJson.exists()) {
            return this.collectLockFile(files, packageLockJson, stagingLocation, uuid, "package-lock.json");
        }
        File yarnLock = new File(this.getWorkingDirectory(), "yarn.lock");
        if (yarnLock.exists()) {
            return this.collectLockFile(files, yarnLock, stagingLocation, uuid, "yarn.lock");
        }
        File nodeModules = new File(this.m_packageJson.getParentFile(), NODE_MODULES);
        if (this.isToolInstalled()) {
            if (this.isYarnInstalled() && this.isYarnUsed()) {
                this.m_log.log(new Message(1, Messages.getMessage("both.npm.yarn.installed", new Object[0])));
                files = this.isYarnClassic() ? this.doYarnClassicProcessing(stagingLocation, uuid) : this.doYarnBerryProcessing(stagingLocation, uuid);
            } else {
                files = this.doNpmProcessing(stagingLocation, uuid, nodeModules);
            }
        } else if (this.isYarnInstalled()) {
            files = this.isYarnClassic() ? this.doYarnClassicProcessing(stagingLocation, uuid) : this.doYarnBerryProcessing(stagingLocation, uuid);
        }
        DiscoveryCore.getThirdPartyLibTarget().inject(nodeModules.getAbsolutePath());
        return files;
    }

    private Map<File, String> doNpmProcessing(File stagingLocation, String uuid, File nodeModules) {
        ArrayList<String> args = null;
        HashMap<File, String> files = new HashMap();
        if (!nodeModules.isDirectory()) {
            args = new ArrayList<String>();
            args.add("i");
            try {
                if (this.run(args, null) != 0) {
                    this.logAndPrintMessage(new Message(1, Messages.getMessage("npm.failed", new Object[0])));
                    return files;
                }
            }
            catch (IOException e) {
                this.m_log.log((Exception)e);
            }
        }
        files = this.generateDependencyReport(stagingLocation, uuid);
        return files;
    }

    private Map<File, String> doYarnBerryProcessing(File stagingLocation, String uuid) {
        ArrayList<String> args = null;
        Map<File, String> files = new HashMap<File, String>();
        args = new ArrayList<String>();
        args.add("install");
        try {
            if (this.run(this.getYarnExecutableName(), args, null) != 0) {
                this.logAndPrintMessage(new Message(1, Messages.getMessage("yarn.failed", new Object[0])));
                return files;
            }
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        File yarnLock = new File(this.getWorkingDirectory(), "yarn.lock");
        if (yarnLock.exists()) {
            try {
                files = this.collectLockFile(files, yarnLock, stagingLocation, uuid, "yarn.lock");
            }
            catch (IOException e) {
                this.m_log.log((Exception)e);
            }
        }
        return files;
    }

    private Map<File, String> doYarnClassicProcessing(File stagingLocation, String uuid) {
        ArrayList<String> args = null;
        HashMap<File, String> files = new HashMap();
        args = new ArrayList<String>();
        args.add("install");
        try {
            if (this.run(this.getYarnExecutableName(), args, null) != 0) {
                this.logAndPrintMessage(new Message(1, Messages.getMessage("yarn.failed", new Object[0])));
                return files;
            }
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        files = this.generateDependencyReport(stagingLocation, uuid);
        return files;
    }

    private boolean isYarnUsed() {
        return new File(this.getWorkingDirectory(), YARNRC).exists() || new File(this.getWorkingDirectory(), YARNRC_YML).exists() || new File(this.getWorkingDirectory(), DOT_YARN).exists() || this.isYarnUsedInPackageJson(this.m_packageJson.getAbsolutePath());
    }

    @Override
    public boolean shouldProcessDependencies() {
        for (File parent = this.m_packageJson.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.getName().equalsIgnoreCase(NODE_MODULES) && !parent.getName().equals(DOT_YARN)) continue;
            return false;
        }
        return true;
    }

    private Map<File, String> collectLockFile(Map<File, String> files, File lockFile, File stagingLocation, String uuid, String lockFileNameConstant) throws IOException {
        if (lockFile.exists()) {
            if (!stagingLocation.isDirectory() && !stagingLocation.mkdirs()) {
                this.m_log.log(new Message(1, Messages.getMessage("staging.creation.error", new Object[0])));
                throw new IOException(Messages.getMessage("staging.creation.error", new Object[0]));
            }
            File stagingCopyName = new File(stagingLocation, uuid + "_" + lockFileNameConstant);
            try {
                this.logAndPrintMessage(new Message(1, Messages.getMessage("processing.config.start", lockFile)));
                Files.copy(lockFile.toPath(), stagingCopyName.toPath(), StandardCopyOption.REPLACE_EXISTING);
                files.put(stagingCopyName, lockFile.getAbsolutePath());
            }
            catch (IOException e) {
                this.m_log.log((Exception)e);
            }
        }
        return files;
    }

    private Map<File, String> generateDependencyReport(File stagingLocation, String uuid) {
        HashMap<File, String> files = new HashMap<File, String>();
        try {
            File outputFile = new File(stagingLocation, uuid);
            ArrayList<String> args = new ArrayList<String>();
            args.add("list");
            args.add("-a");
            args.add("--json");
            int exitCode = 0;
            if (this.isToolInstalled() && this.isYarnInstalled() && this.isYarnUsed() && this.isYarnClassic()) {
                exitCode = this.run(this.getYarnExecutableName(), args, outputFile);
            } else if (this.isToolInstalled()) {
                exitCode = this.run(args, outputFile);
            } else if (this.isYarnInstalled()) {
                exitCode = this.run(this.getYarnExecutableName(), args, outputFile);
            }
            if (outputFile.isFile()) {
                File renamedOutputFile = new File(outputFile.getAbsolutePath() + "_" + exitCode + ".json");
                outputFile.renameTo(renamedOutputFile);
                files.put(renamedOutputFile, this.m_packageJson.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.m_log.log(e);
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isYarnClassic() {
        try {
            String command = SystemUtil.isWindows() ? "cmd /c yarn --version" : "yarn --version";
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String version = reader.readLine();
                if (version != null && version.startsWith("1.")) {
                    boolean bl = true;
                    return bl;
                }
                if (version != null) {
                    boolean bl = false;
                    return bl;
                }
                this.m_log.log(new Message(2, Messages.getMessage("yarn.version.unknown", new Object[0])));
                return false;
            }
        }
        catch (Exception e) {
            this.m_log.log(e);
        }
        return false;
    }

    private boolean isYarnUsedInPackageJson(String packageJsonPath) {
        try {
            String[] sections;
            String rawContent = FileUtils.readFileToString((File)new File(packageJsonPath), (Charset)StandardCharsets.UTF_8);
            JSONObject root = new JSONObject(rawContent);
            if (root.has(PACKAGE_MANAGER) && root.getString(PACKAGE_MANAGER).toLowerCase().startsWith(YARN) || rawContent.toLowerCase().contains(YARN)) {
                return true;
            }
            for (String section : sections = new String[]{DEPENDENCIES, DEV_DEPENDENCIES, PEER_DEPENDENCIES}) {
                JSONObject deps;
                String[] keys;
                if (!root.has(section) || (keys = JSONObject.getNames((JSONObject)(deps = root.getJSONObject(section)))) == null) continue;
                for (String key : keys) {
                    String version = deps.getString(key);
                    if (!version.startsWith(WORKSPACE_PREFIX)) continue;
                    return true;
                }
            }
        }
        catch (IOException | JSONException e) {
            this.m_log.log(new Message(2, Messages.getMessage("error.parsing.package.json", this.m_packageJson.getAbsolutePath(), e.getMessage())));
        }
        return false;
    }
}

