/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.pypi;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.PythonUtils;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PipDependencyCollector
implements IDependencyCollector {
    private File m_requirementsOrSetupFile;
    private ILogManager m_log;

    public PipDependencyCollector(File requirementOrSetupFile, ILogManager logManager) {
        this.m_requirementsOrSetupFile = requirementOrSetupFile;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        if (SystemUtil.isWindows()) {
            return "Python".toLowerCase();
        }
        return "Python3".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return "Pypi".toLowerCase();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_requirementsOrSetupFile.getParentFile();
    }

    @Override
    public String getToolName() {
        return this.getExecutableName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<File, String> getDependencies(File location, String name) throws IOException {
        String pipExe;
        ArrayList<String> args = new ArrayList<String>();
        HashMap<File, String> files = null;
        String dirName = null;
        String pythonExe = this.getExecutableName();
        if (!location.isDirectory() && !location.mkdirs()) {
            this.m_log.log(new Message(1, Messages.getMessage("staging.creation.error", new Object[0])));
            throw new IOException(Messages.getMessage("staging.creation.error", new Object[0]));
        }
        File appscanDir = new File(System.getProperty("user.home"), ".appscan");
        File appscanTemp = new File(appscanDir, "temp");
        File tempProjectLoc = new File(appscanTemp, this.m_requirementsOrSetupFile.getParentFile().getName());
        File appscanVenvDir = new File(tempProjectLoc, ".AppScanvenv");
        if (SystemUtil.isWindows()) {
            pipExe = "pip";
            dirName = "Scripts";
        } else {
            pipExe = "pip3";
            dirName = "bin";
        }
        String venvPipExe = appscanVenvDir + File.separator + dirName + File.separator + pipExe;
        String venvPythonExe = appscanVenvDir + File.separator + dirName + File.separator + pythonExe;
        this.createAppScanVenvDir(tempProjectLoc, pythonExe);
        List<File> origList = Arrays.asList(this.m_requirementsOrSetupFile.getParentFile().listFiles());
        if (this.pipInstallSucceeded(venvPipExe, appscanVenvDir, tempProjectLoc)) {
            HashMap<String, String> envVariables = new HashMap<String, String>();
            String pipDepTreePath = "scripts" + File.separator + "pipdeptree" + File.separator + "src";
            File pipDepTreeLocation = new File(CommonCore.getDirectoryLocator().getProductRoot(), pipDepTreePath);
            envVariables.put("PYTHONPATH", pipDepTreeLocation.toString());
            String mainPyFile = new File(pipDepTreeLocation, File.separator + "pipdeptree" + File.separator + "__main__.py").toString();
            args.add(mainPyFile);
            args.add("--freeze");
            File outputFile = new File(location, name + "_venv.txt");
            Boolean success = this.run(venvPythonExe, args, outputFile, envVariables) == 0;
            if (!success.booleanValue() || !outputFile.isFile()) throw new IOException(Messages.getMessage("pip.file.process.failed", this.m_requirementsOrSetupFile));
            files = new HashMap<File, String>();
            files.put(outputFile, this.m_requirementsOrSetupFile.getAbsolutePath());
        } else {
            String command = null;
            command = PythonUtils.isRequirementsTxtFile(this.m_requirementsOrSetupFile, this.getWorkingDirectory()) ? "install -r" : "install .";
            this.m_log.log(new Message(1, Messages.getMessage("pip.install.failed", pipExe, command, this.m_requirementsOrSetupFile)));
        }
        PythonUtils.cleanUpPipDirectory(this.m_requirementsOrSetupFile.getParentFile(), origList, this.m_log);
        ThirdPartyLibUtils.deleteDir(tempProjectLoc);
        return files;
    }

    @Override
    public boolean shouldProcessDependencies() {
        if (PythonUtils.pyprojectTomlFileExists(this.getWorkingDirectory())) {
            return false;
        }
        if (PythonUtils.isRequirementsTxtFile(this.m_requirementsOrSetupFile, this.getWorkingDirectory())) {
            return true;
        }
        return !PythonUtils.requirementsTxtFileExists(this.getWorkingDirectory());
    }

    private void createAppScanVenvDir(File tempDir, String pythonExe) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-m");
        args.add("venv");
        args.add(".AppScanvenv");
        if (!tempDir.isDirectory()) {
            tempDir.mkdirs();
        }
        if (this.run(pythonExe, args, null, tempDir) != 0) {
            throw new IOException(Messages.getMessage("python.venv.failed", tempDir, this.getExecutableName(), "3.8"));
        }
    }

    private boolean pipInstallSucceeded(String exe, File appscanVenvDir, File tempProjectLoc) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("install");
        if (PythonUtils.isRequirementsTxtFile(this.m_requirementsOrSetupFile, this.getWorkingDirectory())) {
            args.add("-r");
            args.add("requirements.txt");
        } else {
            args.add(".");
        }
        try {
            return this.run(exe, args, null) == 0;
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
            throw new IOException(e);
        }
    }
}

