/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.utils;

import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcessUtils {
    public static int run(String exe, List<String> args) throws IOException {
        return ProcessUtils.run(exe, args, null, null, null);
    }

    public static int run(String exe, List<String> args, File workingDirectory) throws IOException {
        return ProcessUtils.run(exe, args, workingDirectory, null, null);
    }

    public static int run(String exe, List<String> args, File workingDirectory, File outputFile) throws IOException {
        return ProcessUtils.run(exe, args, workingDirectory, outputFile, null);
    }

    public static int run(String exe, List<String> args, File workingDirectory, File outputFile, Map<String, String> variables) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        if (SystemUtil.isWindows()) {
            command.add("cmd");
            command.add("/c");
        } else {
            command.add("/bin/sh");
            command.add("-c");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(exe);
        for (String arg : args) {
            buffer.append(" ").append(arg);
        }
        command.add(buffer.toString());
        ProcessRunner runner = new ProcessRunner(command);
        if (workingDirectory != null) {
            runner.setDirectory(workingDirectory);
        }
        if (variables != null) {
            runner.environment().putAll(variables);
        }
        if (outputFile != null) {
            outputFile.delete();
            outputFile.getParentFile().mkdirs();
            runner.setRedirectOutput(outputFile);
        }
        return runner.run(null);
    }
}

