/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.utils;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonUtils {
    private static final String REGEX = "^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$";

    public static String getPythonVersion() {
        Process proc;
        String command = null;
        String version = null;
        command = SystemUtil.isWindows() ? "cmd /c python --version" : "python3 --version";
        Runtime rt = Runtime.getRuntime();
        try {
            proc = rt.exec(command.toString());
        }
        catch (IOException e) {
            return version;
        }
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        try {
            version = stdInput.readLine();
            if (version == null) {
                version = stdError.readLine();
            }
            if (version != null) {
                version = version.toLowerCase().replace("python ", "");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    public static boolean isPythonVersionSupported() {
        Pattern pattern = Pattern.compile(REGEX, 2);
        int supportedMajorVer = Integer.parseInt("3");
        int supportedMinorVer = Integer.parseInt("8");
        String version = PythonUtils.getPythonVersion();
        if (version != null) {
            try {
                Matcher matcher = pattern.matcher(version);
                if (matcher.matches()) {
                    int major = Integer.parseInt(matcher.group(1).substring(0, matcher.group(1).length() - 1));
                    int minor = 0;
                    minor = matcher.group(2).endsWith(".") ? Integer.parseInt(matcher.group(2).substring(0, matcher.group(2).length() - 1)) : Integer.parseInt(matcher.group(2));
                    return major > supportedMajorVer || major == supportedMajorVer && minor >= supportedMinorVer;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void cleanUpPipDirectory(File dir, List<File> origFilesList, ILogManager logger) {
        List<File> currentFilesList = Arrays.asList(dir.listFiles());
        currentFilesList.forEach(file -> {
            if (!origFilesList.contains(file)) {
                if (file.isDirectory()) {
                    ThirdPartyLibUtils.deleteDir(file);
                    logger.log(new Message(1, Messages.getMessage("delete.pip.temp.dir", file)));
                } else {
                    file.delete();
                    logger.log(new Message(1, Messages.getMessage("delete.pip.temp.file", file)));
                }
            }
        });
    }

    public static boolean isTomlFile(File currentFile, File workingDirectory) {
        File tomlFile = new File(workingDirectory, "pyproject.toml");
        return currentFile.equals(tomlFile);
    }

    public static boolean isRequirementsTxtFile(File currentFile, File workingDirectory) {
        File requirementsTxtFile = new File(workingDirectory, "requirements.txt");
        return currentFile.equals(requirementsTxtFile);
    }

    public static boolean isSetupPyFile(File currentFile, File workingDirectory) {
        File setupPyFile = new File(workingDirectory, "setup.py");
        return currentFile.equals(setupPyFile);
    }

    public static boolean pyprojectTomlFileExists(File workingDirectory) {
        File pyprojectTomlFile = new File(workingDirectory, "pyproject.toml");
        return pyprojectTomlFile.exists();
    }

    public static boolean requirementsTxtFileExists(File workingDirectory) {
        File requirementsTxtFile = new File(workingDirectory, "requirements.txt");
        return requirementsTxtFile.exists();
    }

    public static boolean setupPyFileExists(File workingDirectory) {
        File setupPyFile = new File(workingDirectory, "setup.py");
        return setupPyFile.exists();
    }
}

