/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.thirdpartylib;

import com.hcl.appscan.discovery.containers.docker.DockerHandlerFactory;
import com.hcl.appscan.discovery.containers.utils.ContainerUtils;
import com.hcl.appscan.discovery.containers.utils.ProgressReporter;
import com.hcl.appscan.discovery.containers.utils.TarUtils;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.error.IErrorManager;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfoManager;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.IScanTargetCollector;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.StringUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.DependencyCollectorFactory;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import com.ibm.appscan.discovery.util.ThirdPartyDirUtil;
import com.ibm.appscan.internal.discovery.thirdpartylib.ScanFilesMap;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class ThirdPartyLibScanTarget
implements IScanTarget {
    protected ScanFilesMap m_scanFiles = new ScanFilesMap();
    public static ThirdPartyLibScanTarget instance = new ThirdPartyLibScanTarget();
    private Set<String> m_configFilesToProcess = new TreeSet<String>();
    private ITransformable.State m_state = ITransformable.State.CONFIGURED;
    private IScan m_scan = null;
    private ILogManager m_log;
    private boolean m_foundThirdPartyLibs = false;
    private boolean m_isValid = false;
    private File m_stagingDirectory;

    public String getName() {
        return "ThirdPartyLib";
    }

    private boolean processFile(File file) {
        if (ThirdPartyLibUtils.isSupportedExtension(file.getName().toLowerCase())) {
            try {
                String checksum = SystemUtil.calculateSHA1((File)file);
                IScanFile scanFile = ScanModelFactory.newScanFile((File)file, (String)checksum);
                this.setSourcePath(scanFile);
                this.m_scanFiles.put(checksum, scanFile);
                return true;
            }
            catch (IOException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean add(String path) {
        File file = new File(path);
        boolean foundThirdPartyLib = false;
        if (file.isFile() && !SystemUtil.isStaticAnalysisOnly()) {
            foundThirdPartyLib = this.processFile(file);
            if (ThirdPartyLibUtils.isSupportedConfigFile(file) && !this.isWorkingDirectoryPath(file)) {
                this.addConfigFile(file);
                foundThirdPartyLib = true;
            }
            if (ThirdPartyLibUtils.isZipCompressionExtension(file.getName().toLowerCase())) {
                this.m_foundThirdPartyLibs = false;
                this.readZipFile(file, file.getName());
                foundThirdPartyLib = this.m_foundThirdPartyLibs || foundThirdPartyLib;
            } else if (SystemUtil.isOpenSourceOnly() && (ContainerUtils.isImageArchive((File)file) || ContainerUtils.isContainerArchive((File)file))) {
                if (ContainerUtils.isDockerInstalled()) {
                    this.readDockerArchive(file);
                    foundThirdPartyLib = this.m_foundThirdPartyLibs || foundThirdPartyLib;
                } else {
                    Message message = new Message(1, Messages.getMessage("no.docker.found", file.getName()));
                    this.m_log.log(message);
                    CommonCore.getIOConsole().print(message);
                }
            }
        }
        return foundThirdPartyLib;
    }

    public boolean isWorkingDirectoryPath(File file) {
        SaveLocation location = this.m_scan.getSaveLocation();
        return location != null && PathUtil.isParent((File)location.getWorkLocation(), (File)file);
    }

    public void inject(String path) {
        File dir = new File(path);
        if (dir.isDirectory() && ThirdPartyDirUtil.isThirdPartyDir((File)dir)) {
            this.processAllFilesInDir(dir.listFiles());
        } else {
            this.add(path);
        }
    }

    private void processAllFilesInDir(File[] files) {
        for (File file : files) {
            if (file.isDirectory()) {
                this.processAllFilesInDir(file.listFiles());
                continue;
            }
            this.processFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readZipFile(File target, final String replaceString) {
        String tempDir = System.getProperty("IRX_LOCATION");
        if (tempDir == null) {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        File tempFile = new File(tempDir);
        String name = StringUtil.shortenString((String)this.getName(), (int)5, (String)"");
        File stagingDirectory = new File(tempFile, '_' + name + target.hashCode() + File.separatorChar + "d");
        int attempts = 0;
        while (stagingDirectory.getParentFile().exists()) {
            stagingDirectory = new File(tempFile, '_' + name + target.hashCode() + "_" + attempts++ + File.separatorChar + "d");
            if (attempts <= 50) continue;
            return false;
        }
        File parent = stagingDirectory.getParentFile();
        parent.mkdirs();
        try {
            for (Message message : ArchiveUtil.unzip((File)target, (File)stagingDirectory, (String[])new String[0])) {
                this.m_log.log(message);
            }
        }
        catch (AppScanException | IOException e) {
            this.m_log.log((Exception)e);
            return false;
        }
        try {
            DirectoryUtil.walk((File)stagingDirectory, (DirectoryUtil.TreeVisitor)new DirectoryUtil.TreeVisitor(){

                protected boolean preVisitDirectory(File directory) throws IOException {
                    return true;
                }

                protected boolean visitFile(File file) throws IOException {
                    if (ThirdPartyLibUtils.isSupportedExtension(file.getName().toLowerCase())) {
                        File f;
                        String fileName = file.getName();
                        for (f = file.getParentFile(); f != null && !"d".equals(f.getName()); f = f.getParentFile()) {
                            fileName = f.getName() + File.separatorChar + fileName;
                        }
                        if (f == null) {
                            ThirdPartyLibScanTarget.this.m_log.log(new Message(0, "Could not get relative path:" + file.getPath()));
                            return false;
                        }
                        try {
                            String checksum = SystemUtil.calculateSHA1((File)file);
                            IScanFile scanFile = ScanModelFactory.newScanFile((File)new File(replaceString + File.separator + fileName), (String)checksum);
                            scanFile.setSourcePath(scanFile.getAnalysisPath());
                            ThirdPartyLibScanTarget.this.m_scanFiles.put(checksum, scanFile);
                            ThirdPartyLibScanTarget.this.m_foundThirdPartyLibs = true;
                        }
                        catch (IOException | NoSuchAlgorithmException exception) {
                            // empty catch block
                        }
                    }
                    if (ThirdPartyLibUtils.isZipCompressionExtension(file.getName().toLowerCase())) {
                        ThirdPartyLibScanTarget.this.readZipFile(file, replaceString + File.separator + file.getName());
                    }
                    return true;
                }
            });
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        finally {
            try {
                DirectoryUtil.delete((File)stagingDirectory.getParentFile());
            }
            catch (IOException e) {
                this.m_log.log((Exception)e);
            }
        }
        return true;
    }

    private void readDockerArchive(File archive) {
        try {
            ProgressReporter progress = new ProgressReporter(this.m_scan);
            progress.setStatus(new Message(1, Messages.getMessage("reading.docker.archive", archive.getAbsolutePath())));
            File containerArchive = DockerHandlerFactory.getHandler((String)archive.getAbsolutePath(), (IProgress)progress).getContainerArchive();
            progress.setStatus(new Message(1, Messages.getMessage("processing.container.start", new Object[0])));
            Map checksums = TarUtils.getSHAValuesFromArchive((File)containerArchive);
            for (String checksum : checksums.keySet()) {
                File file = (File)checksums.get(checksum);
                if (!ThirdPartyLibUtils.isSupportedExtension(file.getName().toLowerCase())) continue;
                IScanFile scanFile = ScanModelFactory.newScanFile((File)file, (String)checksum);
                scanFile.setSourcePath(file.getPath());
                this.m_scanFiles.put(checksum, scanFile);
                this.m_foundThirdPartyLibs = true;
            }
            progress.setStatus(new Message(1, Messages.getMessage("processing.container.end", new Object[0])));
        }
        catch (AppScanException | IOException e) {
            this.m_log.log((Exception)e);
        }
    }

    public boolean add(Set<IScanFile> scanFiles) {
        boolean foundThirdPartyLib = false;
        if (!SystemUtil.isStaticAnalysisOnly()) {
            for (IScanFile scanFile : scanFiles) {
                if (!scanFile.getFile().isFile() || !ThirdPartyLibUtils.isSupportedExtension(scanFile.getFile().getName().toLowerCase())) continue;
                this.setSourcePath(scanFile);
                this.m_scanFiles.put(scanFile.getChecksum(), scanFile);
                foundThirdPartyLib = true;
            }
        }
        return foundThirdPartyLib;
    }

    public void addConfigFile(File file) {
        if (!SystemUtil.isStaticAnalysisOnly()) {
            this.m_configFilesToProcess.add(file.getAbsolutePath());
        }
    }

    public String getType() {
        return "thirdpartylib";
    }

    public String getPath() {
        return this.getName();
    }

    public String getStrategyClass() {
        return this.getClass().getName();
    }

    public String getLanguageType() {
        return "thirdpartylib";
    }

    public void setTransformed(boolean transform) {
        if (transform) {
            this.m_state = ITransformable.State.TRANSFORMED;
        } else if (this.m_state == ITransformable.State.TRANSFORMED) {
            this.m_state = ITransformable.State.CONFIGURED;
        }
    }

    public ITransformable.State getState() {
        return this.m_state;
    }

    public void accept(ScanModelVisitor visitor) {
        visitor.internalVisit((IScanTarget)this);
        visitor.internalPostVisit((IScanTarget)this);
    }

    public IScan getScan() {
        return this.m_scan;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public void setIsDirectoryTarget(boolean isDirectoryTarget) {
    }

    public boolean isDirectoryTarget() {
        return false;
    }

    public void setWorkingDirectoryName(String name) {
    }

    public String getWorkingDirectoryName() {
        return this.getName();
    }

    public boolean isExcluded() {
        return false;
    }

    public IScanTarget getParent() {
        return null;
    }

    public Collection<IScanTarget> getChildren() {
        return null;
    }

    public Collection<IScanTarget> getIncludedAndExcludedChildren() {
        return null;
    }

    public boolean findScanTargets(IScanTargetCollector collector, IProgress progress) {
        return true;
    }

    public void findScanFiles(IProgress progress) {
        this.processConfigFiles();
        this.m_isValid = true;
    }

    public Collection<IScanFile> getScanFiles() {
        HashSet<IScanFile> scanFilesSet = new HashSet<IScanFile>();
        for (Set scanFiles : this.m_scanFiles.values()) {
            scanFilesSet.addAll(scanFiles);
        }
        return scanFilesSet;
    }

    public IBuildInfoManager getBuildInfoManager() {
        return null;
    }

    public void dispose(IProgress progress) {
    }

    public void setScan(IScan scan) {
        if (this.m_scan != scan) {
            this.m_scan = scan;
            this.m_scanFiles.clear();
            this.m_configFilesToProcess.clear();
            this.m_stagingDirectory = null;
            this.m_isValid = false;
        }
        this.m_state = ITransformable.State.CONFIGURED;
        this.m_log = scan.getLogManager();
    }

    public synchronized File getStagingDirectory(boolean create) {
        SaveLocation location;
        if (this.m_stagingDirectory == null && (location = this.getScan().getSaveLocation()) != null) {
            File workingDirectory = new File(location.getWorkLocation(), this.getWorkingDirectoryName());
            this.m_stagingDirectory = new File(workingDirectory, "staging");
            if (!this.m_stagingDirectory.isDirectory()) {
                this.m_stagingDirectory.mkdirs();
            }
        }
        return this.m_stagingDirectory;
    }

    public synchronized File getStagingDirectory(boolean create, String dir) {
        return this.getStagingDirectory(create);
    }

    public IErrorManager getErrorManager() {
        return null;
    }

    public ScanTargetStrategy getStrategy() {
        return null;
    }

    public Collection<IValidationIssue> getValidationIssues() {
        return Collections.emptyList();
    }

    public Collection<String> getNameSpaces() {
        return Collections.emptySet();
    }

    private void processConfigFiles() {
        for (String configFile : this.m_configFilesToProcess) {
            File file = new File(configFile);
            try {
                IDependencyCollector collector = DependencyCollectorFactory.getDependencyCollector(file, this.m_log);
                if (collector == null) {
                    this.logAndPrintMessage(new Message(2, Messages.getMessage("unsupported.config.file", file.getAbsolutePath())));
                    continue;
                }
                if (System.getProperty("NO_CONFIG_FILES") != null || !collector.shouldProcessDependencies()) continue;
                if (!collector.isToolInstalled() && !collector.shouldSkipToolCheck()) {
                    this.logAndPrintMessage(new Message(1, Messages.getMessage("no.tool.found", file, collector.getToolName())));
                    continue;
                }
                if (SystemUtil.isDryRun()) {
                    IScanFile scanFile = ScanModelFactory.newScanFile((String)configFile);
                    this.m_scanFiles.put(SystemUtil.calculateSHA1((String)configFile), scanFile);
                    continue;
                }
                this.logAndPrintMessage(new Message(1, Messages.getMessage("processing.config.start", file)));
                String directoryName = collector.getStagingDirectoryName().toLowerCase();
                File stageLocation = new File(this.getStagingDirectory(true), directoryName);
                Map<File, String> dependencyFiles = collector.getDependencies(stageLocation, UUID.randomUUID().toString());
                if (dependencyFiles != null) {
                    for (File dependenciesFile : dependencyFiles.keySet()) {
                        IScanFile scanFile = ScanModelFactory.newScanFile((File)dependenciesFile);
                        scanFile.setSourcePath(dependencyFiles.get(dependenciesFile));
                        this.setSourcePath(scanFile);
                        this.m_scanFiles.put(SystemUtil.calculateSHA1((File)dependenciesFile), scanFile);
                    }
                }
                IScanFile configFileScan = ScanModelFactory.newScanFile((File)file, (String)SystemUtil.calculateSHA1((File)file));
                configFileScan.setSourcePath(file.getPath());
                this.setSourcePath(configFileScan);
                this.m_scanFiles.put(configFileScan.getChecksum(), configFileScan);
                this.logAndPrintMessage(new Message(1, Messages.getMessage("processing.config.end", new Object[0])));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.logAndPrintMessage(new Message(4, Messages.getMessage("processing.config.failed", configFile, e.getMessage())));
            }
        }
    }

    private void logAndPrintMessage(Message message) {
        CommonCore.getIOConsole().println(message);
        this.m_log.log(message);
    }

    private void setSourcePath(IScanFile scanFile) {
        String sourcePath = scanFile.getSourcePath();
        if (sourcePath != null && !new File(sourcePath).isAbsolute()) {
            return;
        }
        sourcePath = sourcePath == null ? scanFile.getAnalysisPath() : sourcePath;
        scanFile.setSourcePath(sourcePath);
        if (!sourcePath.equals(scanFile.getSourcePath())) {
            return;
        }
        File root = this.getScan().getSaveLocation() == null ? new File(System.getProperty("user.dir")) : this.getScan().getSaveLocation().getWorkLocation().getParentFile();
        sourcePath = PathUtil.makeRelative((File)root, (File)root, (String)sourcePath);
        scanFile.setSourcePath(sourcePath);
    }
}

