/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.specinfo;

import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.util.VDBChecks;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FrameworkInfoImpl
implements IFrameworkInfo {
    private final Set<ISyntheticMethod> syntheticMethods;
    private final Set<BeanDecl> globalBeanDeclarations;
    private final Map<String, Set<String>> entrypointSignatureToURL;
    private final Map<String, Set<CallSiteReplacement>> methodToReplacements;

    public FrameworkInfoImpl(Set<ISyntheticMethod> syntheticMethods, Set<BeanDecl> globalBeanDeclarations, Map<String, Set<String>> entrypointSignatureToURL, Map<String, Set<CallSiteReplacement>> methodToReplacements) {
        if (syntheticMethods == null) {
            throw new IllegalArgumentException("syntheticMethods is null");
        }
        if (globalBeanDeclarations == null) {
            throw new IllegalArgumentException("globalBeanDeclarations is null");
        }
        if (entrypointSignatureToURL == null) {
            throw new IllegalArgumentException("entrypointSignatureToURL is null");
        }
        if (methodToReplacements == null) {
            throw new IllegalArgumentException("methodToReplacements is null");
        }
        this.checkEntrypointSigsInVDB(entrypointSignatureToURL);
        this.syntheticMethods = new TreeSet<ISyntheticMethod>(new Comparator<ISyntheticMethod>(){

            @Override
            public int compare(ISyntheticMethod object1, ISyntheticMethod object2) {
                return object1.getSignature().compareTo(object2.getSignature());
            }
        });
        this.syntheticMethods.addAll(syntheticMethods);
        this.globalBeanDeclarations = new TreeSet<BeanDecl>(new Comparator<BeanDecl>(){

            @Override
            public int compare(BeanDecl o1, BeanDecl o2) {
                return o1.getId().toString().compareTo(o2.getId().toString());
            }
        });
        this.globalBeanDeclarations.addAll(globalBeanDeclarations);
        this.entrypointSignatureToURL = new TreeMap<String, Set<String>>(entrypointSignatureToURL);
        this.methodToReplacements = new TreeMap<String, Set<CallSiteReplacement>>();
        if (methodToReplacements != null && !methodToReplacements.isEmpty()) {
            for (Map.Entry<String, Set<CallSiteReplacement>> E : methodToReplacements.entrySet()) {
                String key = E.getKey();
                if (key == null) continue;
                this.methodToReplacements.put(key, E.getValue());
            }
        }
    }

    private void checkEntrypointSigsInVDB(Map<String, Set<String>> entrypointSignatureToURL) {
        for (String entrypoint : entrypointSignatureToURL.keySet()) {
            if (VDBChecks.isValidVDBSignature(entrypoint)) continue;
            throw new IllegalArgumentException("entrypoint signature " + entrypoint + " not in VDB format");
        }
    }

    @Override
    public Map<String, Set<String>> getEntrypointSignatureToURLMappings() {
        return this.entrypointSignatureToURL;
    }

    @Override
    public Map<String, Set<CallSiteReplacement>> getMethodToReplacementsMapping() {
        return this.methodToReplacements;
    }

    @Override
    public Set<ISyntheticMethod> getSyntheticMethods() {
        return this.syntheticMethods;
    }

    @Override
    public Set<BeanDecl> getGlobalBeanDeclarations() {
        return this.globalBeanDeclarations;
    }

    public static IFrameworkInfo makeEmpty() {
        return new FrameworkInfoImpl(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }
}

