/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

public class FilePositionInfo {
    private final String filename;
    private final int lineNumber;
    private final int columnNumber;

    public static FilePositionInfo make(String filename, int lineNumber, int columnNumber) {
        return new FilePositionInfo(filename, lineNumber, columnNumber);
    }

    private FilePositionInfo(String filename, int lineNumber, int columnNumber) {
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnNumber;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.lineNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilePositionInfo other = (FilePositionInfo)obj;
        if (this.columnNumber != other.columnNumber) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return this.lineNumber == other.lineNumber;
    }

    public String toString() {
        return "FilePositionInfo [columnNumber=" + this.columnNumber + ", filename=" + this.filename + ", lineNumber=" + this.lineNumber + "]";
    }
}

