/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.client;

import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.samso.client.M2LStringAnalyzer;
import com.ibm.wala.samso.modular.M2LModularCG2Grammar;
import com.ibm.wala.samso.modular.M2LModularConstraintEncoder;
import com.ibm.wala.samso.modular.ModuleUtil;
import com.ibm.wala.samso.modular.SignatureBasedDFAFileFinder;
import com.ibm.wala.samso.solver.parser.IDFAFileFinder;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.SolverContext;
import com.ibm.wala.samso.translator.repository.IM2LTranslatorRepository;
import com.ibm.wala.samso.translator.repository.M2LTranslator;
import com.ibm.wala.samso.translator.repository.M2LTranslatorRepository;
import com.ibm.wala.stringAnalysis.grammar.IValueNumberInNode;
import com.ibm.wala.stringAnalysis.translator.ICG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class M2LModularStringAnalyzer
extends M2LStringAnalyzer {
    private ModuleUtil mutil;

    public M2LModularStringAnalyzer(CallGraph cg, PointerAnalysis pa, IClassHierarchy cha, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        super(cg, pa, cha, monitor, logger);
    }

    protected IDFAFileFinder createDFAFileFinder() {
        SignatureBasedDFAFileFinder finder = new SignatureBasedDFAFileFinder();
        finder.setDefaultPrefix("C:/tmp/");
        return finder;
    }

    public ModuleUtil getModuleUtil() {
        if (this.mutil == null) {
            ISolverCache cache = this.createSolverCache(this.getVariableFactory());
            ISolverStack stack = this.createSolverStack();
            M2LTranslatorRepository repo = (M2LTranslatorRepository)this.getRepository();
            this.mutil = new ModuleUtil(this, this.createDFAFileFinder(), this.monitor);
            M2LModularConstraintEncoder encoder = new M2LModularConstraintEncoder(repo, (ISolverCache<IDeclarationSet>)cache, stack, SolverContext.STRING, this.mutil, this.monitor);
            this.mutil.setEncoder(encoder);
        }
        return this.mutil;
    }

    @Override
    protected ICG2Grammar<IDeclarationSet> createCG2GR(IIR2Grammar<IDeclarationSet> ir2gr) {
        return new M2LModularCG2Grammar(ir2gr, this.getModuleUtil(), this.monitor, this.logger);
    }

    @Override
    protected IConstraintSolver<IDeclarationSet> createSolver(ITranslatorRepository<IDeclarationSet> repository, ISolverCache<IDeclarationSet> cache, ISolverStack stack, IVariableFactory<IVariable> varFactory) {
        IM2LTranslatorRepository repo = (IM2LTranslatorRepository)repository;
        M2LModularConstraintEncoder encoder = new M2LModularConstraintEncoder(repo, cache, stack, SolverContext.STRING, this.getModuleUtil(), this.monitor);
        return encoder;
    }

    public static void storeResult(ModuleUtil mutil, Map<IVariable, IDeclarationSet> r) {
        for (IVariable v : r.keySet()) {
            if (!(v instanceof IValueNumberInNode)) continue;
            IValueNumberInNode cdv = (IValueNumberInNode)v;
            IDeclarationSet declSet = r.get(v);
            File f = mutil.getDFAFileFinder().newFile(cdv.getCGNode().getMethod().getSignature() + "_" + v);
            try {
                PrintStream out = new PrintStream(new FileOutputStream(f.getAbsolutePath() + ".sc"));
                out.println(declSet.toString());
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Map<IVariable, IDeclarationSet> infer(Collection<? extends IVariable> vars) {
        M2LTranslator.PA = this.getPointerAnalysis();
        Map<IVariable, IDeclarationSet> r = super.infer(vars);
        if (SAUtil.DEBUG) {
            M2LModularStringAnalyzer.storeResult(this.mutil, r);
        }
        M2LTranslator.PA = null;
        return r;
    }
}

