/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.modular;

import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.samso.client.IM2LStringAnalyzer;
import com.ibm.wala.samso.m2lstr.DeclarationSet;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.modular.M2LModularConstraintEncoder;
import com.ibm.wala.samso.modular.StringConstraintDeclaration;
import com.ibm.wala.samso.solver.StringConstraintSolver;
import com.ibm.wala.samso.solver.parser.IDFAFileFinder;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.repository.IM2LTranslatorRepository;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.ReturnVariable;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class ModuleUtil {
    private static final boolean forceCompile = Boolean.parseBoolean(System.getProperty("samso.forceCompile", "false"));
    private final Map<String, IRInfo> irInfo;
    private final Map<IVariable, IPredicate> pmap;
    private final Set<IVariable> inputVariables;
    private final Set<IVariable> outputVariables;
    private final MonitorUtil.IProgressMonitor monitor;
    private final IDFAFileFinder dfaFinder;
    private final IM2LStringAnalyzer analyzer;
    private M2LModularConstraintEncoder encoder;
    private List<String> compilationUnits = new LinkedList<String>();

    public ModuleUtil(IM2LStringAnalyzer analyzer, IDFAFileFinder dfaFinder, MonitorUtil.IProgressMonitor monitor) {
        this.irInfo = new HashMap<String, IRInfo>();
        this.inputVariables = new HashSet<IVariable>();
        this.outputVariables = new HashSet<IVariable>();
        this.pmap = new HashMap<IVariable, IPredicate>();
        this.monitor = monitor;
        this.dfaFinder = dfaFinder;
        this.analyzer = analyzer;
    }

    public void setEncoder(M2LModularConstraintEncoder encoder) {
        this.encoder = encoder;
    }

    public IDFAFileFinder getDFAFileFinder() {
        return this.dfaFinder;
    }

    protected boolean isStringish(String typeName) {
        return this.analyzer.getRepository().isStringClass(typeName) || "C".equals(typeName);
    }

    public void registerIRInfo(IR ir, List<IVariable> ivars, List<TypeName> itypes, List<IVariable> ovars, List<TypeName> otypes) {
        IRInfo info = new IRInfo(ivars, itypes, ovars, otypes);
        this.irInfo.put(ir.getMethod().getSignature(), info);
        this.inputVariables.addAll(ivars);
        this.outputVariables.addAll(ovars);
        this.registerInputVariables(this.inputVariables);
        this.registerOutputVariables(this.outputVariables);
    }

    public IRInfo getIRInfo(String signature) {
        return this.irInfo.get(signature);
    }

    private IM2LTranslatorRepository getRepository() {
        return (IM2LTranslatorRepository)this.analyzer.getRepository();
    }

    private IExtendedFormulaFactory getFormulaFactory() {
        return this.getRepository().getFormulaFactory();
    }

    private void registerPredicateFor(IVariable v) {
        IPredicate p = this.getFormulaFactory().createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        this.pmap.put(v, p);
    }

    private void registerPredicatesFor(Collection<IVariable> vars) {
        for (IVariable var : vars) {
            this.registerPredicateFor(var);
        }
    }

    private void registerInputVariables(Collection<IVariable> vars) {
        this.inputVariables.addAll(vars);
        this.registerPredicatesFor(vars);
    }

    private void registerOutputVariables(Collection<IVariable> vars) {
        this.outputVariables.addAll(vars);
        this.registerPredicatesFor(vars);
    }

    public IPredicate getPredicate(IVariable v) {
        return this.pmap.get(v);
    }

    public Set<IVariable> getInputVariables() {
        return this.inputVariables;
    }

    public Set<IVariable> getOutputVariables() {
        return this.outputVariables;
    }

    public int[] getStringOutputValueNumbers(IR ir) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (this.isStringOutput(ir.getMethod().getReference())) {
            Iterator iter = ir.iterateAllInstructions();
            while (iter.hasNext()) {
                SSAInstruction inst = (SSAInstruction)iter.next();
                if (!(inst instanceof SSAReturnInstruction)) continue;
                SSAReturnInstruction r = (SSAReturnInstruction)inst;
                l.add(r.getUse(0));
            }
        }
        int[] ret = new int[l.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)l.get(i);
        }
        return ret;
    }

    public List<Pair<Integer, TypeReference>> getStringInputValueNumbersWithTypes(IR ir) {
        IMethod m = ir.getMethod();
        int[] idx = this.getStringInput(m.getReference(), m.isStatic());
        ArrayList<Pair<Integer, TypeReference>> params = new ArrayList<Pair<Integer, TypeReference>>();
        for (int i : idx) {
            int vn = ir.getParameter(i);
            TypeReference ty = ir.getParameterType(i);
            params.add((Pair<Integer, TypeReference>)Pair.make((Object)vn, (Object)ty));
        }
        return params;
    }

    public int[] getStringInputValueNumbers(IR ir) {
        IMethod m = ir.getMethod();
        int[] idx = this.getStringInput(m.getReference(), m.isStatic());
        int[] params = new int[idx.length];
        int n = 0;
        for (int i : idx) {
            params[n] = ir.getParameter(i);
            ++n;
        }
        return params;
    }

    public boolean isStringOutput(MethodReference mref) {
        TypeReference ret = mref.getReturnType();
        return this.isStringish(ret.getName().toString());
    }

    public int[] getStringInput(MethodReference mref, boolean isStatic) {
        int i;
        int[] idx = new int[mref.getNumberOfParameters()];
        int n = 0;
        for (i = 0; i < idx.length; ++i) {
            TypeReference ty = mref.getParameterType(i);
            if (!this.isStringish(ty.getName().toString())) continue;
            idx[i] = n++;
        }
        idx = n == 0 ? new int[]{} : Arrays.copyOf(idx, n);
        if (!isStatic) {
            for (i = 0; i < idx.length; ++i) {
                idx[i] = idx[i] + 1;
            }
        }
        return idx;
    }

    public boolean isModuleEntry(MethodReference mref) {
        return this.isStringOutput(mref);
    }

    public void addCompilationUnit(String signature) {
        for (CGNode node : this.analyzer.getCallGraph()) {
            String s = node.getMethod().getSignature();
            if (!signature.equals(s)) continue;
            this.addCompilationUnit(node);
        }
    }

    public File getDFAFile(String signature) {
        return this.dfaFinder.newFile(signature);
    }

    protected void addCompilationUnit(CGNode node) {
        SortedSet sorted = DFS.sortByDepthFirstOrder((Graph)this.analyzer.getCallGraph(), (Object)node);
        for (CGNode succ : sorted) {
            ClassLoaderReference loader = succ.getMethod().getDeclaringClass().getClassLoader().getReference();
            if (this.analyzer.getRepository().isBuiltin(succ, loader) || !this.isModuleEntry(succ.getMethod().getReference())) continue;
            String sig = succ.getMethod().getSignature();
            this.compilationUnits.add(sig);
        }
    }

    public void compile() throws FileNotFoundException {
        while (!this.compilationUnits.isEmpty()) {
            String sig = this.compilationUnits.get(0);
            this.compilationUnits.remove(0);
            this.compile(sig);
        }
    }

    public void compile(String signature) throws FileNotFoundException {
        SAUtil.println((Object)("compiling " + signature + "..."));
        File file = this.dfaFinder.newFile(signature);
        if (!forceCompile && file.exists()) {
            SAUtil.println((Object)"already compiled.");
            return;
        }
        Collection ovars = SAUtil.findReturnVariables((GR)this.analyzer.getGR(), (CallGraph)this.analyzer.getCallGraph(), Collections.singleton(signature));
        HashMap<ReturnVariable, IDeclarationSet> declSets = new HashMap<ReturnVariable, IDeclarationSet>();
        SimpleGrammar g = this.analyzer.getGR().toSimple();
        g = g.dup();
        Grammars.eliminateUselessRules((IGrammar)g, (Collection)ovars);
        this.encoder.fixDanglingRules(g, ovars);
        for (ReturnVariable v : ovars) {
            declSets.put(v, this.encoder.solve(g, (IVariable)v));
        }
        IDeclarationSet declSet = DeclarationSets.createUnion(declSets.values(), this.getFormulaFactory());
        DeclarationSet declSet2 = new DeclarationSet(declSet.getTarget());
        List<IVariable> ivars = this.getIRInfo((String)signature).inputVariables;
        for (IVariable iVariable : ivars) {
            IPredicate pred = this.getPredicate(iVariable);
            declSet2.add(new StringConstraintDeclaration("input svar " + pred));
        }
        declSet2.addAll(declSet);
        declSet2.add(new StringConstraintDeclaration("output svar " + declSet.getTarget()));
        PrintStream src = new PrintStream(new FileOutputStream(file.toString() + ".sc"));
        for (IDeclaration decl : declSet2) {
            src.println(decl + ";");
        }
        StringConstraintSolver stringConstraintSolver = new StringConstraintSolver(this.getFormulaFactory(), this.monitor);
        stringConstraintSolver.read(declSet2);
        PrintStream out = new PrintStream(new FileOutputStream(file));
        stringConstraintSolver.generateDFA(out);
        SAUtil.println((Object)"done.");
    }

    public static class IRInfo {
        public final List<IVariable> inputVariables;
        public final List<IVariable> outputVariables;
        public final List<TypeName> inputTypes;
        public final List<TypeName> outputTypes;

        public IRInfo(List<IVariable> ivars, List<TypeName> itypes, List<IVariable> ovars, List<TypeName> otypes) {
            this.inputTypes = itypes;
            this.inputVariables = ivars;
            this.outputTypes = otypes;
            this.outputVariables = ovars;
        }
    }
}

