/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.path;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.samso.client.IM2LStringAnalyzer;
import com.ibm.wala.samso.m2lstr.DeclarationSet;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IBoolean;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IFormulaDeclaration;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionSetVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.m2lstr.IPredicateDeclaration;
import com.ibm.wala.samso.m2lstr.ITerm;
import com.ibm.wala.samso.m2lstr.IVariable;
import com.ibm.wala.samso.m2lstr.M2LSymbol;
import com.ibm.wala.samso.solver.MONA;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.M2LConstraintEncoder;
import com.ibm.wala.samso.translator.repository.IM2LTranslatorRepository;
import com.ibm.wala.samso.translator.repository.M2LTranslatorRepository;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.stringAnalysis.condition.ConjunctiveCondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveConditionVisitor;
import com.ibm.wala.stringAnalysis.condition.PropagatingPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.grammar.ConstraintSymbol;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.PathSensitiveBB2GR;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class PathFeasibilityAnalysis {
    final CGNode node;
    final IR ir;
    final CallGraph cg;
    final PointerAnalysis pa;
    final IPathConditionAnalysis pca;
    final IExtendedFormulaFactory factory;
    final MonitorUtil.IProgressMonitor monitor;
    final Logger logger;
    final ISymbolFactory<IDeclarationSet> symbolFactory;
    final IM2LTranslatorRepository repository;
    final IM2LStringAnalyzer analyzer;
    final M2LConstraintEncoder encoder;
    private IDeclarationSet inputPattern;

    public PathFeasibilityAnalysis(CGNode node, IM2LStringAnalyzer analyzer, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        this.node = node;
        this.ir = node.getIR();
        this.pca = new PropagatingPathConditionAnalysis(this.ir, monitor);
        this.monitor = monitor;
        this.logger = logger;
        this.analyzer = analyzer;
        this.cg = analyzer.getCallGraph();
        this.pa = analyzer.getPointerAnalysis();
        this.encoder = (M2LConstraintEncoder)analyzer.getSolver();
        this.repository = (M2LTranslatorRepository)analyzer.getRepository();
        this.factory = this.repository.getFormulaFactory();
        this.symbolFactory = analyzer.getSymbolFactory();
        this.inputPattern = DeclarationSets.createAny(this.factory);
    }

    public IDeclarationSet getInputPattern() {
        return this.inputPattern;
    }

    public void setInputPattern(IDeclarationSet declSet) {
        this.inputPattern = declSet;
    }

    public void setInputPattern(String regexp) {
        this.setInputPattern(DeclarationSets.createDeclarationSetForRegexp(regexp, this.factory));
    }

    public boolean isValid(Collection<ISSABasicBlock> bbs) {
        MONA mona = new MONA(this.factory, this.monitor);
        return mona.checkValidity(this.encode(bbs));
    }

    public boolean isInfeasible(Collection<ISSABasicBlock> bbs) {
        MONA mona = new MONA(this.factory, this.monitor);
        return mona.checkUnsatisfiability(this.encode(bbs));
    }

    public boolean isFeasible(Collection<ISSABasicBlock> bbs) {
        MONA mona = new MONA(this.factory, this.monitor);
        return mona.checkSatisfiability(this.encode(bbs));
    }

    protected IDeclarationSet encode(Collection<ISSABasicBlock> bbs) {
        LinkedList<IDeclaration> decls = new LinkedList<IDeclaration>();
        IFormula disj = null;
        for (ISSABasicBlock bb : bbs) {
            IPathCondition cond = this.pca.getCondition(bb);
            IDeclarationSet declSet = this.encode(cond, bb);
            decls.addAll(declSet);
            IFormula f = this.factory.createApplyPredicate(declSet.getTarget(), new ITerm[0]);
            disj = disj == null ? f : this.factory.createOr(disj, f);
        }
        if (disj != null) {
            IFormulaDeclaration decl = this.factory.createFormulaDeclaration(disj);
            decls.add(decl);
        }
        DeclarationSet declSet = new DeclarationSet(null, decls);
        return declSet;
    }

    protected IDeclarationSet encode(IPathCondition cond, ISSABasicBlock bb) {
        LinkedList<IDeclaration> decls = new LinkedList<IDeclaration>();
        IBoolean disj = null;
        DMap<ISymbol, IPositionSetVariable> varMap = new DMap<ISymbol, IPositionSetVariable>(){

            protected IPositionSetVariable create(ISymbol key) {
                return PathFeasibilityAnalysis.this.factory.createPositionSetVariable();
            }
        };
        for (ConjunctiveCondition c : cond) {
            IFormula conj = null;
            for (IPrimitiveCondition p : c) {
                IDeclarationSet d = this.encode(p, bb, (Map<ISymbol, IPositionSetVariable>)varMap);
                decls.addAll(d);
                IFormula f = this.factory.createApplyPredicate(d.getTarget(), new ITerm[0]);
                conj = conj == null ? f : this.factory.createAnd(conj, f);
            }
            disj = disj == null ? conj : this.factory.createOr(disj, conj);
        }
        if (disj == null) {
            disj = this.factory.createTrue();
        }
        IPredicate pred = this.factory.createPredicate(0, IPredicate.ArgType.NONE);
        IPredicateDeclaration decl = this.factory.createPredicateDeclaration(pred, disj, new IVariable[0]);
        decls.add(decl);
        for (IPositionSetVariable S : varMap.values()) {
            IPositionSetVariableDefinition d = this.factory.createPositionSetVariableDefinition(S);
            decls.add(0, d);
        }
        return new DeclarationSet(pred, decls);
    }

    protected IDeclarationSet encode(IPrimitiveCondition p, ISSABasicBlock bb, Map<ISymbol, IPositionSetVariable> varMap) {
        TranslationContext ctx = new TranslationContext(this.ir, this.node, this.cg, this.pa, null, this.pca, this.monitor, this.logger);
        PathSensitiveBB2GR.ConstraintCollector constraintCollector = new PathSensitiveBB2GR.ConstraintCollector(bb, this.symbolFactory, ctx);
        p.visit((IPrimitiveConditionVisitor)constraintCollector);
        Collection disj = constraintCollector.dupMaps();
        LinkedList<IDeclaration> decls = new LinkedList<IDeclaration>();
        IBoolean fdisj = null;
        for (Map conj : disj) {
            IFormula fconj = null;
            for (Map.Entry e : conj.entrySet()) {
                ConstraintSymbol cs = (ConstraintSymbol)e.getValue();
                IDeclarationSet res = this.infer(cs);
                decls.addAll(res);
                IFormula f = this.factory.createApplyPredicate(res.getTarget(), varMap.get(cs.getBase()));
                fconj = fconj == null ? f : this.factory.createAnd(fconj, f);
            }
            fdisj = fdisj == null ? fconj : this.factory.createOr(fdisj, fconj);
        }
        if (fdisj == null) {
            fdisj = this.factory.createFalse();
        }
        IPredicate pred = this.factory.createPredicate(0, IPredicate.ArgType.NONE);
        IPredicateDeclaration decl = this.factory.createPredicateDeclaration(pred, fdisj, new IVariable[0]);
        decls.add(decl);
        return new DeclarationSet(pred, decls);
    }

    private IDeclarationSet infer(ConstraintSymbol cs) {
        SAUtil.println((Object)"-- encoding constraint...");
        SAUtil.println((Object)("base = " + cs.getBase()));
        SAUtil.println((Object)("constraint = " + cs.getConstraint()));
        this.analyzer.getSolverCache().clear();
        M2LSymbol pat = new M2LSymbol(this.inputPattern);
        LinkedList removed = new LinkedList();
        LinkedList<ProductionRule> added = new LinkedList<ProductionRule>();
        int pvn = this.ir.getParameter(this.ir.getMethod().isStatic() ? 0 : 1);
        Collection pvs = this.symbolFactory.createCDVariable(pvn, new TranslationContext(this.ir, this.node, this.cg, this.pa, null, this.pca, this.monitor, this.logger));
        for (com.ibm.wala.automaton.string.IVariable pv : pvs) {
            removed.addAll(this.analyzer.getGR().getGRules(pv));
            added.add(new ProductionRule(pv, (ISymbol)pat));
        }
        com.ibm.wala.automaton.string.IVariable sv = this.symbolFactory.getVariableFactory().createVariable("v");
        added.add(new ProductionRule(sv, (ISymbol)cs));
        this.analyzer.getGR().getRules().removeAll(removed);
        this.analyzer.getGR().getRules().addAll(added);
        IDeclarationSet res = (IDeclarationSet)this.analyzer.infer(Collections.singleton(sv)).get(sv);
        this.analyzer.getGR().getRules().removeAll(added);
        this.analyzer.getGR().getRules().addAll(removed);
        SAUtil.println((Object)res);
        return res;
    }
}

