/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.file.extension.data;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.file.extension.Extension;
import com.ibm.appscan.file.extension.ExtensionGroup;
import com.ibm.appscan.file.extension.ExtensionManager;
import com.ibm.appscan.file.extension.FileExtensionException;
import com.ibm.appscan.file.extension.FileExtensionXml;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class ExtensionWriter {
    private DOMWriter m_writer;
    private DocumentBuilder m_builder;
    private Transformer m_transformer;
    private OutputStream m_stream;

    public ExtensionWriter(File f) throws FileExtensionException {
        try {
            this.m_stream = new BufferedOutputStream(new FileOutputStream(f));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                this.m_builder = factory.newDocumentBuilder();
                TransformerFactory transform_factory = TransformerFactory.newInstance();
                this.m_transformer = transform_factory.newTransformer();
                this.m_transformer.setOutputProperty("indent", "yes");
                this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                this.m_transformer.setOutputProperty("standalone", "yes");
                this.m_writer = new DOMWriter(this.m_stream, this.m_builder);
            }
            catch (ParserConfigurationException e) {
                throw new FileExtensionException(e);
            }
            catch (TransformerConfigurationException e) {
                throw new FileExtensionException(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new FileExtensionException(e);
        }
    }

    public void save(ExtensionManager m) throws FileExtensionException {
        try {
            this.m_writer.beginElement(FileExtensionXml.EXTENSION_MAP);
            for (ExtensionGroup g : m.getGroups().values()) {
                this.m_writer.beginElement(FileExtensionXml.EXTENSION_GROUP);
                this.m_writer.setAttribute(FileExtensionXml.NAME, g.getName());
                this.m_writer.setAttribute(FileExtensionXml.DISPLAY_NAME, g.getDisplayName());
                for (Extension e : g.getExtensions().values()) {
                    this.m_writer.beginElement(FileExtensionXml.EXTENSION);
                    this.m_writer.setAttribute(FileExtensionXml.EXTENSION_ATT, e.getExtension());
                    this.m_writer.setAttribute(FileExtensionXml.PBSA, Boolean.toString(e.isRegex()));
                    this.m_writer.setAttribute(FileExtensionXml.ASSESS, Boolean.toString(e.isAssess()));
                    this.m_writer.endElement();
                }
                this.m_writer.endElement();
            }
            this.m_writer.endElement();
            this.m_writer.write(this.m_transformer);
        }
        catch (TransformerException e) {
            throw new FileExtensionException(e);
        }
        finally {
            IOUtil.close((Closeable)this.m_stream);
        }
    }
}

