/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.jetbrains;

import com.hcl.appscan.discovery.jetbrains.utils.JetBrainsUtil;
import com.hcl.appscan.discovery.jetbrains.utils.Module;
import com.hcl.appscan.internal.discovery.jetbrains.JetBrainsModuleStrategy;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.util.List;
import java.util.Set;

public class JetBrainsProjectStrategy
extends Strategy {
    private File m_project;
    private IStrategyFactoryRegistry m_registry;

    public JetBrainsProjectStrategy() {
    }

    public JetBrainsProjectStrategy(File directory, IStrategyFactoryRegistry registry) {
        this.init(directory, registry);
    }

    public void init(File directory, IStrategyFactoryRegistry registry) {
        this.m_project = directory;
        this.m_registry = registry;
    }

    public String getName() {
        return this.m_project.getName();
    }

    public String getType() {
        return "JetBrains Project";
    }

    public String getPath() {
        return new File(this.m_project.getPath(), ".idea").getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        List<Module> modules = JetBrainsUtil.getModules(this.m_project.getPath());
        for (Module module : modules) {
            proxy.newScanTarget((ScanTargetStrategy)new JetBrainsModuleStrategy(module, this.m_registry));
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

