/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.jetbrains;

import com.hcl.appscan.discovery.jetbrains.utils.JetBrainsUtil;
import com.hcl.appscan.discovery.jetbrains.utils.Module;
import com.hcl.appscan.internal.discovery.jetbrains.JetBrainsProjectStrategy;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.util.List;

public class JetBrainsProjectStrategyFactory
implements IStrategyFactory {
    static final String DOT_IDEA_PATH = ".idea";
    static final String MODULES_XML = "modules.xml";
    static final String ANDROID_MANIFEST = "AndroidManifest.xml";

    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        File modulesFile;
        JetBrainsProjectStrategy strategy = null;
        if (new File(fileOrDirectory, ANDROID_MANIFEST).isFile()) {
            return strategy;
        }
        if (new File(fileOrDirectory, DOT_IDEA_PATH).isDirectory() && (modulesFile = new File(new File(fileOrDirectory, DOT_IDEA_PATH).getAbsolutePath(), MODULES_XML)).exists() && this.isFoundSourceDirectory(fileOrDirectory.getAbsolutePath())) {
            strategy = new JetBrainsProjectStrategy(fileOrDirectory, registry);
        }
        return strategy;
    }

    public boolean isBuildOutput() {
        return false;
    }

    public void loadUniqueTarget(IScan scan) {
    }

    private boolean isFoundSourceDirectory(String projectPath) {
        boolean isFound = false;
        List<Module> modules = JetBrainsUtil.getModules(projectPath);
        for (Module module : modules) {
            if (module.getSourceDirectories().isEmpty()) continue;
            isFound = true;
            break;
        }
        return isFound;
    }
}

