/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.client;

import com.ibm.wala.automaton.parser.JavaRegexParser;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCompiler;
import com.ibm.wala.automaton.regex.string.StringPatternCompiler;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.client.IStringAnalyzer;
import com.ibm.wala.stringAnalysis.client.IStringVerifier;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class StringVerifier<T, V>
implements IStringVerifier<T, V> {
    protected JavaRegexParser parser;
    private IStringAnalyzer<T, V> analyzer;
    protected final MonitorUtil.IProgressMonitor monitor;
    private long lastInferenceTime;
    private long lastVerificationTime;
    private long totalInferenceTime;
    private long totalVerificationTime;
    protected IPatternCompiler<IAutomaton> patternCompiler = new StringPatternCompiler();

    public long getLastInferenceTime() {
        return this.lastInferenceTime;
    }

    public long getLastVerificationTime() {
        return this.lastVerificationTime;
    }

    public long getTotalInferenceTime() {
        return this.totalInferenceTime;
    }

    public long getTotalVerificationTime() {
        return this.totalVerificationTime;
    }

    public IPattern toRegexPattern(String patStr) {
        return this.parser.parse(patStr);
    }

    @Override
    public IAutomaton compilePattern(String patStr) {
        IPattern pat = this.toRegexPattern(patStr);
        if (pat == null) {
            return new Automaton((IState)new State("s1"), (IState[])new State[0], (ITransition[])new Transition[0]);
        }
        IAutomaton a = (IAutomaton)this.patternCompiler.compile(pat);
        return a;
    }

    public StringVerifier(IStringAnalyzer<T, V> analyzer, MonitorUtil.IProgressMonitor monitor) {
        this.analyzer = analyzer;
        this.monitor = monitor;
        this.parser = new JavaRegexParser();
    }

    @Override
    public Map<IStringVerifier.IRule<V>, IStringVerifier.IResult<T, V>> verify(Collection<? extends IStringVerifier.IRule<V>> rules) {
        HashMap<V, IStringVerifier.IRule<V>> ruleMap = new HashMap<V, IStringVerifier.IRule<V>>();
        HashSet<V> vars = new HashSet<V>();
        for (IStringVerifier.IRule<V> rule : rules) {
            vars.add(rule.getVariable());
            ruleMap.put(rule.getVariable(), rule);
        }
        long t1 = System.currentTimeMillis();
        Map<V, T> cfgs = this.analyzer.infer(vars);
        long t2 = System.currentTimeMillis();
        this.lastInferenceTime = t2 - t1;
        this.totalInferenceTime += this.lastInferenceTime;
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("-- inferred variables: " + cfgs.values()));
        }
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw CancelRuntimeException.make((String)"After inferring veriables");
        }
        long t3 = System.currentTimeMillis();
        Map<IStringVerifier.IRule<V>, IStringVerifier.IResult<T, V>> results = this.verifyInternal(ruleMap, cfgs);
        long t4 = System.currentTimeMillis();
        this.lastVerificationTime = t4 - t3;
        this.totalVerificationTime += this.lastVerificationTime;
        return results;
    }

    protected Map<IStringVerifier.IRule<V>, IStringVerifier.IResult<T, V>> verifyInternal(Map<V, IStringVerifier.IRule<V>> ruleMap, Map<V, T> cfgs) {
        HashMap<IStringVerifier.IRule<V>, IStringVerifier.IResult<T, V>> results = new HashMap<IStringVerifier.IRule<V>, IStringVerifier.IResult<T, V>>();
        for (Map.Entry<V, IStringVerifier.IRule<V>> entry : ruleMap.entrySet()) {
            this.verifyInternal(cfgs, results, entry.getKey(), entry.getValue());
        }
        return results;
    }

    protected void verifyInternal(Map<V, T> cfgs, Map<IStringVerifier.IRule<V>, IStringVerifier.IResult<T, V>> results, V v, IStringVerifier.IRule<V> rule) {
        T cfg = cfgs.get(v);
        boolean isLegal = true;
        boolean isIllegal = false;
        String legalPattern = rule.getLegalPattern();
        String illegalPattern = rule.getIllegalPattern();
        if (legalPattern != null) {
            isLegal = this.containsAll(legalPattern, cfg);
        }
        if (illegalPattern != null) {
            isIllegal = this.containsSome(cfg, illegalPattern);
        }
        Result<T, V> result = new Result<T, V>(isLegal && !isIllegal, rule, cfg);
        results.put(rule, result);
    }

    @Override
    public boolean containsAll(String pattern, T cfg) {
        return this.containsAll(this.compilePattern(pattern), cfg);
    }

    @Override
    public boolean containsSome(T cfg, String pattern) {
        return this.containsSome(cfg, this.compilePattern(pattern));
    }

    public static class Result<T, V>
    implements IStringVerifier.IResult<T, V> {
        private boolean isLegal;
        private IStringVerifier.IRule<V> rule;
        private T cfg;

        public Result(boolean result, IStringVerifier.IRule<V> rule, T cfg) {
            this.isLegal = result;
            this.rule = rule;
            this.cfg = cfg;
        }

        @Override
        public boolean isLegal() {
            return this.isLegal;
        }

        @Override
        public IStringVerifier.IRule<V> getRule() {
            return this.rule;
        }

        @Override
        public T getCFG() {
            return this.cfg;
        }
    }

    public static class Rule<V>
    implements IStringVerifier.IRule<V> {
        private String legalPattern;
        private String illegalPattern;
        private V variable;

        public Rule(V var, String legalPattern, String illegalPattern) {
            this.variable = var;
            this.legalPattern = legalPattern;
            this.illegalPattern = illegalPattern;
        }

        @Override
        public String getIllegalPattern() {
            return this.illegalPattern;
        }

        @Override
        public String getLegalPattern() {
            return this.legalPattern;
        }

        @Override
        public V getVariable() {
            return this.variable;
        }

        public int hashCode() {
            return this.variable.hashCode() + (this.illegalPattern == null ? 0 : this.illegalPattern.hashCode() * 13) + (this.legalPattern == null ? 0 : this.legalPattern.hashCode() * 19);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Rule)) {
                return false;
            }
            Rule r = (Rule)obj;
            return this.variable.equals(r.variable) && (this.illegalPattern == null ? r.illegalPattern == null : this.illegalPattern.equals(r.illegalPattern)) && (this.legalPattern == null ? r.legalPattern == null : this.legalPattern.equals(r.legalPattern));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.illegalPattern != null) {
                sb.append(this.variable);
                sb.append("<>");
                sb.append(this.illegalPattern);
            }
            sb.append(" ");
            if (this.legalPattern != null) {
                sb.append(this.variable);
                sb.append("==");
                sb.append(this.legalPattern);
            }
            return sb.toString();
        }
    }
}

