/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.util.labeledgraph.EdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.IRegexAlgebra;
import com.ibm.wala.automaton.util.labeledgraph.LabelReduction;
import com.ibm.wala.automaton.util.labeledgraph.MapEdgeDecorator;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.stringAnalysis.condition.AndCondition;
import com.ibm.wala.stringAnalysis.condition.ConjunctiveCondition;
import com.ibm.wala.stringAnalysis.condition.DefCondition;
import com.ibm.wala.stringAnalysis.condition.FalseCondition;
import com.ibm.wala.stringAnalysis.condition.ICondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionCollector;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.Normalizer;
import com.ibm.wala.stringAnalysis.condition.OrCondition;
import com.ibm.wala.stringAnalysis.condition.PathCondition;
import com.ibm.wala.stringAnalysis.condition.PhiCondition;
import com.ibm.wala.stringAnalysis.condition.TrueCondition;
import com.ibm.wala.stringAnalysis.condition.VarCondition;
import com.ibm.wala.stringAnalysis.ssa.SSACFGWithConditions;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BooleanConditionCollector
implements IPathConditionCollector {
    private static final LiftLabel labelToCondition = new LiftLabel();
    static final Normalizer normalizer = Normalizer.create();
    private final Map<ISSABasicBlock, List<IPathCondition>> ML = new HashMap<ISSABasicBlock, List<IPathCondition>>();
    private final Map<ISSABasicBlock, IPathCondition> M = new HashMap<ISSABasicBlock, IPathCondition>();
    private final SSACFGWithConditions cfg;
    private final SSACFGEdgeVisitor edgeVisitor;

    public BooleanConditionCollector(SSACFGWithConditions cfg, MonitorUtil.IProgressMonitor monitor) {
        this.cfg = cfg;
        this.edgeVisitor = new SSACFGEdgeVisitor(monitor);
    }

    @Override
    public IPathCondition getCondition(int i, int d) {
        ISSABasicBlock bb = this.cfg.getNode(i);
        IPathCondition cond = this.M.get(bb);
        if (cond == null) {
            List<IPathCondition> l = this.getConditions(i, d);
            Iterator<IPathCondition> iter = l.iterator();
            if (iter.hasNext()) {
                PathCondition c;
                IPathCondition p = iter.next();
                PathCondition pathCondition = c = p == null ? new PathCondition() : new PathCondition(p);
                while (iter.hasNext()) {
                    IPathCondition p2 = iter.next();
                    if (p2 == null) continue;
                    c.addAll(p2);
                }
                cond = BooleanConditionCollector.minimize(c);
                this.M.put(bb, cond);
            } else {
                return null;
            }
        }
        return cond;
    }

    @Override
    public List<IPathCondition> getConditions(int i, int d) {
        ISSABasicBlock bb = this.cfg.getNode(i);
        List<IPathCondition> cond = this.ML.get(bb);
        if (cond == null) {
            this.collect(bb, d);
            cond = this.ML.get(bb);
        }
        return cond;
    }

    protected void collect(int n, int d) {
        this.collect(this.cfg.getNode(n), d);
    }

    protected void collect(int d) {
        Iterator<ISSABasicBlock> iterator = this.cfg.iterator();
        while (iterator.hasNext()) {
            ISSABasicBlock bb = iterator.next();
            this.collect(bb, d);
        }
    }

    protected void collect(ISSABasicBlock bb, int d) {
        if (bb.isExitBlock()) {
            ArrayList<Object> es = new ArrayList<Object>();
            int n = this.cfg.getPredNodeCount(bb);
            for (int i = 0; i < n; ++i) {
                es.add(null);
            }
            this.ML.put(bb, es);
            return;
        }
        ArrayList<IPathCondition> es = new ArrayList<IPathCondition>();
        Iterator<ISSABasicBlock> iterPred = this.cfg.getPredNodes(bb);
        while (iterPred.hasNext()) {
            NonNullSingletonIterator fin;
            ISSABasicBlock pred = iterPred.next();
            ArrayList<Pair> ignoredEdges = new ArrayList<Pair>();
            Iterator<ISSABasicBlock> ic = this.cfg.getPredNodes(bb);
            while (ic.hasNext()) {
                ISSABasicBlock pbb = ic.next();
                if (pred.equals(pbb)) continue;
                ignoredEdges.add(Pair.make((Object)pbb, (Object)bb));
            }
            MapEdgeDecorator liftingEdgeDecorator = new MapEdgeDecorator((EdgeDecorator)this.cfg, (Function)labelToCondition);
            NonNullSingletonIterator ent = new NonNullSingletonIterator((Object)this.cfg.entry());
            ICondition c = (ICondition)LabelReduction.reduceLabels((Graph)this.cfg, (EdgeDecorator)liftingEdgeDecorator, (Iterator)ent, (Iterator)(fin = new NonNullSingletonIterator((Object)bb)), (Object)DummyBasicBlock.PSEUDO_ENTRY, (Object)DummyBasicBlock.PSEUDO_EXIT, (IRegexAlgebra)this.edgeVisitor, ignoredEdges);
            if (c == null) {
                c = FalseCondition.theInstance;
            }
            IPathCondition n = normalizer.normalize(c, this, d);
            IPathCondition e = BooleanConditionCollector.minimize(n);
            es.add(e);
        }
        this.ML.put(bb, es);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("BB" + bb.getNumber() + " : " + es));
        }
    }

    private static IPathCondition minimize(IPathCondition dnf) {
        PathCondition tmp = new PathCondition();
        PathCondition ret = new PathCondition();
        block0: for (ConjunctiveCondition conj : dnf) {
            HashSet<DefCondition> defs = new HashSet<DefCondition>();
            Iterator i = conj.iterator();
            while (i.hasNext()) {
                IPrimitiveCondition prim = (IPrimitiveCondition)i.next();
                if (prim.isContrary(conj)) continue block0;
                if (!(prim instanceof DefCondition)) continue;
                defs.add((DefCondition)prim);
                i.remove();
            }
            HashSet<IPrimitiveCondition> add = new HashSet<IPrimitiveCondition>();
            Iterator i2 = conj.iterator();
            while (i2.hasNext()) {
                IPrimitiveCondition prim = (IPrimitiveCondition)i2.next();
                if (!(prim instanceof PhiCondition)) continue;
                PhiCondition phi = (PhiCondition)prim;
                i2.remove();
                if (phi.vn > 0) {
                    if (!defs.contains(new DefCondition(phi.vn))) continue;
                    add.add(phi.condition);
                    continue;
                }
                if (defs.contains(new DefCondition(-phi.vn))) continue;
                add.add(phi.condition);
            }
            conj.addAll(add);
            tmp.add(conj);
        }
        PathCondition tmp2 = new PathCondition();
        for (ConjunctiveCondition conj : tmp) {
            if (conj.contains(FalseCondition.theInstance)) continue;
            tmp2.add(conj);
        }
        block4: for (ConjunctiveCondition conj : tmp2) {
            for (ConjunctiveCondition conj2 : tmp2) {
                if (!conj.containsAll(conj2) || conj.equals(conj2)) continue;
                continue block4;
            }
            ret.add(conj);
        }
        return ret;
    }

    protected static class LiftLabel
    implements Function<ICondition, ICondition> {
        public ICondition apply(ICondition i) {
            return i;
        }
    }

    protected static class SSACFGEdgeVisitor
    implements IRegexAlgebra<ICondition> {
        final MonitorUtil.IProgressMonitor monitor;

        private SSACFGEdgeVisitor(MonitorUtil.IProgressMonitor monitor) {
            this.monitor = monitor == null ? AUtil.nullProgressMonitor : monitor;
        }

        private boolean isTrue(ICondition e) {
            return TrueCondition.theInstance.equals(e);
        }

        private boolean isFalse(ICondition e) {
            return FalseCondition.theInstance.equals(e);
        }

        private boolean isDef(ICondition e) {
            return e instanceof DefCondition;
        }

        public ICondition concat(ICondition e1, ICondition e2) {
            if (e1 == null) {
                e1 = TrueCondition.theInstance;
            }
            if (e2 == null) {
                e2 = TrueCondition.theInstance;
            }
            if (this.isFalse(e1)) {
                return FalseCondition.theInstance;
            }
            if (this.isFalse(e2)) {
                return FalseCondition.theInstance;
            }
            if (this.isTrue(e1)) {
                return e2;
            }
            if (this.isTrue(e2)) {
                return e1;
            }
            if (e1 instanceof VarCondition && e2 instanceof VarCondition) {
                int v1 = ((VarCondition)e1).var;
                int v2 = ((VarCondition)e2).var;
                if (v1 == v2) {
                    return e1;
                }
                if (v1 + v2 == 0) {
                    return FalseCondition.theInstance;
                }
            }
            return new AndCondition(e1, e2);
        }

        public ICondition kleene(ICondition e) {
            return TrueCondition.theInstance;
        }

        public ICondition union(ICondition e1, ICondition e2) {
            if (e1 == null) {
                e1 = TrueCondition.theInstance;
            }
            if (e2 == null) {
                e2 = TrueCondition.theInstance;
            }
            if ((this.isTrue(e1) || this.isTrue(e2)) && !this.isDef(e1) && !this.isDef(e2)) {
                return TrueCondition.theInstance;
            }
            if (this.isFalse(e1) && this.isFalse(e2)) {
                return FalseCondition.theInstance;
            }
            if (this.isFalse(e1)) {
                return e2;
            }
            if (this.isFalse(e2)) {
                return e1;
            }
            if (e1 instanceof VarCondition && e2 instanceof VarCondition) {
                int v1 = ((VarCondition)e1).var;
                int v2 = ((VarCondition)e2).var;
                if (v1 + v2 == 0) {
                    return TrueCondition.theInstance;
                }
                if (v1 == v2) {
                    return e1;
                }
            }
            return new OrCondition(e1, e2);
        }
    }

    private static class DummyBasicBlock
    implements ISSABasicBlock {
        private final int num;
        protected static final DummyBasicBlock PSEUDO_ENTRY = new DummyBasicBlock(Integer.MAX_VALUE);
        protected static final DummyBasicBlock PSEUDO_EXIT = new DummyBasicBlock(0x7FFFFFFE);

        private DummyBasicBlock(int n) {
            this.num = n;
        }

        public int getFirstInstructionIndex() {
            Assertions.UNREACHABLE();
            return 0;
        }

        public int getLastInstructionIndex() {
            Assertions.UNREACHABLE();
            return 0;
        }

        public Iterator<SSAPhiInstruction> iteratePhis() {
            Assertions.UNREACHABLE();
            return null;
        }

        public Iterator<SSAPiInstruction> iteratePis() {
            Assertions.UNREACHABLE();
            return null;
        }

        public SSAInstruction getLastInstruction() {
            Assertions.UNREACHABLE();
            return null;
        }

        public IMethod getMethod() {
            Assertions.UNREACHABLE();
            return null;
        }

        public int getNumber() {
            return this.num;
        }

        public boolean isCatchBlock() {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean isEntryBlock() {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean isExitBlock() {
            Assertions.UNREACHABLE();
            return false;
        }

        public Iterator<SSAInstruction> iterator() {
            Assertions.UNREACHABLE();
            return null;
        }

        public int getGraphNodeId() {
            return this.num;
        }

        public void setGraphNodeId(int number) {
            Assertions.UNREACHABLE();
        }

        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return Collections.emptySet().iterator();
        }
    }
}

