/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BasicFramework;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.AbstractVariable;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.stringAnalysis.condition.AndCondition;
import com.ibm.wala.stringAnalysis.condition.ICondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.dnf.Conjuction;
import com.ibm.wala.stringAnalysis.condition.dnf.Dnf;
import com.ibm.wala.stringAnalysis.condition.dnf.DnfMinimizer;
import com.ibm.wala.stringAnalysis.ssa.SSACFGWithConditions;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PropagatingPathConditionAnalysis
implements IPathConditionAnalysis {
    private final Dnf[] dnfConditions;
    private final IPathCondition[] conditions;
    private final SSACFG cfg;
    private final TransferFunctionProvider transferFunctionProvider;
    private final DnfMinimizer dnfMinimizer;

    public PropagatingPathConditionAnalysis(IR ir, MonitorUtil.IProgressMonitor progressMonitor) {
        this.cfg = ir.getControlFlowGraph();
        SSACFGWithConditions conditioned = new SSACFGWithConditions(ir);
        this.transferFunctionProvider = new TransferFunctionProvider(conditioned);
        this.dnfMinimizer = new DnfMinimizer();
        Framework framework = new Framework((Graph<ISSABasicBlock>)this.cfg, this.transferFunctionProvider);
        Solver solver = new Solver((IKilldallFramework<ISSABasicBlock, PathConditionVar>)framework);
        try {
            solver.solve(progressMonitor);
            int nNodes = this.cfg.getNumberOfNodes();
            this.dnfConditions = new Dnf[nNodes];
            this.conditions = new IPathCondition[nNodes];
            for (ISSABasicBlock bb : this.cfg) {
                IPathCondition condition;
                PathConditionVar solutionAtBB = (PathConditionVar)solver.getIn(bb);
                int n = bb.getNumber();
                this.dnfConditions[n] = solutionAtBB.condition;
                this.conditions[n] = condition = solutionAtBB.condition.toPathCondition();
                if (!SAUtil.DEBUG) continue;
                SAUtil.println((Object)("BB" + n + " : " + condition));
            }
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
    }

    public DnfMinimizer getDnfMinimizer() {
        return this.dnfMinimizer;
    }

    @Override
    public IPathCondition getCondition(ISSABasicBlock block) {
        return this.conditions[block.getNumber()];
    }

    @Override
    public List<IPathCondition> getConditions(ISSABasicBlock block) {
        ArrayList<IPathCondition> ret = new ArrayList<IPathCondition>(this.cfg.getPredNodeCount(block));
        Iterator predNodesIter = this.cfg.getPredNodes(block);
        while (predNodesIter.hasNext()) {
            ISSABasicBlock pred = (ISSABasicBlock)predNodesIter.next();
            UnaryOperator<PathConditionVar> edgeTF = this.transferFunctionProvider.getEdgeTransferFunction(pred, block);
            PathConditionVar lhs = new PathConditionVar(this.getDnfMinimizer());
            PathConditionVar rhs = new PathConditionVar(this.dnfConditions[pred.getNumber()]);
            edgeTF.evaluate((IVariable)lhs, (IVariable)rhs);
            IPathCondition pathConditionAfterEdge = lhs.condition.toPathCondition();
            ret.add(pathConditionAfterEdge);
        }
        return ret;
    }

    private class TransferFunctionProvider
    implements ITransferFunctionProvider<ISSABasicBlock, PathConditionVar> {
        private final AbstractMeetOperator<PathConditionVar> meet;
        private final PathConditionIdentity identity;
        private final SSACFGWithConditions conditioned;

        public TransferFunctionProvider(SSACFGWithConditions conditioned) {
            this.meet = new MeetOperator();
            this.identity = new PathConditionIdentity();
            this.conditioned = conditioned;
        }

        public UnaryOperator<PathConditionVar> getEdgeTransferFunction(ISSABasicBlock src, ISSABasicBlock dst) {
            UnaryOperator ret;
            if (src == this.conditioned.entry()) {
                Conjuction trueConjuction = Conjuction.make(new IPrimitiveCondition[0]);
                assert (null != trueConjuction);
                Dnf all = Dnf.make(new Conjuction[]{trueConjuction}, PropagatingPathConditionAnalysis.this.getDnfMinimizer());
                ret = new RetrunFixedValueOperator(all);
            } else {
                ICondition label = this.conditioned.getLabel(src, dst);
                Conjuction labelAsConjunction = this.toConjunction(label);
                ret = labelAsConjunction == null ? this.identity : new AddConditionOperation(labelAsConjunction);
            }
            return ret;
        }

        private Conjuction toConjunction(ICondition label) {
            if (label instanceof IPrimitiveCondition) {
                IPrimitiveCondition primCondition = (IPrimitiveCondition)label;
                return Conjuction.make(new IPrimitiveCondition[]{primCondition});
            }
            if (label instanceof AndCondition) {
                Conjuction conj2;
                AndCondition andCondition = (AndCondition)label;
                Conjuction conj1 = this.toConjunction(andCondition.e1);
                if (conj1 != null && (conj2 = this.toConjunction(andCondition.e2)) != null) {
                    return conj1.and(conj2);
                }
            }
            return null;
        }

        public AbstractMeetOperator<PathConditionVar> getMeetOperator() {
            return this.meet;
        }

        public UnaryOperator<PathConditionVar> getNodeTransferFunction(ISSABasicBlock node) {
            throw new UnsupportedOperationException();
        }

        public boolean hasEdgeTransferFunctions() {
            return true;
        }

        public boolean hasNodeTransferFunctions() {
            return false;
        }
    }

    private static class RetrunFixedValueOperator
    extends UnaryOperator<PathConditionVar> {
        private final Dnf val;

        public RetrunFixedValueOperator(Dnf val) {
            this.val = val;
        }

        public byte evaluate(PathConditionVar lhs, PathConditionVar rhs) {
            if (lhs == null) {
                throw new IllegalArgumentException("lhs == null");
            }
            PathConditionVar U = new PathConditionVar(this.val);
            if (!lhs.sameValue(U)) {
                lhs.copyState(U);
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof RetrunFixedValueOperator) {
                return this.val.equals(((RetrunFixedValueOperator)((Object)o)).val);
            }
            return false;
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public String toString() {
            return "Return : " + this.val;
        }
    }

    private class AddConditionOperation
    extends UnaryOperator<PathConditionVar> {
        private final Conjuction conjuction;

        public AddConditionOperation(Conjuction conjuction) {
            this.conjuction = conjuction;
        }

        public byte evaluate(PathConditionVar lhs, PathConditionVar rhs) {
            if (lhs == null) {
                throw new IllegalArgumentException("lhs == null");
            }
            PathConditionVar U = new PathConditionVar(PropagatingPathConditionAnalysis.this.getDnfMinimizer());
            U.copyState(lhs);
            U.or(rhs, PropagatingPathConditionAnalysis.this.getDnfMinimizer());
            U.and(this.conjuction, PropagatingPathConditionAnalysis.this.getDnfMinimizer());
            if (!lhs.sameValue(U)) {
                lhs.copyState(U);
                byte ret = lhs.isTop() ? (byte)3 : 1;
                return ret;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof AddConditionOperation) {
                return this.conjuction.equals(((AddConditionOperation)((Object)o)).conjuction);
            }
            return false;
        }

        public int hashCode() {
            return this.conjuction.hashCode();
        }

        public String toString() {
            return "Add Condition: " + this.conjuction;
        }
    }

    private static class PathConditionIdentity
    extends UnaryOperator<PathConditionVar> {
        private PathConditionIdentity() {
        }

        public byte evaluate(PathConditionVar lhs, PathConditionVar rhs) throws IllegalArgumentException {
            if (lhs == null) {
                throw new IllegalArgumentException("lhs cannot be null");
            }
            if (lhs.sameValue(rhs)) {
                return 0;
            }
            lhs.copyState(rhs);
            return 1;
        }

        public String toString() {
            return "Id ";
        }

        public int hashCode() {
            return 235987;
        }

        public boolean equals(Object o) {
            return o instanceof PathConditionIdentity;
        }

        public boolean isIdentity() {
            return true;
        }
    }

    public class MeetOperator
    extends AbstractMeetOperator<PathConditionVar>
    implements FixedPointConstants {
        public boolean equals(Object o) {
            return this == o;
        }

        public byte evaluate(PathConditionVar lhs, PathConditionVar[] rhs) {
            if (rhs == null) {
                throw new IllegalArgumentException("null rhs");
            }
            PathConditionVar U = new PathConditionVar(PropagatingPathConditionAnalysis.this.getDnfMinimizer());
            U.copyState(lhs);
            for (int i = 0; i < rhs.length; ++i) {
                PathConditionVar R = rhs[i];
                if (R == null) continue;
                U.or(R, PropagatingPathConditionAnalysis.this.getDnfMinimizer());
            }
            if (!lhs.sameValue(U)) {
                lhs.copyState(U);
                byte ret = lhs.isTop() ? (byte)3 : 1;
                return ret;
            }
            return 0;
        }

        public int hashCode() {
            return 2358731;
        }

        public String toString() {
            return "Meet on PathConditionVar";
        }
    }

    private class Solver
    extends DataflowSolver<ISSABasicBlock, PathConditionVar> {
        public Solver(IKilldallFramework<ISSABasicBlock, PathConditionVar> problem) {
            super(problem);
        }

        protected PathConditionVar makeEdgeVariable(ISSABasicBlock src, ISSABasicBlock dst) {
            return new PathConditionVar(PropagatingPathConditionAnalysis.this.getDnfMinimizer());
        }

        protected PathConditionVar makeNodeVariable(ISSABasicBlock n, boolean IN) {
            return new PathConditionVar(PropagatingPathConditionAnalysis.this.getDnfMinimizer());
        }

        protected PathConditionVar[] makeStmtRHS(int size) {
            return new PathConditionVar[size];
        }
    }

    private static class Framework
    extends BasicFramework<ISSABasicBlock, PathConditionVar> {
        public Framework(Graph<ISSABasicBlock> flowGraph, ITransferFunctionProvider<ISSABasicBlock, PathConditionVar> transferFunctionProvider) {
            super(flowGraph, transferFunctionProvider);
        }
    }

    private static class PathConditionVar
    extends AbstractVariable<PathConditionVar> {
        private Dnf condition;

        public PathConditionVar(Dnf condition) {
            this.condition = condition;
        }

        public PathConditionVar(Conjuction conjunction, DnfMinimizer minimizer) {
            this.condition = Dnf.make(new Conjuction[]{conjunction}, minimizer);
        }

        public PathConditionVar(DnfMinimizer minimizer) {
            this.condition = Dnf.make(new Conjuction[0], minimizer);
        }

        public void copyState(PathConditionVar v) {
            this.condition = v.condition;
        }

        public void or(PathConditionVar r, DnfMinimizer minimizer) {
            this.condition = this.condition.or(r.condition, minimizer);
        }

        public void and(Conjuction conjuction, DnfMinimizer minimizer) {
            this.condition = this.condition.and(conjuction, minimizer);
        }

        public boolean sameValue(PathConditionVar u) {
            return this.condition.equals(u.condition);
        }

        public String toString() {
            return this.condition.toString();
        }

        public boolean isTop() {
            return this.condition.isTrue();
        }
    }
}

