/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.stringAnalysis.condition.ConjunctiveCondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.ISymbolicCondition;
import com.ibm.wala.stringAnalysis.condition.ISymbolicMergeCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.PathCondition;
import com.ibm.wala.stringAnalysis.condition.SymbolicCaseCondition;
import com.ibm.wala.stringAnalysis.condition.SymbolicSSACondition;
import java.util.Collection;
import java.util.HashSet;

public class SymbolicDefaultCaseCondition
extends SymbolicSSACondition<SSASwitchInstruction>
implements ISymbolicMergeCondition {
    public SymbolicDefaultCaseCondition(CGNode node, SSASwitchInstruction instruction) {
        super(node, instruction);
    }

    @Override
    public Collection<ISymbolicCondition> merge(Collection<ISymbolicCondition> c) {
        SSASwitchInstruction si = (SSASwitchInstruction)this.getCorrespondingInstruction();
        int[] caseAndLabels = si.getCasesAndLabels();
        HashSet<SymbolicCaseCondition> caseConds = new HashSet<SymbolicCaseCondition>();
        for (int i = 0; i < caseAndLabels.length; ++i) {
            int caseValue = caseAndLabels[i];
            ++i;
            SymbolicCaseCondition caseCond = new SymbolicCaseCondition(this.getCorrespondingCGNode(), (SSASwitchInstruction)this.getCorrespondingInstruction(), caseValue);
            if (!c.contains(caseCond)) {
                c.add(this);
                return c;
            }
            caseConds.add(caseCond);
        }
        c.removeAll(caseConds);
        return c;
    }

    @Override
    public IPathCondition pathCondition() {
        SSASwitchInstruction si = (SSASwitchInstruction)this.getCorrespondingInstruction();
        int vn = si.getUse(0);
        ConjunctiveCondition conj = new ConjunctiveCondition();
        int[] caseAndLabels = si.getCasesAndLabels();
        for (int i = 0; i < caseAndLabels.length; ++i) {
            int cv = caseAndLabels[i];
            ++i;
            NotCaseCondition c = new NotCaseCondition(vn, cv);
            conj.add(c);
        }
        PathCondition pathCond = new PathCondition();
        pathCond.add(conj);
        return pathCond;
    }
}

