/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.string.BooleanSymbol;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ICharValueSymbol;
import com.ibm.wala.automaton.string.IFormalLanguage;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.SimpleSymbolCopier;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.ITranslator;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BasicTranslator<T extends IFormalLanguage>
implements ITranslator<T>,
Cloneable {
    protected int target;
    protected String funcName;
    protected ISymbol recv;
    protected List<ISymbol> params;
    protected IProductionRule rule;
    protected IVariableFactory<IVariable> varFactory;
    protected IStateFactory stateFactory;
    protected SimpleGrammar grammar;
    protected IConstraintSolver<T> solver;
    protected MonitorUtil.IProgressMonitor monitor = SAUtil.nullProgressMonitor;
    public static final IContextFreeGrammar ANY_CFG = Grammars.createAny((IVariable)new Variable("v"));
    public static final SimpleGrammar ANY_GRAMMAR = ANY_CFG.toSimple();
    public static final IContextFreeGrammar EMPTY_CFG = Grammars.createEmpty((IVariable)new Variable("v"));
    public static final SimpleGrammar EMPTY_GRAMMAR = EMPTY_CFG.toSimple();
    protected StringParamConv stringParamConv = new StringParamConv();
    protected DefaultParamConv defaultParamConv = new DefaultParamConv();
    private static int MAX_STRING_VALUES_SIZE = 127;

    public BasicTranslator() {
        this.target = -1;
    }

    public BasicTranslator(int target) {
        this.target = target;
    }

    @Override
    public void init(IVariableFactory<IVariable> varFactory, IStateFactory stateFactory, MonitorUtil.IProgressMonitor monitor) {
        this.varFactory = varFactory;
        this.stateFactory = stateFactory;
        this.monitor = monitor;
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<T> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        this.funcName = funcName;
        this.recv = recv;
        this.params = params;
        this.rule = rule;
        this.solver = solver;
        this.grammar = grammar;
        SimpleGrammar g2 = (SimpleGrammar)grammar.copy((IGrammarCopier)SimpleGrammarCopier.defaultCopier);
        if (this.target >= 0) {
            this.setStartSymbol(g2, params.get(this.target), this.varFactory);
        } else if (this.target == -1) {
            this.setStartSymbol(g2, recv, this.varFactory);
        } else if (this.target == -2) {
            this.setStartSymbol(g2, (ISymbol)rule.getLeft(), this.varFactory);
        } else {
            throw new RuntimeException("unsupported target");
        }
        this.setupParameters();
        return g2;
    }

    protected void setupParameters() {
    }

    @Override
    public ITranslator<T> copy() {
        return (ITranslator)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setStartSymbol(SimpleGrammar cfg, ISymbol symbol, IVariableFactory<IVariable> varFactory) {
        if (symbol instanceof IVariable) {
            cfg.setStartSymbol((IVariable)symbol);
        } else {
            IVariable v = this.createVariable();
            if (symbol instanceof StringSymbol) {
                StringSymbol ss = (StringSymbol)symbol;
                cfg.addRule((IProductionRule)new ProductionRule(v, ss.toCharSymbols()));
            } else if (symbol == null) {
                cfg.addRule((IProductionRule)new ProductionRule(v, new ISymbol[0]));
            } else {
                cfg.addRule((IProductionRule)new ProductionRule(v, symbol));
            }
            cfg.setStartSymbol(v);
        }
    }

    @Override
    public T translateCyclic(T target, int cyclic) throws TranslationException {
        return (T)((IFormalLanguage)this.translate(target));
    }

    protected IVariable createVariable() {
        return this.varFactory.createVariable(Grammars.variablePrefix);
    }

    protected static IContextFreeGrammar createAnyCFG() {
        return ANY_CFG;
    }

    protected static SimpleGrammar createAny() {
        return ANY_GRAMMAR;
    }

    protected static SimpleGrammar createEmpty() {
        return EMPTY_GRAMMAR;
    }

    protected SimpleGrammar useUniqueVariables(SimpleGrammar g) {
        return (SimpleGrammar)Grammars.useUniqueVariables((IGrammar)g, this.varFactory, new HashMap());
    }

    protected <U extends IGrammar> U convertIntToChar(U g) {
        return (U)g.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new SimpleSymbolCopier(){

            public ISymbol copy(ISymbol symbol) {
                if (symbol instanceof IntSymbol) {
                    IntSymbol isym = (IntSymbol)symbol;
                    CharSymbol csym = new CharSymbol((char)isym.intValue());
                    return csym;
                }
                return super.copy(symbol);
            }
        })));
    }

    protected SimpleGrammar possibleStrings(SimpleGrammar g, boolean allowEmpty) {
        return this.possibleStrings(Grammars.collectTerminals((IGrammar[])new IGrammar[]{g}), allowEmpty);
    }

    protected SimpleGrammar possibleStrings(Collection<? extends ISymbol> terminals, boolean allowEmpty) {
        IVariable start = this.createVariable();
        IVariable v0 = this.createVariable();
        HashSet<ProductionRule> rules = new HashSet<ProductionRule>();
        rules.add(new ProductionRule(start, (ISymbol)v0));
        if (allowEmpty) {
            rules.add(new ProductionRule(v0, new ISymbol[0]));
        } else {
            for (ISymbol iSymbol : terminals) {
                rules.add(new ProductionRule(v0, new ISymbol[]{iSymbol}));
            }
        }
        for (ISymbol iSymbol : terminals) {
            rules.add(new ProductionRule(v0, new ISymbol[]{iSymbol, v0}));
        }
        if (rules.isEmpty()) {
            rules.add(new ProductionRule(start, new ISymbol[0]));
        }
        SimpleGrammar g = new SimpleGrammar(start, rules);
        return g;
    }

    protected SimpleGrammar possibleCharacters(SimpleGrammar g) {
        return this.possibleCharacters(Grammars.collectTerminals((IGrammar[])new IGrammar[]{g}));
    }

    protected SimpleGrammar possibleCharacters(Collection<? extends ISymbol> terminals) {
        IVariable start = this.createVariable();
        HashSet<ProductionRule> rules = new HashSet<ProductionRule>();
        for (ISymbol iSymbol : terminals) {
            IVariable v = this.createVariable();
            rules.add(new ProductionRule(start, (ISymbol)v));
            rules.add(new ProductionRule(v, iSymbol));
        }
        SimpleGrammar g = new SimpleGrammar(start, rules);
        return g;
    }

    protected SimpleGrammar unionStrings(Collection<? extends ISymbol> terminals) {
        IVariable start = this.createVariable();
        HashSet<ProductionRule> rules = new HashSet<ProductionRule>();
        for (ISymbol iSymbol : terminals) {
            ProductionRule r = new ProductionRule(start, iSymbol);
            rules.add(r);
        }
        return new SimpleGrammar(start, rules);
    }

    @Override
    public SimpleGrammar possibleGrammar(SimpleGrammar g) {
        return this.possibleStrings(g, true);
    }

    protected abstract Collection<String> stringValues(T var1, int var2);

    protected abstract ILanguageSymbol<T> createLanguageSymbol(T var1);

    protected abstract ILanguageSymbol<T> createLanguageSymbol(IValueSymbol var1);

    protected ILanguageSymbol<T> solveParameter(int n, IParamConv<T> conv) {
        return this.solveParameter(this.getParameterSymbol(n), conv);
    }

    private ISymbol getParameterSymbol(int n) {
        if (n == -1) {
            return this.recv;
        }
        return this.params.get(n);
    }

    protected ILanguageSymbol<T> solveParameter(ISymbol s, IParamConv<T> conv) {
        if (s instanceof IVariable) {
            IVariable v = (IVariable)s;
            SimpleGrammar g = new SimpleGrammar((IGrammar)this.grammar);
            IFormalLanguage sg = (IFormalLanguage)this.solver.solve(g, v);
            return conv.convert(sg);
        }
        if (s instanceof IValueSymbol) {
            return conv.convert((IValueSymbol)s);
        }
        throw new RuntimeException("unexpected parameter symbol: " + s);
    }

    protected ILanguageSymbol<T> solveParameter(int n) {
        return this.solveParameter(n, this.defaultParamConv);
    }

    protected ILanguageSymbol<T> solveStringParameter(int n) {
        return this.solveParameter(n, this.stringParamConv);
    }

    protected ILanguageSymbol<T> solveString(ISymbol s) {
        return this.solveParameter(s, this.stringParamConv);
    }

    protected Collection<String> stringValues(T g) {
        return this.stringValues(g, MAX_STRING_VALUES_SIZE);
    }

    protected Collection<String> solveStringConstantParameters(int n) throws IllegalGrammarException {
        ILanguageSymbol<T> gsym = this.solveStringParameter(n);
        IFormalLanguage g = gsym.getLanguage();
        Collection<String> strs = this.stringValues(g);
        if (strs == null || strs.isEmpty()) {
            throw new IllegalGrammarException("strs is null or empty.");
        }
        return strs;
    }

    protected String solveStringConstantParameter(int n) throws IllegalGrammarException {
        Collection<String> strs = this.solveStringConstantParameters(n);
        if (strs.size() == 1) {
            return strs.iterator().next();
        }
        throw new IllegalGrammarException("too many strings are found.");
    }

    protected Collection<String> solveStringConstantParameters(ISymbol s) throws IllegalGrammarException {
        ILanguageSymbol<T> gsym = this.solveString(s);
        IFormalLanguage a = gsym.getLanguage();
        Collection<String> strs = this.stringValues(a);
        if (strs == null || strs.isEmpty()) {
            throw new IllegalGrammarException("strs is null or empty.");
        }
        return strs;
    }

    protected String solveStringConstantParameter(ISymbol s) throws IllegalGrammarException {
        Collection<String> strs = this.solveStringConstantParameters(s);
        if (strs.size() == 1) {
            return strs.iterator().next();
        }
        throw new IllegalGrammarException("too many strings are found.");
    }

    protected <U extends ISymbol> Set<U> solveConstantParameters(int n, Class<U> klass) throws IllegalGrammarException {
        ISymbol s = n == -1 ? this.recv : this.params.get(n);
        if (s instanceof IVariable) {
            return Grammars.constantValues((IGrammar)this.grammar, (IVariable)((IVariable)s), klass);
        }
        if (klass.isInstance(s)) {
            HashSet<ISymbol> objs = new HashSet<ISymbol>();
            objs.add(s);
            return objs;
        }
        throw new IllegalGrammarException("the grammar can't produce numbers.", (IGrammar)this.grammar);
    }

    protected <U extends ISymbol> U solveConstantParameter(int n, Class<U> klass) throws IllegalGrammarException {
        Set<Object> params = new HashSet();
        params = this.solveConstantParameters(n, klass);
        if (params.size() == 1) {
            return (U)((ISymbol)params.iterator().next());
        }
        throw new IllegalGrammarException("too many numbers are found.");
    }

    protected Set<NumberSymbol> solveNumberParameters(int n) throws IllegalGrammarException {
        return this.solveConstantParameters(n, NumberSymbol.class);
    }

    protected NumberSymbol solveNumberParameter(int n) throws IllegalGrammarException {
        return this.solveConstantParameter(n, NumberSymbol.class);
    }

    protected Collection<CharSymbol> solveCharParameters(int n) throws IllegalGrammarException {
        Set<ICharValueSymbol> ss = this.solveConstantParameters(n, ICharValueSymbol.class);
        HashSet<CharSymbol> as = new HashSet<CharSymbol>();
        for (ICharValueSymbol s : ss) {
            CharSymbol c = new CharSymbol(s.charValue());
            as.add(c);
        }
        return as;
    }

    protected CharSymbol solveCharParameter(int n) throws IllegalGrammarException {
        ICharValueSymbol c = this.solveConstantParameter(n, ICharValueSymbol.class);
        return new CharSymbol(c.charValue());
    }

    protected Set<BooleanSymbol> solveBooleanParameters(int n) throws IllegalGrammarException {
        return this.solveConstantParameters(n, BooleanSymbol.class);
    }

    protected BooleanSymbol solveBooleanParameter(int n) throws IllegalGrammarException {
        return this.solveConstantParameter(n, BooleanSymbol.class);
    }

    public class StringParamConv
    extends DefaultParamConv {
        @Override
        public ILanguageSymbol<T> convert(IValueSymbol s) {
            return BasicTranslator.this.createLanguageSymbol((IValueSymbol)s.stringSymbolValue());
        }
    }

    public class DefaultParamConv
    implements IParamConv<T> {
        @Override
        public ILanguageSymbol<T> convert(T g) {
            Collection<String> strs = BasicTranslator.this.stringValues(g, 2);
            if (strs != null && strs.size() == 1) {
                return this.convert((IValueSymbol)new StringSymbol(strs.iterator().next()));
            }
            return BasicTranslator.this.createLanguageSymbol(g);
        }

        @Override
        public ILanguageSymbol<T> convert(IValueSymbol s) {
            return BasicTranslator.this.createLanguageSymbol(s);
        }
    }

    public static interface IParamConv<U extends IFormalLanguage> {
        public ILanguageSymbol<U> convert(U var1);

        public ILanguageSymbol<U> convert(IValueSymbol var1);
    }
}

