/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Transducer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Sprintf
extends Transducer {
    public Sprintf(int target) {
        super(target);
    }

    public Sprintf() {
    }

    @Override
    public IAutomaton createTransducer() {
        State state;
        Variable v = new Variable("v");
        int argsLen = this.params.size() - 1;
        String[] args = new String[argsLen];
        for (int i = 0; i < argsLen; ++i) {
            args[i] = ((StringSymbol)this.solveParameter(i + 1)).getName();
        }
        final CharSymbol percentChar = new CharSymbol("%");
        final CharSymbol plusChar = new CharSymbol("+");
        final CharSymbol dChar = new CharSymbol("d");
        final CharSymbol[] typeSpecifier = new StringSymbol("dsfoxXbeuc").toCharSymbols().toArray(new CharSymbol[0]);
        HashSet<Object> transitions = new HashSet<Object>();
        State initState = state = new State("s0");
        HashSet<State> finalStates = new HashSet<State>();
        int stateIndex = 1;
        for (int i = 0; i < args.length; ++i) {
            State s1 = new State("s" + stateIndex++);
            State s2 = new State("s" + stateIndex++);
            State s3 = new State("s" + stateIndex++);
            State s4 = new State("s" + stateIndex++);
            State s5 = new State("s" + stateIndex++);
            finalStates.add(s1);
            finalStates.add(s2);
            finalStates.add(s3);
            finalStates.add(s4);
            finalStates.add(s5);
            final String arg = args[i];
            FilteredTransition t0 = new FilteredTransition((IState)state, (IState)state, (ISymbol)v, new ISymbol[]{v}, null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r;
                    boolean bl = r = !symbol.equals(percentChar);
                    if (r) {
                        System.err.println("(!symbol.equals(percentChar): accept " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t0);
            FilteredTransition t1 = new FilteredTransition((IState)state, (IState)s1, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = symbol.equals(percentChar);
                    if (r) {
                        System.err.println("(symbol.equals(percentChar) " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t1);
            FilteredTransition t2 = new FilteredTransition((IState)s1, (IState)s2, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = symbol.equals(plusChar);
                    if (r) {
                        System.err.println("(symbol.equals(plusChar) " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t2);
            FilteredTransition t3 = new FilteredTransition((IState)s2, (IState)s4, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

                public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                    if (symbol.equals(dChar)) {
                        return Sprintf.this.formatSignSpecifier(arg);
                    }
                    if (symbol.equals(percentChar)) {
                        return outputs;
                    }
                    outputs.clear();
                    return outputs;
                }
            }, null);
            transitions.add(t3);
            FilteredTransition t4 = new FilteredTransition((IState)s1, (IState)s3, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

                public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                    if (symbol.equals(typeSpecifier[0])) {
                        return Sprintf.this.formatStandardInteger(arg);
                    }
                    if (symbol.equals(typeSpecifier[1])) {
                        return Sprintf.this.formatString(arg);
                    }
                    if (symbol.equals(typeSpecifier[2])) {
                        return Sprintf.this.formatFloatingPoint(arg);
                    }
                    if (symbol.equals(typeSpecifier[3])) {
                        return Sprintf.this.formatOctal(arg);
                    }
                    if (symbol.equals(typeSpecifier[4])) {
                        return Sprintf.this.formatHexadecimalLowerCase(arg);
                    }
                    if (symbol.equals(typeSpecifier[5])) {
                        return Sprintf.this.formatHexadecimalUpperCase(arg);
                    }
                    if (symbol.equals(typeSpecifier[6])) {
                        return Sprintf.this.formatBinary(arg);
                    }
                    if (symbol.equals(typeSpecifier[7])) {
                        return Sprintf.this.formatScientificNotation(arg);
                    }
                    if (symbol.equals(typeSpecifier[8])) {
                        return Sprintf.this.formatUnsignedInteger(arg);
                    }
                    if (symbol.equals(typeSpecifier[9])) {
                        return Sprintf.this.printAsciiCharacter(arg);
                    }
                    return outputs;
                }
            }, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r;
                    boolean bl = r = !symbol.equals(percentChar) && !symbol.equals(plusChar);
                    if (r) {
                        System.err.println("(!symbol.equals(percentChar)) && (!symbol.equals(plusChar): accept " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t4);
            FilteredTransition t5 = new FilteredTransition((IState)s1, (IState)state, (ISymbol)v, new ISymbol[]{v}, null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = symbol.equals(percentChar);
                    if (r) {
                        System.err.println("(symbol.equals(percentChar): accept " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t5);
            Transition t6 = new Transition((IState)s3, (IState)s5, Transition.EpsilonSymbol);
            Transition t7 = new Transition((IState)s4, (IState)s5, Transition.EpsilonSymbol);
            transitions.add(t6);
            transitions.add(t7);
            state = s5;
        }
        Transition t = new Transition((IState)state, (IState)state, (ISymbol)v, new ISymbol[]{v});
        transitions.add(t);
        finalStates.add(state);
        Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
        return transducer;
    }

    protected List<ISymbol> printAsciiCharacter(String arg) {
        int argInt = 0;
        if (this.isNumber(arg)) {
            argInt = Integer.parseInt(arg);
        }
        Charset asciiCharset = Charset.forName("US-ASCII");
        CharsetDecoder decoder = asciiCharset.newDecoder();
        if (0 > argInt || argInt > 127) {
            return new ArrayList<ISymbol>();
        }
        byte b1 = (byte)argInt;
        byte[] b = new byte[]{b1};
        ByteBuffer asciiBytes = ByteBuffer.wrap(b);
        CharBuffer cBuf = null;
        try {
            cBuf = decoder.decode(asciiBytes);
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        StringSymbol strSym = new StringSymbol(cBuf.toString());
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatSignSpecifier(String arg) {
        int argInt = 0;
        if (this.isNumber(arg)) {
            argInt = Integer.parseInt(arg);
        }
        StringSymbol strSym = new StringSymbol(String.valueOf(argInt));
        if (argInt >= 0) {
            strSym = new StringSymbol("+" + String.valueOf(argInt));
        }
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatUnsignedInteger(String arg) {
        int argInt = 0;
        if (this.isNumber(arg)) {
            argInt = Integer.parseInt(arg);
        }
        double argDouble = argInt;
        if (argInt < 0) {
            argDouble = (double)argInt + Math.pow(2.0, 32.0);
            System.out.println(argDouble);
        }
        DecimalFormat df = new DecimalFormat("0");
        StringSymbol strSym = new StringSymbol(df.format(argDouble));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatScientificNotation(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        DecimalFormat df = new DecimalFormat("0.00000E0");
        String argStr = df.format(Double.parseDouble(arg));
        int ePos = argStr.indexOf("E");
        int minusPos = argStr.indexOf("-");
        if (minusPos < 0) {
            StringBuffer sb = new StringBuffer(argStr);
            sb.replace(ePos, ePos + 1, "e");
            sb.insert(ePos + 1, "+");
            argStr = sb.toString();
        }
        StringSymbol strSym = new StringSymbol(argStr);
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatBinary(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        StringSymbol strSym = new StringSymbol(Integer.toBinaryString(Integer.parseInt(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatHexadecimalUpperCase(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        String argStr = Integer.toHexString(Integer.parseInt(arg));
        StringSymbol strSym = new StringSymbol(argStr.toUpperCase());
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatHexadecimalLowerCase(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        StringSymbol strSym = new StringSymbol(Integer.toHexString(Integer.parseInt(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatOctal(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        StringSymbol strSym = new StringSymbol(Integer.toOctalString(Integer.parseInt(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatFloatingPoint(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        DecimalFormat df = new DecimalFormat("0.000000");
        StringSymbol strSym = new StringSymbol(df.format(Double.parseDouble(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatString(String arg) {
        StringSymbol strSym = new StringSymbol(arg);
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatStandardInteger(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        BigDecimal bigDecimal = new BigDecimal(arg);
        StringSymbol strSym = new StringSymbol(String.valueOf(bigDecimal.intValue()));
        return strSym.toSymbols();
    }

    private boolean isNumber(String arg) {
        char[] charArray = arg.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (!Character.isDigit(charArray[i])) continue;
            return true;
        }
        return false;
    }
}

