/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringTranslator;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ToString
extends StringTranslator {
    private PrimitiveType type;

    public ToString(int target, PrimitiveType type) {
        super(target);
        this.type = type;
    }

    public ToString(PrimitiveType type) {
        this.type = type;
    }

    public ToString(int target) {
        super(target);
        this.type = null;
    }

    public ToString() {
        this.type = null;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IContextFreeGrammar> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar g) {
        SimpleGrammar sg = super.prepare(translator, funcName, recv, params, rule, g);
        sg.getRules().remove(rule);
        sg.getRules().add(new ProductionRule(rule.getLeft(), params));
        return sg;
    }

    @Override
    public IContextFreeGrammar translate(IContextFreeGrammar cfg) {
        Set symbols;
        if (this.type == null) {
            return cfg;
        }
        HashSet<Object> terminals = new HashSet<Object>();
        HashSet<Object> strings = new HashSet<Object>();
        boolean useSign = false;
        if (this.type.equals((Object)JavaPrimitiveType.DOUBLE) || this.type.equals((Object)JavaPrimitiveType.FLOAT)) {
            try {
                symbols = Grammars.numberValues((IGrammar)cfg, (IVariable)cfg.getStartSymbol());
                for (NumberSymbol s : symbols) {
                    strings.add(new StringSymbol(Double.toString(s.doubleValue())));
                }
            }
            catch (IllegalGrammarException e) {
                terminals.add(new RangeSymbol('0', '9'));
                terminals.add(new CharSymbol('.'));
                useSign = true;
            }
        } else if (this.type.equals((Object)JavaPrimitiveType.INT) || this.type.equals((Object)JavaPrimitiveType.LONG) || this.type.equals((Object)JavaPrimitiveType.BYTE) || this.type.equals((Object)JavaPrimitiveType.SHORT)) {
            try {
                symbols = Grammars.numberValues((IGrammar)cfg, (IVariable)cfg.getStartSymbol());
                for (NumberSymbol s : symbols) {
                    strings.add(new StringSymbol(Long.toString(s.longValue())));
                }
            }
            catch (IllegalGrammarException e) {
                terminals.add(new RangeSymbol('0', '9'));
                useSign = true;
            }
        } else if (this.type.equals((Object)JavaPrimitiveType.CHAR)) {
            try {
                symbols = Grammars.constantValues((IGrammar)cfg, (IVariable)cfg.getStartSymbol(), ISymbol.class);
                for (ISymbol s : symbols) {
                    if (s instanceof NumberSymbol) {
                        NumberSymbol n = (NumberSymbol)s;
                        strings.add(new CharSymbol((char)n.intValue()));
                        continue;
                    }
                    if (s instanceof CharSymbol) {
                        strings.add(s);
                        continue;
                    }
                    if (!(s instanceof RangeSymbol)) continue;
                    strings.add(s);
                }
            }
            catch (IllegalGrammarException e) {
                terminals.add(new RangeSymbol('\u0000', '\uffff'));
            }
        } else if (this.type.equals((Object)JavaPrimitiveType.BOOLEAN)) {
            try {
                symbols = Grammars.numberValues((IGrammar)cfg, (IVariable)cfg.getStartSymbol());
                for (NumberSymbol s : symbols) {
                    strings.add(new StringSymbol(s.intValue() == 0 ? "false" : "true"));
                }
            }
            catch (IllegalGrammarException e) {
                terminals.add(new StringSymbol("true"));
                terminals.add(new StringSymbol("false"));
            }
        } else {
            Assertions.UNREACHABLE((Object)this.type);
        }
        if (terminals.isEmpty()) {
            return this.unionStringsAsCFG(strings);
        }
        IContextFreeGrammar result = this.possibleStringsAsCFG(terminals, false);
        if (useSign) {
            IVariable v = this.createVariable();
            result.addRule((IProductionRule)new ProductionRule(v, (ISymbol)result.getStartSymbol()));
            result.addRule((IProductionRule)new ProductionRule(v, new ISymbol[]{new CharSymbol('-'), result.getStartSymbol()}));
            result.setStartSymbol(v);
        }
        return result;
    }

    public IContextFreeGrammar translateCyclic(IContextFreeGrammar cfg, Set<ISymbol> terminals) {
        return this.translate(cfg);
    }

    public Set<ISymbol> possibleOutputs(Set<ISymbol> terminals) {
        return terminals;
    }

    public boolean acceptCyclic() {
        return true;
    }
}

