/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Transducer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Chr
extends Transducer {
    public Chr(int target) {
        super(target);
    }

    public Chr() {
    }

    @Override
    public IAutomaton createTransducer() {
        State s0;
        Variable v = new Variable("v");
        HashSet<FilteredTransition> transitions = new HashSet<FilteredTransition>();
        State initState = s0 = new State("s0");
        HashSet<State> finalStates = new HashSet<State>();
        finalStates.add(s0);
        FilteredTransition t = new FilteredTransition((IState)s0, (IState)s0, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                ArrayList<ISymbol> newOutputs = new ArrayList<ISymbol>();
                if (symbol instanceof NumberSymbol) {
                    try {
                        newOutputs.addAll(Chr.this.generateAsciiCharacter(((NumberSymbol)symbol).intValue()));
                    }
                    catch (AsciiOutOfBoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                return newOutputs;
            }
        }, null);
        transitions.add(t);
        Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
        return transducer;
    }

    protected List<CharSymbol> generateAsciiCharacter(int argInt) throws AsciiOutOfBoundException {
        Charset asciiCharset = Charset.forName("US-ASCII");
        CharsetDecoder decoder = asciiCharset.newDecoder();
        if (0 > argInt || argInt > 127) {
            throw new AsciiOutOfBoundException(argInt);
        }
        byte b1 = (byte)argInt;
        byte[] b = new byte[]{b1};
        ByteBuffer asciiBytes = ByteBuffer.wrap(b);
        CharBuffer cBuf = null;
        try {
            cBuf = decoder.decode(asciiBytes);
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        StringSymbol strSym = new StringSymbol(cBuf.toString());
        return strSym.toCharSymbols();
    }

    protected class AsciiOutOfBoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AsciiOutOfBoundException(int i) {
            super("AsciiOutOfBoundException");
        }
    }
}

